/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.util.Result;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.v3.services.impl.DynamicConfigListener;
import com.sun.enterprise.v3.services.impl.Endpoint;
import com.sun.enterprise.v3.services.impl.GrizzlyProxy;
import com.sun.enterprise.v3.services.impl.MapperUpdateListener;
import com.sun.enterprise.v3.services.impl.NetworkProxy;
import com.sun.enterprise.v3.services.impl.monitor.GrizzlyMonitoring;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.FutureProvider;
import org.glassfish.api.container.Adapter;
import org.glassfish.api.container.EndpointRegistrationException;
import org.glassfish.api.container.RequestDispatcher;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.api.event.RestrictTo;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.config.GenericGrizzlyListener;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.NetworkListeners;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.grizzly.http.HttpCodecFilter;
import org.glassfish.grizzly.http.HttpProbe;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.util.Mapper;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.utils.Futures;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.hk2.api.Rank;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.kernel.KernelLoggerInfo;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.ObservableBean;
import org.jvnet.hk2.config.Transactions;

@Service
@RunLevel(value=10)
@Rank(value=50)
public class GrizzlyService
implements RequestDispatcher,
PostConstruct,
PreDestroy,
EventListener,
FutureProvider<Result<Thread>> {
    private static final Logger LOGGER = KernelLoggerInfo.getLogger();
    private static final String NETWORK_CONFIG_PREFIX = "";
    private final Set<MapperUpdateListener> mapperUpdateListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Collection<NetworkProxy> proxies = new LinkedBlockingQueue<NetworkProxy>();
    private final GrizzlyMonitoring monitoring;
    private final ReentrantReadWriteLock mapperLock = new ReentrantReadWriteLock();
    private final FutureImpl<Boolean> serverReadyFuture = Futures.createSafeFuture();
    private final Queue<Callable<Void>> serverReadyListeners = new ConcurrentLinkedQueue<Callable<Void>>();
    volatile List<Future<Result<Thread>>> futures;
    Collection<String> hosts = new ArrayList<String>();
    private DynamicConfigListener configListener;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @Inject
    private ServiceLocator serviceLocator;
    @Inject
    Transactions transactions;
    @Inject
    Events events;

    public GrizzlyService() {
        this.futures = new ArrayList<Future<Result<Thread>>>();
        this.monitoring = new GrizzlyMonitoring();
    }

    public void addNetworkProxy(NetworkProxy proxy) {
        this.proxies.add(proxy);
    }

    public boolean removeNetworkProxy(NetworkListener listener) {
        return this.removeNetworkProxy(this.lookupNetworkProxy(listener));
    }

    public boolean removeNetworkProxy(String id) {
        return this.removeNetworkProxy(this.getNetworkProxy(id));
    }

    private NetworkProxy getNetworkProxy(String id) {
        NetworkProxy proxyToReturn = null;
        for (NetworkProxy networkProxy : this.proxies) {
            if (!(networkProxy instanceof GrizzlyProxy)) continue;
            GrizzlyProxy grizzlyProxy = (GrizzlyProxy)networkProxy;
            if (grizzlyProxy.networkListener == null || grizzlyProxy.networkListener.getName() == null || !grizzlyProxy.networkListener.getName().equals(id)) continue;
            proxyToReturn = networkProxy;
            break;
        }
        return proxyToReturn;
    }

    public boolean removeNetworkProxy(NetworkProxy proxy) {
        if (proxy != null) {
            try {
                proxy.stop();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "NCLS-CORE-00055", e);
            }
            proxy.destroy();
            this.proxies.remove(proxy);
            return true;
        }
        return false;
    }

    public NetworkProxy lookupNetworkProxy(NetworkListener listener) {
        int listenerPort = -1;
        InetAddress address = null;
        try {
            listenerPort = Integer.parseInt(listener.getPort());
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.FINE, e.toString());
        }
        try {
            address = InetAddress.getByName(listener.getAddress());
        }
        catch (UnknownHostException uhe) {
            LOGGER.log(Level.FINE, uhe.toString());
        }
        if (listenerPort != -1) {
            for (NetworkProxy p : this.proxies) {
                if (p.getPort() != listenerPort || !p.getAddress().equals(address)) continue;
                return p;
            }
        }
        String listenerId = listener.getName();
        for (NetworkProxy p : this.proxies) {
            if (!(p instanceof GrizzlyProxy)) continue;
            GrizzlyProxy grizzlyProxy = (GrizzlyProxy)p;
            if (grizzlyProxy.networkListener == null || grizzlyProxy.networkListener.getName() == null || !grizzlyProxy.networkListener.getName().equals(listenerId)) continue;
            return p;
        }
        return null;
    }

    public void restartNetworkListener(String networkListenerName, long timeout, TimeUnit timeUnit) throws IOException, TimeoutException {
        this.restartNetworkListener(this.config.getNetworkConfig().getNetworkListener(networkListenerName), timeout, timeUnit);
    }

    public void restartNetworkListener(NetworkListener networkListener, long timeout, TimeUnit timeUnit) throws IOException, TimeoutException {
        Future<Result<Thread>> future;
        NetworkProxy proxy = this.lookupNetworkProxy(networkListener);
        HashMap filterToProbeMapping = new HashMap();
        if (proxy == null) {
            proxy = this.getNetworkProxy(networkListener.getName());
        }
        if (proxy != null) {
            GrizzlyProxy grizzlyProxy;
            GenericGrizzlyListener grizzlyListener;
            List<HttpCodecFilter> codecFilters;
            if (proxy instanceof GrizzlyProxy && (codecFilters = (grizzlyListener = (GenericGrizzlyListener)(grizzlyProxy = (GrizzlyProxy)proxy).getUnderlyingListener()).getFilters(HttpCodecFilter.class)) != null && !codecFilters.isEmpty()) {
                for (HttpCodecFilter codecFilter : codecFilters) {
                    HttpProbe[] probes = codecFilter.getMonitoringConfig().getProbes();
                    if (probes == null) continue;
                    ArrayList probesForType = (ArrayList)filterToProbeMapping.get(codecFilter.getClass());
                    if (probesForType == null) {
                        probesForType = new ArrayList(4);
                        filterToProbeMapping.put(codecFilter.getClass(), probesForType);
                    }
                    Collections.addAll(probesForType, probes);
                }
            }
            this.removeNetworkProxy(proxy);
        }
        if ((future = this.createNetworkProxy(networkListener)) == null) {
            LOGGER.log(Level.FINE, "Skipping proxy registration for the listener {0}", networkListener.getName());
            return;
        }
        try {
            if (timeout <= 0L) {
                future.get();
            } else {
                future.get(timeout, timeUnit);
            }
            NetworkProxy newNetworkProxy = this.getNetworkProxy(networkListener.getName());
            if (newNetworkProxy instanceof GrizzlyProxy) {
                GrizzlyProxy grizzlyProxy = (GrizzlyProxy)newNetworkProxy;
                GenericGrizzlyListener grizzlyListener = (GenericGrizzlyListener)grizzlyProxy.getUnderlyingListener();
                if (!filterToProbeMapping.isEmpty()) {
                    for (Class aClass : filterToProbeMapping.keySet()) {
                        List filters = grizzlyListener.getFilters(aClass);
                        if (filters == null || filters.isEmpty()) continue;
                        if (filters.size() != 1) {
                            throw new IllegalStateException();
                        }
                        List probes = (List)filterToProbeMapping.get(aClass);
                        ((HttpCodecFilter)filters.get(0)).getMonitoringConfig().addProbes((HttpProbe[])probes.toArray(new HttpProbe[probes.size()]));
                    }
                }
            }
        }
        catch (ExecutionException e) {
            throw new IOException(e.getCause());
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        this.registerContainerAdapters();
    }

    public boolean hasMapperUpdateListener() {
        return !this.mapperUpdateListeners.isEmpty();
    }

    public boolean addMapperUpdateListener(MapperUpdateListener listener) {
        return this.mapperUpdateListeners.add(listener);
    }

    public boolean removeMapperUpdateListener(MapperUpdateListener listener) {
        return this.mapperUpdateListeners.remove(listener);
    }

    public void notifyMapperUpdateListeners(NetworkListener networkListener, Mapper mapper) {
        HttpService httpService = this.config.getHttpService();
        for (MapperUpdateListener listener : this.mapperUpdateListeners) {
            listener.update(httpService, networkListener, mapper);
        }
    }

    public ReentrantReadWriteLock obtainMapperLock() {
        return this.mapperLock;
    }

    public Logger getLogger() {
        return LOGGER;
    }

    public ServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }

    public GrizzlyMonitoring getMonitoring() {
        return this.monitoring;
    }

    final Future<Boolean> getServerReadyFuture() {
        return this.serverReadyFuture;
    }

    final void addServerReadyListener(Callable<Void> listener) {
        if (this.serverReadyFuture.isDone()) {
            try {
                listener.call();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        this.serverReadyListeners.add(listener);
        if (this.serverReadyFuture.isDone() && this.serverReadyListeners.remove(listener)) {
            try {
                listener.call();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    final boolean removeServerListener(Callable<Void> listener) {
        return this.serverReadyListeners.remove(listener);
    }

    @Override
    public void event(@RestrictTo(value="server_ready") EventListener.Event<?> event) {
        if (event.is(EventTypes.SERVER_READY)) {
            Callable<Void> listener;
            this.serverReadyFuture.result(Boolean.TRUE);
            while ((listener = this.serverReadyListeners.poll()) != null) {
                try {
                    listener.call();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void postConstruct() {
        this.events.register(this);
        NetworkConfig networkConfig = this.config.getNetworkConfig();
        this.configListener = new DynamicConfigListener(this.config, LOGGER);
        ObservableBean bean = (ObservableBean)((Object)ConfigSupport.getImpl(networkConfig.getNetworkListeners()));
        bean.addListener(this.configListener);
        bean = (ObservableBean)((Object)ConfigSupport.getImpl(this.config.getHttpService()));
        bean.addListener(this.configListener);
        this.transactions.addListenerForType(SystemProperty.class, this.configListener);
        this.configListener.setGrizzlyService(this);
        try {
            boolean isAtLeastOneProxyStarted = false;
            this.futures = new ArrayList<Future<Result<Thread>>>();
            for (NetworkListener listener : networkConfig.getNetworkListeners().getNetworkListener()) {
                isAtLeastOneProxyStarted |= this.createNetworkProxy(listener) != null;
            }
            if (isAtLeastOneProxyStarted) {
                this.registerContainerAdapters();
            }
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.SEVERE, "NCLS-CORE-00056", e);
            for (NetworkProxy proxy : this.proxies) {
                try {
                    proxy.stop();
                }
                catch (Exception proxyStopException) {
                    LOGGER.log(Level.SEVERE, "NCLS-CORE-00057", new Object[]{proxy.getPort(), proxyStopException});
                }
            }
            throw e;
        }
        this.registerMonitoringStatsProviders();
    }

    @Override
    public List<Future<Result<Thread>>> getFutures() {
        return this.futures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Future<Result<Thread>> createNetworkProxy(NetworkListener listener) {
        if (!Boolean.valueOf(listener.getEnabled()).booleanValue()) {
            this.addChangeListener(listener);
            LOGGER.log(Level.INFO, "NCLS-CORE-00058", new Object[]{listener.getName(), listener.getPort()});
            return null;
        }
        GrizzlyProxy proxy = new GrizzlyProxy(this, listener);
        Future<Result<Thread>> future = null;
        try {
            proxy.initialize();
            if (!GrizzlyService.isLightWeightListener(listener)) {
                NetworkConfig networkConfig = listener.getParent(NetworkListeners.class).getParent(NetworkConfig.class);
                for (VirtualServer vs : networkConfig.getParent(Config.class).getHttpService().getVirtualServer()) {
                    List<String> vsListeners = StringUtils.parseStringList(vs.getNetworkListeners(), " ,");
                    if (vsListeners != null && !vsListeners.isEmpty() && !vsListeners.contains(listener.getName()) || this.hosts.contains(vs.getId())) continue;
                    this.hosts.add(vs.getId());
                }
                this.addChangeListener(listener);
                this.addChangeListener(listener.findThreadPool());
                this.addChangeListener(listener.findTransport());
                Protocol protocol = listener.findHttpProtocol();
                if (protocol != null) {
                    this.addChangeListener(protocol);
                    this.addChangeListener(protocol.getHttp());
                    this.addChangeListener(protocol.getHttp().getFileCache());
                    this.addChangeListener(protocol.getSsl());
                }
            }
            future = proxy.start();
            this.proxies.add(proxy);
        }
        catch (Throwable e) {
            GrizzlyFuture errorFuture = Futures.createReadyFuture(new Result(e));
            future = errorFuture;
        }
        finally {
            if (future == null) {
                FutureImpl<Result<Thread>> errorFuture = Futures.createUnsafeFuture();
                errorFuture.result(new Result(new IllegalStateException("Unexpected error")));
                future = errorFuture;
            }
            this.futures.add(future);
        }
        return future;
    }

    private void addChangeListener(ConfigBeanProxy bean) {
        if (bean != null) {
            ((ObservableBean)((Object)ConfigSupport.getImpl(bean))).addListener(this.configListener);
        }
    }

    void registerContainerAdapters() {
        for (Adapter subAdapter : this.serviceLocator.getAllServices(Adapter.class, new Annotation[0])) {
            try {
                if (subAdapter.isRegistered()) continue;
                this.registerAdapter(subAdapter);
                subAdapter.setRegistered(true);
            }
            catch (EndpointRegistrationException e) {
                LOGGER.log(Level.WARNING, "NCLS-CORE-00059", e);
            }
        }
    }

    @Override
    public void preDestroy() {
        for (NetworkProxy proxy : this.proxies) {
            try {
                proxy.stop();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "NCLS-CORE-00055", e);
            }
        }
        this.unregisterMonitoringStatsProviders();
    }

    @Override
    public void registerEndpoint(String contextRoot, HttpHandler endpointAdapter, ApplicationContainer container) throws EndpointRegistrationException {
        this.registerEndpoint(contextRoot, endpointAdapter, container, null);
    }

    @Override
    public void registerEndpoint(String contextRoot, HttpHandler endpointAdapter, ApplicationContainer container, String virtualServers) throws EndpointRegistrationException {
        List<String> virtualServerList = virtualServers == null ? this.config.getHttpService().getNonAdminVirtualServerList() : StringUtils.parseStringList(virtualServers, ",");
        this.registerEndpoint(contextRoot, virtualServerList, endpointAdapter, container);
    }

    @Override
    public void registerEndpoint(String contextRoot, Collection<String> vsServers, HttpHandler endpointAdapter, ApplicationContainer container) throws EndpointRegistrationException {
        List<AddressInfo> addressInfos = this.getAddressInfoFromVirtualServers(vsServers);
        for (AddressInfo info : addressInfos) {
            this.registerEndpoint(contextRoot, info.address, info.port, vsServers, endpointAdapter, container);
        }
    }

    @Override
    public void registerEndpoint(String contextRoot, InetAddress address, int port, Collection<String> vsServers, HttpHandler endpointAdapter, ApplicationContainer container) throws EndpointRegistrationException {
        for (NetworkProxy proxy : this.proxies) {
            if (proxy.getPort() != port || !proxy.getAddress().equals(address)) continue;
            proxy.registerEndpoint(contextRoot, vsServers, endpointAdapter, container);
        }
    }

    public void registerEndpoint(Endpoint endpoint) throws EndpointRegistrationException {
        InetAddress address = endpoint.getAddress();
        int port = endpoint.getPort();
        for (NetworkProxy proxy : this.proxies) {
            if (proxy.getPort() != port || !proxy.getAddress().equals(address)) continue;
            proxy.registerEndpoint(endpoint);
        }
    }

    @Override
    public void unregisterEndpoint(String contextRoot) throws EndpointRegistrationException {
        this.unregisterEndpoint(contextRoot, null);
    }

    @Override
    public void unregisterEndpoint(String contextRoot, ApplicationContainer app) throws EndpointRegistrationException {
        for (NetworkProxy proxy : this.proxies) {
            proxy.unregisterEndpoint(contextRoot, app);
        }
    }

    protected void registerMonitoringStatsProviders() {
        this.monitoring.registerThreadPoolStatsProviderGlobal(NETWORK_CONFIG_PREFIX);
        this.monitoring.registerKeepAliveStatsProviderGlobal(NETWORK_CONFIG_PREFIX);
        this.monitoring.registerFileCacheStatsProviderGlobal(NETWORK_CONFIG_PREFIX);
        this.monitoring.registerConnectionQueueStatsProviderGlobal(NETWORK_CONFIG_PREFIX);
    }

    protected void unregisterMonitoringStatsProviders() {
        this.monitoring.unregisterThreadPoolStatsProviderGlobal(NETWORK_CONFIG_PREFIX);
        this.monitoring.unregisterKeepAliveStatsProviderGlobal(NETWORK_CONFIG_PREFIX);
        this.monitoring.unregisterFileCacheStatsProviderGlobal(NETWORK_CONFIG_PREFIX);
        this.monitoring.unregisterConnectionQueueStatsProviderGlobal(NETWORK_CONFIG_PREFIX);
    }

    private void registerAdapter(Adapter a) throws EndpointRegistrationException {
        Endpoint endpoint = Endpoint.createEndpoint(a);
        this.registerEndpoint(endpoint);
    }

    private List<AddressInfo> getAddressInfoFromVirtualServers(Collection<String> virtualServerNames) {
        ArrayList<AddressInfo> addressInfos = new ArrayList<AddressInfo>();
        List<NetworkListener> networkListenerList = this.config.getNetworkConfig().getNetworkListeners().getNetworkListener();
        for (String virtualServerName : virtualServerNames) {
            VirtualServer virtualServer = this.config.getHttpService().getVirtualServerByName(virtualServerName);
            if (virtualServer == null) {
                LOGGER.log(Level.WARNING, "NCLS-CORE-00060", virtualServerName);
                continue;
            }
            String vsNetworkListeners = virtualServer.getNetworkListeners();
            List<String> vsNetworkListenerList = StringUtils.parseStringList(vsNetworkListeners, ",");
            if (vsNetworkListenerList == null || vsNetworkListenerList.isEmpty()) continue;
            block1: for (String vsNetworkListener : vsNetworkListenerList) {
                for (NetworkListener networkListener : networkListenerList) {
                    if (!networkListener.getName().equals(vsNetworkListener) || !Boolean.valueOf(networkListener.getEnabled()).booleanValue()) continue;
                    addressInfos.add(new AddressInfo(networkListener.getAddress(), networkListener.getPort()));
                    continue block1;
                }
            }
        }
        return addressInfos;
    }

    static boolean isLightWeightListener(NetworkListener listener) {
        return "proxy".equalsIgnoreCase(listener.getType()) || "light-weight-listener".equalsIgnoreCase(listener.getProtocol());
    }

    private static final class AddressInfo {
        private InetAddress address;
        private final int port;

        private AddressInfo(String address, String port) {
            this.port = Integer.parseInt(port);
            try {
                this.address = InetAddress.getByName(address);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
    }

    public static class NoopInvocationHandler
    implements InvocationHandler {
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            return null;
        }
    }
}

