/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.commands;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.AdminCommandJob;
import jakarta.inject.Inject;
import org.glassfish.admin.payload.PayloadImpl;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.JobManager;
import org.glassfish.api.admin.Payload;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="_get-payload")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="getpayload")
@AccessRequired(resource={"jobs/job/$jobID"}, action={"read"})
public class GetPayloadCommand
implements AdminCommand {
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(GetPayloadCommand.class);
    @Inject
    private JobManager<AdminCommandJob> registry;
    @Param(primary=true, optional=false, multiple=false)
    private String jobID;

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport ar = context.getActionReport();
        AdminCommandJob job = this.registry.get(this.jobID);
        if (job == null) {
            ar.setActionExitCode(ActionReport.ExitCode.FAILURE);
            ar.setMessage(strings.getLocalString("getPayload.wrong.commandinstance.id", "Command instance {0} does not exist.", this.jobID));
            return;
        }
        Payload.Outbound jobPayload = job.getPayload();
        if (jobPayload == null) {
            ar.setMessage(strings.getLocalString("getPayload.nopayload", "Outbound payload does not exist."));
            return;
        }
        Payload.Outbound paylaod = context.getOutboundPayload();
        if (paylaod instanceof PayloadImpl.Outbound && jobPayload instanceof PayloadImpl.Outbound) {
            PayloadImpl.Outbound destination = (PayloadImpl.Outbound)paylaod;
            PayloadImpl.Outbound source = (PayloadImpl.Outbound)jobPayload;
            destination.getParts().addAll(source.getParts());
        } else {
            ar.setActionExitCode(ActionReport.ExitCode.FAILURE);
            ar.setMessage(strings.getLocalString("getPayload.unsupported", "Payload type is not supported. Can not download data."));
        }
    }
}

