/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.commands;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ThreadPools;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.commands.CLIUtil;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.beans.PropertyVetoException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.grizzly.config.dom.ThreadPool;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-threadpool")
@PerLookup
@I18n(value="create.threadpool")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class CreateThreadpool
implements AdminCommand,
AdminCommandSecurity.Preauthorization {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateThreadpool.class);
    @Param(name="maxthreadpoolsize", optional=true, alias="maxThreadPoolSize", defaultValue="5")
    String maxthreadpoolsize;
    @Param(name="minthreadpoolsize", optional=true, alias="minThreadPoolSize", defaultValue="2")
    String minthreadpoolsize;
    @Param(name="idletimeout", optional=true, alias="idleThreadTimeoutSeconds", defaultValue="900")
    String idletimeout;
    @Param(name="workqueues", optional=true)
    String workqueues;
    @Param(name="maxqueuesize", optional=true, alias="maxQueueSize", defaultValue="4096")
    String maxQueueSize;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Param(name="threadpool_id", primary=true)
    String threadpool_id;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @Inject
    Domain domain;
    @Inject
    ServiceLocator habitat;
    @AccessRequired.NewChild(type=ThreadPool.class)
    private ThreadPools threadPools;

    @Override
    public boolean preAuthorization(AdminCommandContext context) {
        this.config = CLIUtil.updateConfigIfNeeded(this.config, this.target, this.habitat);
        this.threadPools = this.config.getThreadPools();
        for (ThreadPool pool : this.threadPools.getThreadPool()) {
            ActionReport report = context.getActionReport();
            if (!pool.getName().equals(this.threadpool_id)) continue;
            report.setMessage(localStrings.getLocalString("create.threadpool.duplicate", "Thread Pool named {0} already exists.", this.threadpool_id));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        return true;
    }

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (this.workqueues != null) {
            report.setMessage(localStrings.getLocalString("create.threadpool.deprecated.workqueues", "Deprecated Syntax: --workqueues option is deprecated for create-threadpool command."));
        }
        try {
            ConfigSupport.apply(new SingleConfigCode<ThreadPools>(){

                @Override
                public Object run(ThreadPools param) throws PropertyVetoException, TransactionFailure {
                    ThreadPool newPool = param.createChild(ThreadPool.class);
                    newPool.setName(CreateThreadpool.this.threadpool_id);
                    newPool.setMaxThreadPoolSize(CreateThreadpool.this.maxthreadpoolsize);
                    newPool.setMinThreadPoolSize(CreateThreadpool.this.minthreadpoolsize);
                    newPool.setMaxQueueSize(CreateThreadpool.this.maxQueueSize);
                    newPool.setIdleThreadTimeoutSeconds(CreateThreadpool.this.idletimeout);
                    param.getThreadPool().add(newPool);
                    return newPool;
                }
            }, this.threadPools);
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (TransactionFailure e) {
            String str = e.getMessage();
            String def = "Creation of: " + this.threadpool_id + "failed because of: " + str;
            String msg = localStrings.getLocalString("create.threadpool.failed", def, this.threadpool_id, str);
            report.setMessage(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
        }
    }
}

