/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.admin.util.ClusterOperationUtil;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.v3.admin.Strings;
import com.sun.enterprise.v3.admin.V2DottedNameSupport;
import com.sun.enterprise.v3.common.ActionReporter;
import jakarta.inject.Inject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Proxy;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.external.statistics.Statistic;
import org.glassfish.external.statistics.Stats;
import org.glassfish.external.statistics.impl.StatisticImpl;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.flashlight.datatree.TreeNode;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;

@Service(name="MonitoringReporter")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
public class MonitoringReporter
extends V2DottedNameSupport {
    private static final System.Logger LOG = System.getLogger(MonitoringReporter.class.getName());
    private final TreeMap<String, Object> nodeTreeToProcess = new TreeMap();
    private List<TreeNode> nodeListToProcess = new ArrayList<TreeNode>();
    private List<Server> targets = new ArrayList<Server>();
    private ActionReporter reporter;
    private AdminCommandContext context;
    private String pattern;
    private String userarg;
    @Inject
    @Optional
    private MonitoringRuntimeDataRegistry datareg;
    @Inject
    private Domain domain;
    @Inject
    private Target targetService;
    @Inject
    private ServerEnvironment serverEnv;
    @Inject
    private ServiceLocator habitat;
    private OutputType outputType;
    private static final String DOTTED_NAME = ".dotted-name";
    private boolean targetIsMultiInstanceCluster;
    private String targetName;
    private Boolean aggregateDataOnly = Boolean.FALSE;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nPattern=[").append(this.pattern).append("]").append('\n');
        if (!this.targets.isEmpty()) {
            for (Server server : this.targets) {
                if (server == null) continue;
                sb.append("Server=[").append(server.getName()).append("]").append('\n');
            }
        } else {
            sb.append("No Targets");
        }
        return sb.toString();
    }

    public void prepareGet(AdminCommandContext c, String arg, Boolean data) {
        LOG.log(System.Logger.Level.DEBUG, "prepareGet(c={0}, arg={1}, data={2})", c, arg, data);
        this.aggregateDataOnly = data;
        this.prepare(c, arg, OutputType.GET);
    }

    public Collection<? extends AccessRequired.AccessCheck> getAccessChecksForGet() {
        ArrayList accessChecks = new ArrayList();
        for (String key : this.nodeTreeToProcess.keySet()) {
            String name = key.replace('.', '/');
            accessChecks.add(new AccessRequired.AccessCheck(this.sanitizeResourceName(name), "read"));
        }
        return accessChecks;
    }

    public Collection<? extends AccessRequired.AccessCheck> getAccessChecksForList() {
        ArrayList accessChecks = new ArrayList();
        for (TreeNode tn1 : this.nodeListToProcess) {
            String name = tn1.getCompletePathName().replace('.', '/');
            accessChecks.add(new AccessRequired.AccessCheck(this.sanitizeResourceName(name), "read"));
        }
        return accessChecks;
    }

    private String sanitizeResourceName(String resourceName) {
        return StringUtils.replace(resourceName, "[", "_ARRAY_");
    }

    public void prepareList(AdminCommandContext c, String arg) {
        this.prepare(c, arg, OutputType.LIST);
    }

    public void execute() {
        if (this.hasError()) {
            LOG.log(System.Logger.Level.DEBUG, "Error detected, returning.");
            return;
        }
        this.runLocally();
        this.runRemotely();
        if (this.targetIsMultiInstanceCluster && this.isInstanceRunning()) {
            this.runAggregate();
        }
    }

    private boolean isInstanceRunning() {
        int num = 0;
        List<Server> allServers = this.targetService.getAllInstances();
        for (Server server : allServers) {
            if (!server.isListeningOnAdminPort()) continue;
            ++num;
        }
        return num >= 2;
    }

    private void runAggregate() {
        this.setClusterInfo(this.reporter.addSubActionsReport(), this.getOutputLines());
    }

    private List<String> getOutputLines() {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.reporter.writeReport(os);
            String outputMessage = os.toString(StandardCharsets.UTF_8);
            String[] lines = outputMessage.split("\\n");
            return Arrays.asList(lines);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void setClusterInfo(ActionReport aggregateReporter, List<String> list) {
        int i;
        ArrayList data = new ArrayList(this.targets.size());
        for (i = 0; i < this.targets.size(); ++i) {
            data.add(new HashMap());
        }
        HashMap<String, String> clusterInfo = new HashMap<String, String>();
        int instanceCount = 0;
        for (Server server : this.targets) {
            String instanceName = server.getName();
            Map instanceMap = (Map)data.get(instanceCount);
            String key = null;
            for (String str : list) {
                String lastSampleTime;
                if (str.contains(instanceName) && str.contains("-count =")) {
                    ArrayList<String> kv = this.getKeyValuePair(str, instanceName);
                    key = kv.get(0);
                    instanceMap.put(kv.get(0), kv.get(1));
                }
                if (key == null) continue;
                String desc = key.substring(0, key.indexOf("-count")) + "-description";
                if (str.contains(desc)) {
                    ArrayList<String> kv = this.getKeyValuePair(str, instanceName);
                    clusterInfo.put(kv.get(0), kv.get(1));
                }
                if (!str.contains(lastSampleTime = key.substring(0, key.indexOf("-count")) + "-lastsampletime")) continue;
                ArrayList<String> kv = this.getKeyValuePair(str, instanceName);
                clusterInfo.put((String)instanceName + "." + kv.get(0), kv.get(1));
                key = null;
            }
            ++instanceCount;
        }
        List<Server> allServers = this.targetService.getAllInstances();
        Object instanceListStr = "";
        i = 0;
        for (Server server : allServers) {
            if (!server.isListeningOnAdminPort()) continue;
            instanceListStr = i == 0 ? server.getName() : (String)instanceListStr + ", " + server.getName();
            ++i;
        }
        aggregateReporter.appendMessage("\nComputed Aggregate Data for " + i + " instances: " + (String)instanceListStr + " in cluster " + this.targetName + " :\n");
        boolean noData = true;
        HashMap h = (HashMap)data.get(0);
        for (String s : h.keySet()) {
            int total = 0;
            int max = 0;
            int min = 0;
            int index = 0;
            float avg = 0.0f;
            int[] values = new int[data.size()];
            boolean nullValue = false;
            for (Map map : data) {
                String tmp = (String)map.get(s);
                if (tmp == null) {
                    nullValue = true;
                    break;
                }
                int count = Integer.parseInt(tmp);
                values[index++] = count;
                total += count;
            }
            if (nullValue) continue;
            noData = false;
            Arrays.sort(values);
            min = values[0];
            max = values[values.length - 1];
            avg = (float)total / (float)data.size();
            String descKey = s.substring(0, s.length() - 5) + "description";
            aggregateReporter.appendMessage(this.targetName + "." + s + "-total = " + total + "\n");
            aggregateReporter.appendMessage(this.targetName + "." + s + "-avg = " + avg + "\n");
            aggregateReporter.appendMessage(this.targetName + "." + s + "-max = " + max + "\n");
            aggregateReporter.appendMessage(this.targetName + "." + s + "-min = " + min + "\n");
            aggregateReporter.appendMessage(this.targetName + "." + descKey + " = " + (String)clusterInfo.get(descKey) + "\n");
            String string = s.substring(0, s.length() - 5) + "lastsampletime";
            long sampletime = this.getLastSampleTime(clusterInfo, string, data.size());
            aggregateReporter.appendMessage(this.targetName + "." + string + " = " + sampletime + "\n");
        }
        if (noData) {
            aggregateReporter.appendMessage("No aggregated cluster data to report\n");
        }
    }

    private ArrayList<String> getKeyValuePair(String str, String instanceName) {
        ArrayList<String> list = new ArrayList<String>(2);
        String key = null;
        String value = null;
        if (str != null) {
            key = str.substring(0, str.lastIndexOf(61));
            key = key.substring(instanceName.length() + 1).trim();
            value = str.substring(str.lastIndexOf(61) + 1, str.length()).trim();
        }
        list.add(0, key);
        list.add(1, value);
        return list;
    }

    private long getLastSampleTime(HashMap<String, String> clusterInfo, String lastSampleTimeKey, int numofInstances) {
        long[] values = new long[numofInstances];
        int index = 0;
        for (Map.Entry<String, String> entry : clusterInfo.entrySet()) {
            if (!entry.getKey().contains(lastSampleTimeKey)) continue;
            values[index++] = Long.parseLong(entry.getValue());
        }
        Arrays.sort(values);
        return values[values.length - 1];
    }

    private void prepare(AdminCommandContext c, String arg, OutputType type2) {
        this.outputType = type2;
        this.context = c;
        this.prepareReporter();
        if (this.isDas()) {
            this.prepareDas(arg);
        } else {
            this.prepareInstance(arg);
        }
        this.prepareNodesToProcess();
    }

    private void prepareReporter() {
        this.reporter = (ActionReporter)this.context.getActionReport();
        LOG.log(System.Logger.Level.DEBUG, "reporter: {0}", this.reporter);
    }

    private void prepareDas(String arg) {
        LOG.log(System.Logger.Level.DEBUG, "prepareDas(arg={0})", arg);
        try {
            this.setSuccess();
            this.userarg = arg;
            if (!this.validate()) {
                LOG.log(System.Logger.Level.WARNING, "Validation failed, returning.");
                return;
            }
        }
        catch (Exception e) {
            this.setError(Strings.get("admin.get.monitoring.unknown", e.getMessage()));
            this.reporter.setFailureCause(e);
        }
    }

    private void prepareInstance(String arg) {
        this.pattern = arg;
    }

    private void prepareNodesToProcess() {
        TreeNode parent;
        if (this.isDas() && !this.dasIsInList()) {
            return;
        }
        String localPattern = this.prependServerDot(this.pattern);
        TreeNode tn = this.datareg.get(this.serverEnv.getInstanceName());
        if (tn == null) {
            return;
        }
        List<TreeNode> ltn = tn.getNodes(localPattern);
        boolean singleStat = false;
        if ((ltn == null || ltn.isEmpty()) && (parent = tn.getPossibleParentNode(localPattern)) != null) {
            ltn = new ArrayList<TreeNode>(1);
            ltn.add(parent);
            singleStat = true;
        }
        if (!singleStat) {
            localPattern = null;
        }
        if (this.outputType == OutputType.GET) {
            this.prepareNodeTreeToProcess(localPattern, ltn);
        } else if (this.outputType == OutputType.LIST) {
            this.nodeListToProcess = ltn;
        }
    }

    private void runLocally() {
        if (this.isDas() && !this.dasIsInList()) {
            LOG.log(System.Logger.Level.DEBUG, "DAS selected, but there is nothing about DAS in the list.");
            return;
        }
        if (this.outputType == OutputType.GET) {
            this.doGet();
        } else if (this.outputType == OutputType.LIST) {
            this.doList();
        }
    }

    private void prepareNodeTreeToProcess(String localPattern, List<TreeNode> ltn) {
        for (TreeNode tn1 : this.sortTreeNodesByCompletePathName(ltn)) {
            if (tn1.hasChildNodes()) continue;
            this.insertNameValuePairs(this.nodeTreeToProcess, tn1, localPattern);
        }
    }

    private void doGet() {
        LOG.log(System.Logger.Level.TRACE, "doGet(); to process: {0}", this.nodeTreeToProcess);
        ActionReport.MessagePart topPart = this.reporter.getTopMessagePart();
        for (Map.Entry<String, Object> entry : this.nodeTreeToProcess.entrySet()) {
            String line = entry.getKey().replace("___SLASH___", "/") + " = " + String.valueOf(entry.getValue());
            LOG.log(System.Logger.Level.TRACE, "line={0}", line);
            topPart.addChild().setMessage(line);
        }
        this.setSuccess();
    }

    private void doList() {
        ActionReport.MessagePart topPart = this.reporter.getTopMessagePart();
        for (TreeNode tn1 : this.nodeListToProcess) {
            if (!tn1.hasChildNodes()) continue;
            topPart.addChild().setMessage(tn1.getCompletePathName());
        }
        this.setSuccess();
    }

    private void runRemotely() {
        if (!this.isDas()) {
            LOG.log(System.Logger.Level.DEBUG, "Not a DAS, returning.");
            return;
        }
        List<Server> remoteServers = this.getRemoteServers();
        if (remoteServers.isEmpty()) {
            LOG.log(System.Logger.Level.DEBUG, "No remote servers, returning.");
            return;
        }
        try {
            ParameterMap paramMap = new ParameterMap();
            paramMap.set("monitor", "true");
            paramMap.set("DEFAULT", this.pattern);
            ClusterOperationUtil.replicateCommand("get", FailurePolicy.Error, FailurePolicy.Warn, FailurePolicy.Ignore, remoteServers, this.context, paramMap, this.habitat);
        }
        catch (Exception ex) {
            this.setError(Strings.get("admin.get.monitoring.remote.error", this.getNames(remoteServers)));
        }
    }

    private String prependServerDot(String s) {
        String namedot = this.serverEnv.getInstanceName() + ".";
        if (s.startsWith(namedot)) {
            return s;
        }
        return namedot + s;
    }

    private boolean validate() {
        if (this.datareg == null) {
            this.setError(Strings.get("admin.get.no.monitoring"));
            return false;
        }
        return this.initPatternAndTargets();
    }

    private boolean initPatternAndTargets() {
        int index;
        Server das = this.domain.getServerNamed("server");
        List<Server> allServers = this.targetService.getAllInstances();
        allServers.add(das);
        this.userarg = MonitoringReporter.handleEscapes(this.userarg);
        this.userarg = this.userarg.replace("___MONDOT___", ".").replace("___SLASH___", "/");
        while (this.userarg.indexOf("**") >= 0) {
            this.userarg = this.userarg.replace("**", "*");
        }
        if (!StringUtils.ok(this.userarg) || this.userarg.equals("*") || this.userarg.equals(".") || this.userarg.equals("*.")) {
            this.targets = allServers;
            this.pattern = "*";
            return true;
        }
        if (this.userarg.startsWith("*.")) {
            this.targets = allServers;
            this.pattern = this.userarg.substring(2);
            if (this.pattern.startsWith(".")) {
                String specificError = Strings.get("admin.get.monitoring.nodoubledot");
                this.setError(Strings.get("admin.get.monitoring.invalidpattern", specificError));
                return false;
            }
            return true;
        }
        if (this.userarg.startsWith("*")) {
            this.targets = allServers;
            this.pattern = this.userarg;
            return true;
        }
        String re = "[^\\.]+\\*.*";
        if (this.userarg.matches(re)) {
            index = this.userarg.indexOf("*");
            if (index < 0) {
                this.setError(Strings.get("admin.get.monitoring.invalidtarget", this.userarg));
                return false;
            }
            this.targetName = this.userarg.substring(0, index);
            this.pattern = this.userarg.substring(index);
        }
        if (this.targetName == null) {
            index = this.userarg.indexOf(".");
            if (index >= 0) {
                this.targetName = this.userarg.substring(0, index);
                this.pattern = this.userarg.length() == index + 1 ? "*" : this.userarg.substring(index + 1);
            } else {
                this.targetName = this.userarg;
                this.pattern = "*";
            }
        }
        if (this.targetName.equals("server") || this.targetName.equals("server-config")) {
            this.targets.add(das);
            return true;
        }
        this.targets = this.targetService.getInstances(this.targetName);
        if (this.targets.isEmpty()) {
            this.setError(Strings.get("admin.get.monitoring.invalidtarget", this.userarg));
            return false;
        }
        if (this.targetService.isCluster(this.targetName) && this.targets.size() > 1) {
            this.targetIsMultiInstanceCluster = true;
        }
        return true;
    }

    private void insertNameValuePairs(TreeMap<String, Object> map, TreeNode tn1, String exactMatch) {
        String name = tn1.getCompletePathName();
        Object value = tn1.getValue();
        if (tn1.getParent() != null) {
            map.put(tn1.getParent().getCompletePathName() + DOTTED_NAME, tn1.getParent().getCompletePathName());
        }
        if (value instanceof Stats) {
            for (Statistic s : ((Stats)value).getStatistics()) {
                String statisticName = s.getName();
                if (statisticName != null) {
                    statisticName = s.getName().toLowerCase(Locale.getDefault());
                }
                this.addStatisticInfo(s, name + "." + statisticName, map);
            }
        } else if (value instanceof Statistic) {
            this.addStatisticInfo(value, name, map);
        } else {
            map.put(name, value);
        }
        if (exactMatch != null) {
            NameValue nv = this.getIgnoreBackslash(map, exactMatch);
            map.clear();
            if (nv != null) {
                map.put(nv.name, nv.value);
            }
        }
    }

    private NameValue getIgnoreBackslash(TreeMap<String, Object> map, String localPattern) {
        if (localPattern == null) {
            return null;
        }
        Object match = map.get(localPattern);
        if (match != null) {
            return new NameValue(localPattern, match);
        }
        match = map.get(localPattern = localPattern.replace("\\", ""));
        if (match != null) {
            return new NameValue(localPattern, match);
        }
        for (Map.Entry<String, Object> elem : map.entrySet()) {
            String name;
            String key = elem.getKey().toString();
            if (!StringUtils.ok(key) || !localPattern.equals(name = key.replace("\\", ""))) continue;
            return new NameValue(key, elem.getValue());
        }
        return null;
    }

    private void addStatisticInfo(Object value, String name, TreeMap<String, Object> map) {
        Map statsMap = Proxy.isProxyClass(value.getClass()) ? ((StatisticImpl)((Object)Proxy.getInvocationHandler(value))).getStaticAsMap() : ((StatisticImpl)value).getStaticAsMap();
        for (Map.Entry entry : statsMap.entrySet()) {
            map.put(name + "-" + (String)entry.getKey(), entry.getValue());
        }
    }

    private void setError(String msg) {
        this.reporter.setActionExitCode(ActionReport.ExitCode.FAILURE);
        this.appendStatusMessage(msg);
        this.clear();
    }

    private void setSuccess() {
        this.reporter.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private void appendStatusMessage(String newMessage) {
        this.reporter.appendMessage("\n");
        this.reporter.appendMessage(newMessage);
    }

    private boolean hasError() {
        return this.reporter.getActionExitCode() == ActionReport.ExitCode.FAILURE;
    }

    private void clear() {
        this.targets = Collections.emptyList();
        this.pattern = "";
    }

    private List<Server> getRemoteServers() {
        if (!this.isDas()) {
            throw new RuntimeException("Internal Error");
        }
        ArrayList<Server> notdas = new ArrayList<Server>(this.targets.size());
        String dasName = this.serverEnv.getInstanceName();
        for (Server server : this.targets) {
            if (dasName.equals(server.getName())) continue;
            notdas.add(server);
        }
        return notdas;
    }

    private boolean dasIsInList() {
        List<Server> remoteServers = this.getRemoteServers();
        LOG.log(System.Logger.Level.TRACE, "dasIsInLiist: remote servers list: {0}, targets: {1}", remoteServers, this.targets);
        return remoteServers.size() != this.targets.size();
    }

    private String getNames(List<Server> list) {
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (Server server : list) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(server.getName());
        }
        return sb.toString();
    }

    private static String handleEscapes(String s) {
        String UNLIKELY_STRING = "___~~~~$$$$___";
        return s.replace("\\\\", "___~~~~$$$$___").replace("\\", "").replace("___~~~~$$$$___", "\\");
    }

    private boolean isDas() {
        return this.serverEnv.isDas();
    }

    public static enum OutputType {
        GET,
        LIST;

    }

    private static class NameValue {
        String name;
        Object value;

        private NameValue(String s, Object o) {
            this.name = s;
            this.value = o;
        }
    }
}

