/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.management.InstanceNotFoundException;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.config.support.PropertyResolver;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@Service
@RunLevel(mode=0, value=10)
public class MbeanService {
    @Inject
    private Domain domain;
    @Inject
    private Target tgt;
    private static ServiceLocator habitat = Globals.getDefaultHabitat();
    @Inject
    private ServerEnvironment env;

    public static MbeanService getInstance() {
        if (habitat == null) {
            return null;
        }
        return habitat.getService(MbeanService.class, new Annotation[0]);
    }

    public String getHost(String instance) throws InstanceNotFoundException {
        Server s = this.domain.getServerNamed(instance);
        if (s == null) {
            throw new InstanceNotFoundException();
        }
        return s.getAdminHost();
    }

    public String getJMXPort(String instance) throws InstanceNotFoundException {
        Server s = this.domain.getServerNamed(instance);
        if (s == null) {
            throw new InstanceNotFoundException();
        }
        return new PropertyResolver(this.domain, instance).getPropertyValue("JMX_SYSTEM_CONNECTOR_PORT");
    }

    public boolean isDas() {
        return this.tgt.isThisDAS();
    }

    public boolean isValidServer(String name) {
        Server s = null;
        try {
            s = this.domain.getServerNamed(name);
        }
        catch (Throwable t) {
            return false;
        }
        return s != null;
    }

    public List<String> getAllInstances() {
        return this.convertList(this.tgt.getAllInstances());
    }

    public List<String> getInstances(String name) {
        return this.convertList(this.tgt.getInstances(name));
    }

    private List<String> convertList(List<Server> servers) {
        ArrayList<String> serverStrings = new ArrayList<String>();
        for (Server svr : servers) {
            serverStrings.add(svr.getName());
        }
        return serverStrings;
    }

    public boolean isInstance(String name) {
        return this.env.getInstanceName().equals(name);
    }

    public boolean isSecureJMX(String instance) {
        String isSecure = "false";
        if (this.domain.getServerNamed(instance) != null && this.domain.getServerNamed(instance).getConfig().getAdminService().getSystemJmxConnector() != null) {
            isSecure = this.domain.getServerNamed(instance).getConfig().getAdminService().getSystemJmxConnector().getSecurityEnabled();
        }
        return Boolean.parseBoolean(isSecure);
    }
}

