/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.admin.remote.RestPayloadImpl;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ManagedJobConfig;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.v3.admin.AdminCommandJob;
import com.sun.enterprise.v3.admin.CheckpointHelper;
import com.sun.enterprise.v3.admin.CommandRunnerExecutionContext;
import com.sun.enterprise.v3.admin.CommandRunnerImpl;
import com.sun.enterprise.v3.admin.CompletedJob;
import com.sun.enterprise.v3.admin.DefaultJobManagerFile;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.Subject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandState;
import org.glassfish.api.admin.Job;
import org.glassfish.api.admin.JobLocator;
import org.glassfish.api.admin.JobManager;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.Payload;
import org.glassfish.api.admin.progress.JobInfo;
import org.glassfish.api.admin.progress.JobInfos;
import org.glassfish.api.admin.progress.JobPersistence;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.api.event.RestrictTo;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service(name="job-manager")
@Singleton
public class JobManagerService
implements JobManager<AdminCommandJob>,
EventListener {
    private static final System.Logger LOG = System.getLogger(JobManagerService.class.getName());
    private static final LocalStringManagerImpl I18N = new LocalStringManagerImpl(JobManagerService.class);
    private static final String CHECKPOINT_MAINDATA = "MAINCMD";
    private static final int MAX_SIZE = 65535;
    private static final long DAY_IN_MILLIS = 86400000L;
    private final ConcurrentHashMap<String, AdminCommandJob> jobRegistry = new ConcurrentHashMap();
    private final AtomicInteger lastId = new AtomicInteger(0);
    private final ConcurrentHashMap<String, CompletedJob> completedJobsInfo = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, CheckpointHelper.CheckpointFilename> retryableJobsInfo = new ConcurrentHashMap();
    @Inject
    private Domain domain;
    @Inject
    private ServiceLocator serviceLocator;
    @Inject
    private Events events;
    @Inject
    private CheckpointHelper checkpointHelper;
    @Inject
    private DefaultJobManagerFile defaultJobsFile;
    @Inject
    private JobPersistence jobPersistence;
    private ExecutorService pool;

    @PostConstruct
    public void postConstruct() {
        ThreadFactory threadFactory = r -> {
            Thread t = Executors.defaultThreadFactory().newThread(r);
            t.setDaemon(true);
            t.setName("managed-job-" + t.getId());
            return t;
        };
        this.pool = Executors.newCachedThreadPool(threadFactory);
        Set<File> persistedJobFiles = JobManagerService.locateJobFiles(this.defaultJobsFile.getFile(), this.serviceLocator);
        for (File jobfile : persistedJobFiles) {
            this.reapCompletedJobs(jobfile);
            boolean dropInterruptedCommands = Boolean.getBoolean("org.glassfish.job-manager.drop-interrupted-commands");
            Collection<CheckpointHelper.CheckpointFilename> listed = this.checkpointHelper.listCheckpoints(jobfile.getParentFile());
            for (CheckpointHelper.CheckpointFilename cf : listed) {
                if (dropInterruptedCommands) {
                    LOG.log(System.Logger.Level.INFO, "Dropping checkpoint: {0}", cf.getFile());
                    this.deleteCheckpoint(cf.getParentDir(), cf.getJobId());
                    continue;
                }
                this.retryableJobsInfo.put(cf.getJobId(), cf);
            }
        }
        this.events.register(this);
    }

    @Override
    public AdminCommandJob createJob(String scope, String name, Subject subject, boolean isManagedJob, ParameterMap parameters, ActionReport report) {
        if (!isManagedJob) {
            return new AdminCommandJob(name, scope, subject, false, parameters, report);
        }
        AdminCommandJob job = new AdminCommandJob(this.getNewId(), name, scope, subject, true, parameters, report);
        job.setJobsFile(this.defaultJobsFile.getFile());
        return job;
    }

    @Override
    public synchronized String getNewId() {
        String nextIdToUse;
        int nextId = this.lastId.incrementAndGet();
        if (nextId > 65535) {
            this.reset();
        }
        return this.isIdInUse(nextIdToUse = String.valueOf(nextId)) ? this.getNewId() : String.valueOf(nextId);
    }

    @Override
    public JobInfo getCompletedJobForId(String id, File file) {
        for (JobInfo jobInfo : this.getCompletedJobs(file).getJobInfoList()) {
            if (!jobInfo.jobId.equals(id)) continue;
            return jobInfo;
        }
        return null;
    }

    private void reset() {
        this.lastId.set(0);
    }

    private boolean isIdInUse(String id) {
        return this.jobRegistry.containsKey(id) || this.completedJobsInfo.containsKey(id) || this.retryableJobsInfo.containsKey(id);
    }

    @Override
    public synchronized void registerJob(AdminCommandJob job) throws IllegalArgumentException {
        if (job == null) {
            throw new IllegalArgumentException(I18N.getLocalString("job.cannot.be.null", "Job cannot be null"));
        }
        if (this.jobRegistry.containsKey(job.getId())) {
            throw new IllegalArgumentException(I18N.getLocalString("job.id.in.use", "Job id is already in use."));
        }
        this.retryableJobsInfo.remove(job.getId());
        this.jobRegistry.put(job.getId(), job);
    }

    @Override
    public Iterator<AdminCommandJob> getJobs() {
        return this.jobRegistry.values().iterator();
    }

    @Override
    public AdminCommandJob get(String id) {
        return this.jobRegistry.get(id);
    }

    public ArrayList<JobInfo> getExpiredJobs(File jobsFile) {
        ArrayList<JobInfo> expiredJobs = new ArrayList<JobInfo>();
        long currentTime = System.currentTimeMillis();
        ManagedJobConfig managedJobConfig = this.domain.getExtensionByType(ManagedJobConfig.class);
        long jobsRetentionPeriod = JobManagerService.parseJobRetentionPeriodToMillis(managedJobConfig.getJobRetentionPeriod());
        for (JobInfo job : this.getCompletedJobs(jobsFile).getJobInfoList()) {
            if (currentTime - job.commandExecutionDate <= jobsRetentionPeriod || !job.state.equals(AdminCommandState.State.COMPLETED.name()) && !job.state.equals(AdminCommandState.State.REVERTED.name())) continue;
            expiredJobs.add(job);
        }
        return expiredJobs;
    }

    public static long parseJobRetentionPeriodToMillis(String input) {
        String period = input.substring(0, input.length() - 1);
        long timeInterval = Long.parseLong(period);
        char unit = Character.toLowerCase(input.charAt(input.length() - 1));
        if (unit == 's') {
            return timeInterval * 1000L;
        }
        if (unit == 'h') {
            return timeInterval * 3600L * 1000L;
        }
        if (unit == 'm') {
            return timeInterval * 60L * 1000L;
        }
        return 86400000L;
    }

    @Override
    public void purgeJob(String id) {
        Job job = this.jobRegistry.remove(id);
        if (job != null) {
            LOG.log(System.Logger.Level.DEBUG, "Removed job from the cache: {0}", job);
        }
    }

    public void deleteCheckpoint(File parentDir, String jobId) {
        File[] toDelete;
        for (File td : toDelete = parentDir.listFiles((dir, name) -> name.startsWith(jobId + ".") || name.startsWith(jobId + "-"))) {
            td.delete();
        }
    }

    @Override
    public void start(JobManager.AsyncAdminCommandExecution command) {
        this.pool.execute(command);
        LOG.log(System.Logger.Level.DEBUG, "Job {0} was submitted to pool {1}", command, this.pool);
    }

    @Override
    public JobInfos getCompletedJobs(File jobsFile) {
        return this.jobPersistence.load(jobsFile);
    }

    @Override
    public JobInfos purgeCompletedJobForId(JobInfo job) {
        this.removeFromCompletedJobs(job.jobId);
        return this.jobPersistence.remove(job);
    }

    public void moveToCompletedJobs(JobInfo job) {
        this.purgeJob(job.jobId);
        this.completedJobsInfo.put(job.jobId, new CompletedJob(job.jobId, job.commandCompletionDate, job.getJobsFile()));
        this.jobPersistence.add(job);
    }

    public void removeFromCompletedJobs(String id) {
        this.completedJobsInfo.remove(id);
    }

    public ConcurrentHashMap<String, CompletedJob> getCompletedJobsInfo() {
        return this.completedJobsInfo;
    }

    public ConcurrentHashMap<String, CheckpointHelper.CheckpointFilename> getRetryableJobsInfo() {
        return this.retryableJobsInfo;
    }

    @Override
    public void checkpoint(AdminCommandContext context, Serializable data) throws IOException {
        this.checkpoint((AdminCommand)null, context);
        if (data != null) {
            this.checkpointAttachement(context.getJobId(), CHECKPOINT_MAINDATA, data);
        }
    }

    @Override
    public void checkpoint(AdminCommand command, AdminCommandContext context) throws IOException {
        if (!StringUtils.ok(context.getJobId())) {
            throw new IllegalArgumentException("Command is not managed");
        }
        AdminCommandJob job = this.get(context.getJobId());
        JobManager.Checkpoint<AdminCommandJob> chkp = new JobManager.Checkpoint<AdminCommandJob>(job, command, context);
        this.checkpointHelper.save(chkp);
        job.setState(AdminCommandState.State.RUNNING_RETRYABLE);
    }

    public void checkpointAttachement(String jobId, String attachId, Serializable data) throws IOException {
        AdminCommandJob job = this.get(jobId);
        this.checkpointHelper.saveAttachment(data, job, attachId);
    }

    public <T extends Serializable> T loadCheckpointAttachement(String jobId, String attachId) throws IOException, ClassNotFoundException {
        AdminCommandJob job = this.get(jobId);
        return this.checkpointHelper.loadAttachment(job, attachId);
    }

    @Override
    public AdminCommandJob loadCheckpointData(String jobId) throws IOException, ClassNotFoundException {
        return (AdminCommandJob)this.loadCheckpointAttachement(jobId, CHECKPOINT_MAINDATA);
    }

    public JobManager.Checkpoint<AdminCommandJob> loadCheckpoint(String jobId, Payload.Outbound outbound) throws IOException, ClassNotFoundException {
        AdminCommandJob job = this.get(jobId);
        CheckpointHelper.CheckpointFilename cf = null;
        if (job == null) {
            cf = this.getRetryableJobsInfo().get(jobId);
            if (cf == null) {
                cf = CheckpointHelper.CheckpointFilename.createBasic(jobId, this.defaultJobsFile.getFile());
            }
        } else {
            cf = CheckpointHelper.CheckpointFilename.createBasic(job);
        }
        return this.loadCheckpoint(cf, outbound);
    }

    private JobManager.Checkpoint<AdminCommandJob> loadCheckpoint(CheckpointHelper.CheckpointFilename cf, Payload.Outbound outbound) throws IOException, ClassNotFoundException {
        JobManager.Checkpoint<AdminCommandJob> result = this.checkpointHelper.load(cf, outbound);
        if (result == null) {
            return null;
        }
        this.serviceLocator.inject(result.getJob());
        this.serviceLocator.postConstruct(result.getJob());
        if (result.getCommand() != null) {
            this.serviceLocator.inject(result.getCommand());
            this.serviceLocator.postConstruct(result.getCommand());
        }
        return result;
    }

    protected void reapCompletedJobs(File file) {
        if (file == null || !file.exists()) {
            return;
        }
        for (JobInfo jobInfo : this.getCompletedJobs(file).getJobInfoList()) {
            CompletedJob job = new CompletedJob(jobInfo.jobId, jobInfo.commandCompletionDate, jobInfo.getJobsFile());
            this.completedJobsInfo.put(jobInfo.jobId, job);
        }
    }

    @Override
    public void event(@RestrictTo(value="server_ready") EventListener.Event<?> event) {
        if (event.is(EventTypes.SERVER_READY)) {
            if (!this.retryableJobsInfo.isEmpty()) {
                Runnable runnable = () -> {
                    LOG.log(System.Logger.Level.DEBUG, "Restarting retryable jobs");
                    for (CheckpointHelper.CheckpointFilename cf : this.retryableJobsInfo.values()) {
                        this.reexecuteJobFromCheckpoint(cf);
                    }
                };
                this.pool.submit(runnable);
            } else {
                LOG.log(System.Logger.Level.DEBUG, "No retryable job found");
            }
        }
    }

    private void reexecuteJobFromCheckpoint(CheckpointHelper.CheckpointFilename cf) {
        JobManager.Checkpoint<AdminCommandJob> checkpoint = null;
        try {
            RestPayloadImpl.Outbound outbound = new RestPayloadImpl.Outbound(true);
            checkpoint = this.loadCheckpoint(cf, (Payload.Outbound)outbound);
        }
        catch (Exception ex) {
            LOG.log(System.Logger.Level.WARNING, "Unable to load checkpoint", (Throwable)ex);
        }
        if (checkpoint != null) {
            AdminCommandJob job = checkpoint.getJob();
            AdminCommandContext context = checkpoint.getContext();
            ActionReport report = context.getActionReport();
            LOG.log(System.Logger.Level.INFO, "Resuming command {0} from its last checkpoint.", job);
            CommandRunnerExecutionContext ec = new CommandRunnerExecutionContext(job.getScope(), job.getName(), report, context.getSubject(), false, false, this.serviceLocator.getService(CommandRunnerImpl.class, new Annotation[0]));
            ec.executeFromCheckpoint(checkpoint, false);
            LOG.log(System.Logger.Level.INFO, "Automatically resumed command {0} finished with exit code {1}. \nMessage: {2}", new Object[]{checkpoint.getJob().getName(), report.getActionExitCode(), report.getTopMessagePart()});
        }
    }

    private static Set<File> locateJobFiles(File defaultJobsFile, ServiceLocator serviceLocator) {
        List<JobLocator> services = serviceLocator.getAllServices(JobLocator.class, new Annotation[0]);
        HashSet<File> persistedJobFiles = new HashSet<File>();
        for (JobLocator locator : services) {
            persistedJobFiles.addAll(locator.locateJobXmlFiles());
        }
        persistedJobFiles.add(defaultJobsFile);
        return persistedJobFiles;
    }
}

