/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.customvalidators.JavaClassName;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.universal.collections.ManifestUtils;
import com.sun.enterprise.v3.common.PropsFileActionReporter;
import jakarta.inject.Inject;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.Payload;
import jakarta.validation.constraints.Pattern;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.jvnet.hk2.annotations.Service;

@Service(name="_get-habitat-info")
@PerLookup
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="_get-habitat-info", description="_get-habitat-info")})
@Constraint
@AccessRequired(resource={"domain"}, action={"dump"})
public class GetHabitatInfo
implements AdminCommand {
    @Inject
    ServiceLocator serviceLocator;
    @Inject
    ModulesRegistry modulesRegistry;
    @JavaClassName
    @Param(primary=true, optional=true)
    String contract;
    @Pattern(regexp="true|false", message="Valid values: true|false")
    @Param(optional=true)
    @Pattern(regexp="true|false", message="Valid values: true|false") String started = "false";

    @Override
    public void execute(AdminCommandContext context) {
        StringBuilder sb = new StringBuilder();
        if (this.contract == null) {
            this.dumpContracts(sb);
            this.dumpModules(sb);
            this.dumpTypes(sb);
        } else {
            this.dumpInhabitantsImplementingContractPattern(this.contract, sb);
        }
        String msg = sb.toString();
        ActionReport report = context.getActionReport();
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        if (report instanceof PropsFileActionReporter) {
            msg = ManifestUtils.encode(msg);
        }
        report.setMessage(msg);
    }

    private void dumpContracts(StringBuilder sb) {
        sb.append("\n*********** Sorted List of all Registered Contracts in the Habitat **************\n");
        List<ActiveDescriptor<?>> allDescriptors = this.serviceLocator.getDescriptors(BuilderHelper.allFilter());
        AtomicInteger counter = new AtomicInteger(0);
        allDescriptors.stream().flatMap(desc -> desc.getAdvertisedContracts().stream()).sorted().forEach(contract -> sb.append("Contract-").append(counter.incrementAndGet()).append(": ").append((String)contract).append('\n'));
    }

    private void dumpInhabitantsImplementingContractPattern(String pattern, StringBuilder sb) {
        sb.append("\n*********** List of all services for contract named like " + this.contract + " **************\n");
        List<ActiveDescriptor<?>> allDescriptors = this.serviceLocator.getDescriptors(BuilderHelper.allFilter());
        HashSet<String> allContracts = new HashSet<String>();
        for (ActiveDescriptor<?> aDescriptor : allDescriptors) {
            allContracts.addAll(aDescriptor.getAdvertisedContracts());
        }
        for (String cn : allContracts) {
            if (cn.toLowerCase(Locale.ENGLISH).indexOf(pattern.toLowerCase(Locale.ENGLISH)) < 0) continue;
            sb.append("-----------------------------\n");
            for (ActiveDescriptor<?> descriptor : this.serviceLocator.getDescriptors(BuilderHelper.createContractFilter(cn))) {
                sb.append("Inhabitant-Metadata: " + String.valueOf(descriptor.getMetadata()));
                sb.append("\n");
                boolean isStarted = Boolean.parseBoolean(this.started);
                if (!isStarted) continue;
                ServiceHandle<?> handle = this.serviceLocator.getServiceHandle(descriptor);
                sb.append(handle.isActive() ? " started" : " not started");
            }
        }
    }

    private void dumpTypes(StringBuilder sb) {
        sb.append("\n\n*********** Sorted List of all Types in the Habitat **************\n\n");
        List<ActiveDescriptor<?>> allDescriptors = this.serviceLocator.getDescriptors(BuilderHelper.allFilter());
        AtomicInteger counter = new AtomicInteger(0);
        allDescriptors.stream().map(Descriptor::getImplementation).sorted().forEach(impl -> sb.append("Type-").append(counter.incrementAndGet()).append(": ").append((String)impl).append('\n'));
    }

    private void dumpModules(StringBuilder sb) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.modulesRegistry.dumpState(new PrintStream(baos));
        sb.append("\n\n*********** List of all Registered Modules **************\n\n");
        sb.append(baos);
    }

    public static class Validator
    implements ConstraintValidator<Constraint, GetHabitatInfo>,
    Payload {
        @Override
        public void initialize(Constraint constraint) {
        }

        @Override
        public boolean isValid(GetHabitatInfo bean, ConstraintValidatorContext constraintValidatorContext) {
            return !"test".equals(bean.contract) || !"true".equals(bean.started);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @jakarta.validation.Constraint(validatedBy={Validator.class})
    public static @interface Constraint {
        public String message() default "The contract argument is test but started is true.";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};
    }
}

