/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.v3.admin.AdminCommandJob;
import java.util.Objects;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.CommandInvocation;

public abstract class AsyncAdminCommandInvoker<T> {
    private static final System.Logger LOG = System.getLogger(AsyncAdminCommandInvoker.class.getName());
    private final CommandInvocation<AdminCommandJob> commandInvocation;
    private final AdminCommand command;
    private final AdminCommandJob job;

    protected AsyncAdminCommandInvoker(CommandInvocation<AdminCommandJob> commandInvocation) {
        this.commandInvocation = Objects.requireNonNull(commandInvocation, "commandInvocation");
        this.command = Objects.requireNonNull(this.commandInvocation.evaluateCommand(), "command");
        this.job = this.commandInvocation.createJob(this.command);
    }

    public abstract T start();

    protected AdminCommandJob getJob() {
        return this.job;
    }

    protected void startJob() {
        LOG.log(System.Logger.Level.TRACE, () -> "Starting the job by " + String.valueOf(this));
        this.commandInvocation.start(this.command, this.job);
    }

    public String toString() {
        return super.toString() + "[job=" + String.valueOf(this.job) + "]";
    }
}

