/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.admin.event.AdminCommandEventBrokerImpl;
import com.sun.enterprise.v3.admin.CheckpointHelper;
import com.sun.enterprise.v3.admin.DefaultJobManagerFile;
import com.sun.enterprise.v3.admin.JobManagerService;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Objects;
import javax.security.auth.Subject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommandEventBroker;
import org.glassfish.api.admin.AdminCommandState;
import org.glassfish.api.admin.CommandProgress;
import org.glassfish.api.admin.Job;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.Payload;
import org.glassfish.api.admin.progress.JobInfo;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.glassfish.security.services.common.SubjectUtil;

public final class AdminCommandJob
implements Job {
    private static final long serialVersionUID = 1L;
    private static final System.Logger LOG = System.getLogger(AdminCommandJob.class.getName());
    private CommandProgress commandProgress;
    private final String id;
    private final String commandName;
    private final String scope;
    private final ActionReport actionReport;
    private final long executionDate;
    private final boolean managedJob;
    private final List<String> subjectUsernames;
    private final ParameterMap parameters;
    private volatile AdminCommandState.State state;
    private File jobsFile;
    private long completionDate;
    private boolean failToRetryable;
    private transient Payload.Outbound payload;
    private transient AdminCommandEventBroker broker;

    protected AdminCommandJob(String name, String scope, Subject sub, boolean managedJob, ParameterMap parameters, ActionReport actionReport) {
        this(null, name, scope, sub, managedJob, parameters, actionReport);
    }

    protected AdminCommandJob(String id, String name, String commandScope, Subject sub, boolean managedJob, ParameterMap parameters, ActionReport actionReport) {
        this.id = id;
        this.actionReport = Objects.requireNonNull(actionReport, "actionReport");
        this.state = AdminCommandState.State.PREPARED;
        this.broker = new AdminCommandEventBrokerImpl();
        this.executionDate = System.currentTimeMillis();
        this.commandName = name;
        this.scope = commandScope;
        this.managedJob = managedJob;
        this.subjectUsernames = SubjectUtil.getUsernamesFromSubject(sub);
        this.parameters = parameters;
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public final ActionReport getActionReport() {
        return this.actionReport;
    }

    @Override
    public final AdminCommandState.State getState() {
        return this.state;
    }

    @Override
    public CommandProgress getCommandProgress() {
        return this.commandProgress;
    }

    @Override
    public void setCommandProgress(CommandProgress commandProgress) {
        this.commandProgress = commandProgress;
        this.commandProgress.setEventBroker(this.broker);
    }

    @Override
    public final AdminCommandEventBroker getEventBroker() {
        return this.broker;
    }

    @Override
    public File getJobsFile() {
        return this.jobsFile;
    }

    @Override
    public void setJobsFile(File jobsFile) {
        this.jobsFile = jobsFile;
    }

    @Override
    public List<String> getSubjectUsernames() {
        return this.subjectUsernames;
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    @Override
    public final void setState(AdminCommandState.State state) {
        Objects.requireNonNull(state, "state");
        if (!AdminCommandState.State.isAllowedTransition(this.state, state)) {
            throw new IllegalStateException("Illegal state transition: " + String.valueOf((Object)this.state) + " -> " + String.valueOf((Object)state));
        }
        LOG.log(System.Logger.Level.DEBUG, "Job state changed: {0} -> {1}, original this: {2}", new Object[]{this.state, state, this});
        this.state = state;
        this.getEventBroker().fireEvent("AdminCommandState/stateChanged", this);
    }

    @Override
    public boolean isOutboundPayloadEmpty() {
        return this.payload == null || this.payload.size() == 0;
    }

    @Override
    public void complete(ActionReport report, Payload.Outbound outbound) {
        LOG.log(System.Logger.Level.DEBUG, "complete(report={0}, outbound={1})", report, outbound);
        this.payload = outbound;
        this.completionDate = System.currentTimeMillis();
        if (!this.managedJob) {
            this.setState(AdminCommandState.State.COMPLETED);
            if (this.commandProgress != null && report.getActionExitCode() == ActionReport.ExitCode.SUCCESS) {
                this.commandProgress.complete();
            }
            return;
        }
        ServiceLocator serviceLocator = Globals.getDefaultHabitat();
        AdminCommandState.State originalState = this.getState();
        JobManagerService jobManager = serviceLocator.getService(JobManagerService.class, new Annotation[0]);
        if (originalState.equals((Object)AdminCommandState.State.RUNNING_RETRYABLE) && this.failToRetryable) {
            LOG.log(System.Logger.Level.WARNING, "Failed to retry: {0}", this);
            jobManager.getRetryableJobsInfo().put(this.getId(), CheckpointHelper.CheckpointFilename.createBasic(this));
            jobManager.purgeJob(this.getId());
            this.setState(AdminCommandState.State.FAILED_RETRYABLE);
            return;
        }
        AdminCommandState.State finalState = originalState.equals((Object)AdminCommandState.State.REVERTING) ? AdminCommandState.State.REVERTED : AdminCommandState.State.COMPLETED;
        String user = this.subjectUsernames.isEmpty() ? null : this.subjectUsernames.get(0);
        JobInfo jobInfo = new JobInfo(this.getId(), this.commandName, this.executionDate, report.getActionExitCode().name(), user, report.getMessage(), this.getJobsFile(), finalState.name(), this.completionDate);
        jobManager.moveToCompletedJobs(jobInfo);
        if (originalState.equals((Object)AdminCommandState.State.RUNNING_RETRYABLE) || originalState.equals((Object)AdminCommandState.State.REVERTING)) {
            File jobFile = this.getJobsFile();
            if (jobFile == null) {
                jobFile = serviceLocator.getService(DefaultJobManagerFile.class, new Annotation[0]).getFile();
            }
            jobManager.deleteCheckpoint(jobFile.getParentFile(), this.getId());
        }
        this.setState(finalState);
        if (this.commandProgress != null && report.getActionExitCode() == ActionReport.ExitCode.SUCCESS) {
            this.commandProgress.complete();
        }
        LOG.log(System.Logger.Level.INFO, "Completed: {0}", this);
    }

    @Override
    public void revert() {
        this.setState(AdminCommandState.State.REVERTING);
    }

    @Override
    public long getCommandExecutionDate() {
        return this.executionDate;
    }

    @Override
    public Payload.Outbound getPayload() {
        return this.payload;
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public long getCommandCompletionDate() {
        return this.completionDate;
    }

    @Override
    public void setFailToRetryable(boolean value) {
        this.failToRetryable = value;
    }

    @Override
    public ParameterMap getParameters() {
        return this.parameters;
    }

    public boolean isManaged() {
        return this.managedJob;
    }

    public String toString() {
        return super.toString() + "[id=" + this.id + ", name=" + this.commandName + ", state=" + String.valueOf((Object)this.state) + ", report=" + String.valueOf(this.actionReport) + "]";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.payload = null;
        this.broker = null;
    }
}

