/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.transaction;

import com.sun.enterprise.transaction.JavaEETransactionImpl;
import com.sun.enterprise.util.i18n.StringManager;
import jakarta.inject.Inject;
import jakarta.transaction.RollbackException;
import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.TransactionSynchronizationRegistry;
import org.jvnet.hk2.annotations.ContractsProvided;
import org.jvnet.hk2.annotations.Service;

@Service
@ContractsProvided(value={TransactionSynchronizationRegistryImpl.class, TransactionSynchronizationRegistry.class})
public class TransactionSynchronizationRegistryImpl
implements TransactionSynchronizationRegistry {
    @Inject
    private transient TransactionManager transactionManager;
    private static StringManager sm = StringManager.getManager(TransactionSynchronizationRegistryImpl.class);

    public TransactionSynchronizationRegistryImpl() {
    }

    public TransactionSynchronizationRegistryImpl(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    public Object getTransactionKey() {
        try {
            return this.transactionManager.getTransaction();
        }
        catch (SystemException ex) {
            return null;
        }
    }

    @Override
    public void putResource(Object key, Object value) {
        try {
            this.getTransaction().putUserResource(key, value);
        }
        catch (SystemException ex) {
            throw new IllegalStateException(sm.getString("enterprise_distributedtx.no_transaction"));
        }
    }

    @Override
    public Object getResource(Object key) {
        try {
            return this.getTransaction().getUserResource(key);
        }
        catch (SystemException ex) {
            throw new IllegalStateException(sm.getString("enterprise_distributedtx.no_transaction"));
        }
    }

    @Override
    public void registerInterposedSynchronization(Synchronization sync) {
        try {
            this.getTransaction().registerInterposedSynchronization(sync);
        }
        catch (SystemException ex) {
            throw new IllegalStateException(sm.getString("enterprise_distributedtx.no_transaction"));
        }
        catch (RollbackException ex) {
            throw new IllegalStateException(sm.getString("enterprise_distributedtx.mark_rollback"));
        }
    }

    @Override
    public int getTransactionStatus() {
        try {
            return this.transactionManager.getStatus();
        }
        catch (SystemException ex) {
            return 6;
        }
    }

    @Override
    public void setRollbackOnly() {
        try {
            this.transactionManager.setRollbackOnly();
        }
        catch (SystemException ex) {
            throw new IllegalStateException(sm.getString("enterprise_distributedtx.no_transaction"));
        }
    }

    @Override
    public boolean getRollbackOnly() {
        int status = this.getTransactionStatus();
        if (status == 6) {
            throw new IllegalStateException(sm.getString("enterprise_distributedtx.no_transaction"));
        }
        return status == 1 || status == 9;
    }

    private JavaEETransactionImpl getTransaction() throws SystemException {
        JavaEETransactionImpl transaction = (JavaEETransactionImpl)this.transactionManager.getTransaction();
        if (transaction == null) {
            throw new IllegalStateException(sm.getString("enterprise_distributedtx.no_transaction"));
        }
        return transaction;
    }
}

