/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.transaction;

import com.sun.enterprise.transaction.JavaEETransactionManagerSimplified;
import com.sun.enterprise.transaction.api.JavaEETransaction;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.enterprise.transaction.api.SimpleResource;
import com.sun.enterprise.transaction.spi.TransactionInternal;
import com.sun.enterprise.transaction.spi.TransactionalResource;
import com.sun.enterprise.util.Utility;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import jakarta.persistence.EntityManagerFactory;
import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public final class JavaEETransactionImpl
extends TimerTask
implements JavaEETransaction {
    private static final Logger LOG = LogDomains.getLogger(JavaEETransactionImpl.class, "jakarta.enterprise.resource.jta");
    private static StringManager I18N = StringManager.getManager(JavaEETransactionImpl.class);
    private static final boolean DISABLE_STATUS_CHECK_ON_SWITCH_TO_XA = Boolean.getBoolean("com.sun.jts.disable_status_check_on_switch_to_xa");
    private JavaEETransactionManager javaEETM;
    private static AtomicLong txIdCounter = new AtomicLong(0L);
    private long txId;
    private JavaEEXid xid;
    private TransactionInternal jtsTx;
    private TransactionalResource nonXAResource;
    private TransactionalResource laoResource;
    private int localTxStatus;
    private Vector syncs = new Vector();
    private Vector interposedSyncs = new Vector();
    private boolean commitStarted = false;
    private long startTime;
    private boolean timedOut = false;
    private boolean isTimerTask = false;
    private int timeout = 0;
    private boolean imported = false;
    private HashMap<Object, Set> resourceTable;
    private HashMap<Object, Object> userResourceMap;
    private Object activeTxCache;
    private Map<EntityManagerFactory, SimpleResource> txEntityManagerMap;
    private Map<EntityManagerFactory, SimpleResource> extendedEntityManagerMap;
    private String componentName = null;
    private ArrayList<String> resourceNames = null;
    private Object containerData = null;
    private static boolean isTimerInitialized = false;
    private static Timer timer = null;
    private static long timerTasksScheduled = 0L;

    private static synchronized void initializeTimer() {
        if (isTimerInitialized) {
            return;
        }
        timer = new Timer(true);
        isTimerInitialized = true;
    }

    JavaEETransactionImpl(JavaEETransactionManager javaEETM) {
        this.javaEETM = javaEETM;
        this.txId = txIdCounter.incrementAndGet();
        this.xid = new JavaEEXid(this.txId);
        this.resourceTable = new HashMap();
        this.localTxStatus = 0;
        this.startTime = System.currentTimeMillis();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "--Created new JavaEETransactionImpl, txId = " + this.txId);
        }
    }

    JavaEETransactionImpl(int timeout, JavaEETransactionManager javaEETM) {
        this(javaEETM);
        if (!isTimerInitialized) {
            JavaEETransactionImpl.initializeTimer();
        }
        timer.schedule((TimerTask)this, (long)timeout * 1000L);
        ++timerTasksScheduled;
        this.isTimerTask = true;
        this.timeout = timeout;
    }

    JavaEETransactionImpl(TransactionInternal jtsTx, JavaEETransactionManager javaEETM) {
        this(javaEETM);
        this.jtsTx = jtsTx;
        this.imported = true;
    }

    @Override
    public void run() {
        this.timedOut = true;
        long time = System.currentTimeMillis() - this.startTime;
        LOG.warning(() -> String.format("Transaction with id=%s timed out after %s ms.", this.txId, time));
        try {
            this.setRollbackOnly();
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "enterprise_distributedtx.some_excep", e);
        }
    }

    public Object getContainerData() {
        return this.containerData;
    }

    public void setContainerData(Object data) {
        this.containerData = data;
    }

    boolean isAssociatedTimeout() {
        return this.isTimerTask;
    }

    public int cancelTimerTask() {
        this.cancel();
        int mod = this.javaEETM.getPurgeCancelledTtransactionsAfter();
        if (mod > 0 && timerTasksScheduled % (long)mod == 0L) {
            int purged = timer.purge();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Purged " + purged + " timer tasks from canceled queue");
            }
        }
        return this.timeout;
    }

    @Override
    public boolean isTimedOut() {
        return this.timedOut;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof JavaEETransactionImpl) {
            JavaEETransactionImpl othertx = (JavaEETransactionImpl)other;
            return this.txId == othertx.txId;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.txId;
    }

    Xid getLocalXid() {
        return this.xid;
    }

    @Override
    public TransactionalResource getNonXAResource() {
        return this.nonXAResource;
    }

    void setNonXAResource(TransactionalResource h) {
        this.nonXAResource = h;
    }

    @Override
    public TransactionalResource getLAOResource() {
        return this.laoResource;
    }

    @Override
    public void setLAOResource(TransactionalResource h) {
        this.laoResource = h;
    }

    boolean isImportedTransaction() {
        return this.imported;
    }

    synchronized void putUserResource(Object key, Object value) {
        if (this.userResourceMap == null) {
            this.userResourceMap = new HashMap();
        }
        this.userResourceMap.put(key, value);
    }

    synchronized Object getUserResource(Object key) {
        if (this.userResourceMap == null) {
            return null;
        }
        return this.userResourceMap.get(key);
    }

    void registerInterposedSynchronization(Synchronization sync) throws RollbackException, SystemException {
        this.interposedSyncs.add(sync);
        if (this.jtsTx != null) {
            this.jtsTx.registerInterposedSynchronization(sync);
        }
    }

    void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    String getComponentName() {
        return this.componentName;
    }

    synchronized void addResourceName(String resourceName) {
        if (this.resourceNames == null) {
            this.resourceNames = new ArrayList();
        }
        if (!this.resourceNames.contains(resourceName)) {
            this.resourceNames.add(resourceName);
        }
    }

    synchronized ArrayList<String> getResourceNames() {
        return this.resourceNames;
    }

    @Override
    public void addTxEntityManagerMapping(EntityManagerFactory emf, SimpleResource em) {
        this.getTxEntityManagerMap().put(emf, em);
    }

    @Override
    public SimpleResource getTxEntityManagerResource(EntityManagerFactory emf) {
        return this.getTxEntityManagerMap().get(emf);
    }

    private Map<EntityManagerFactory, SimpleResource> getTxEntityManagerMap() {
        if (this.txEntityManagerMap == null) {
            this.txEntityManagerMap = new HashMap<EntityManagerFactory, SimpleResource>();
        }
        return this.txEntityManagerMap;
    }

    protected void onTxCompletion(boolean status) {
        if (this.txEntityManagerMap == null) {
            return;
        }
        for (Map.Entry<EntityManagerFactory, SimpleResource> entry : this.getTxEntityManagerMap().entrySet()) {
            SimpleResource em = entry.getValue();
            if (!em.isOpen()) continue;
            try {
                em.close();
            }
            catch (Throwable th) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.log(Level.FINE, "Exception while closing em.", th);
            }
        }
    }

    @Override
    public void addExtendedEntityManagerMapping(EntityManagerFactory emf, SimpleResource em) {
        this.getExtendedEntityManagerMap().put(emf, em);
    }

    @Override
    public void removeExtendedEntityManagerMapping(EntityManagerFactory emf) {
        this.getExtendedEntityManagerMap().remove(emf);
    }

    @Override
    public SimpleResource getExtendedEntityManagerResource(EntityManagerFactory emf) {
        return this.getExtendedEntityManagerMap().get(emf);
    }

    private Map<EntityManagerFactory, SimpleResource> getExtendedEntityManagerMap() {
        if (this.extendedEntityManagerMap == null) {
            this.extendedEntityManagerMap = new HashMap<EntityManagerFactory, SimpleResource>();
        }
        return this.extendedEntityManagerMap;
    }

    @Override
    public boolean isLocalTx() {
        return this.jtsTx == null;
    }

    void setJTSTx(TransactionInternal jtsTx) throws RollbackException, SystemException {
        boolean marked_for_rollback = this.isRollbackOnly();
        this.jtsTx = jtsTx;
        if (!this.commitStarted) {
            int i;
            for (i = 0; i < this.syncs.size(); ++i) {
                jtsTx.registerSynchronization((Synchronization)this.syncs.elementAt(i));
            }
            for (i = 0; i < this.interposedSyncs.size(); ++i) {
                jtsTx.registerInterposedSynchronization((Synchronization)this.interposedSyncs.elementAt(i));
            }
        }
        if (!DISABLE_STATUS_CHECK_ON_SWITCH_TO_XA && marked_for_rollback) {
            jtsTx.setRollbackOnly();
        }
    }

    TransactionInternal getJTSTx() {
        return this.jtsTx;
    }

    @Override
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.checkTransationActive();
        if (this.isTimerTask) {
            this.cancelTimerTask();
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "--In JavaEETransactionImpl.commit, jtsTx=" + String.valueOf(this.jtsTx) + " nonXAResource=" + String.valueOf(this.nonXAResource));
        }
        this.commitStarted = true;
        boolean success = false;
        if (this.jtsTx != null) {
            try {
                this.jtsTx.commit();
                success = true;
            }
            catch (HeuristicMixedException e) {
                success = true;
                throw e;
            }
            finally {
                ((JavaEETransactionManagerSimplified)this.javaEETM).monitorTxCompleted(this, success);
                ((JavaEETransactionManagerSimplified)this.javaEETM).clearThreadTx();
                this.onTxCompletion(success);
                try {
                    this.localTxStatus = this.jtsTx.getStatus();
                }
                catch (Exception e) {
                    this.localTxStatus = 6;
                }
                this.jtsTx = null;
            }
        }
        RuntimeException caughtException = null;
        try {
            Synchronization sync;
            int i;
            if (this.timedOut) {
                if (this.nonXAResource != null) {
                    this.nonXAResource.getXAResource().rollback(this.xid);
                }
                this.localTxStatus = 4;
                throw new RollbackException(I18N.getString("enterprise_distributedtx.rollback_timeout"));
            }
            if (this.isRollbackOnly()) {
                if (this.nonXAResource != null) {
                    this.nonXAResource.getXAResource().rollback(this.xid);
                }
                this.localTxStatus = 4;
                throw new RollbackException(I18N.getString("enterprise_distributedtx.mark_rollback"));
            }
            for (i = 0; i < this.syncs.size(); ++i) {
                try {
                    sync = (Synchronization)this.syncs.elementAt(i);
                    sync.beforeCompletion();
                    continue;
                }
                catch (RuntimeException ex) {
                    LOG.log(Level.WARNING, "enterprise_distributedtx.before_completion_excep", ex);
                    this.setRollbackOnly();
                    caughtException = ex;
                    break;
                }
                catch (Exception ex) {
                    LOG.log(Level.WARNING, "enterprise_distributedtx.before_completion_excep", ex);
                }
            }
            for (i = 0; i < this.interposedSyncs.size(); ++i) {
                try {
                    sync = (Synchronization)this.interposedSyncs.elementAt(i);
                    sync.beforeCompletion();
                    continue;
                }
                catch (RuntimeException ex) {
                    LOG.log(Level.WARNING, "enterprise_distributedtx.before_completion_excep", ex);
                    this.setRollbackOnly();
                    caughtException = ex;
                    break;
                }
                catch (Exception ex) {
                    LOG.log(Level.WARNING, "enterprise_distributedtx.before_completion_excep", ex);
                }
            }
            if (this.isRollbackOnly()) {
                RollbackException rbe = null;
                if (this.jtsTx == null) {
                    if (this.nonXAResource != null) {
                        this.nonXAResource.getXAResource().rollback(this.xid);
                    }
                    this.localTxStatus = 4;
                    rbe = new RollbackException(I18N.getString("enterprise_distributedtx.mark_rollback"));
                } else {
                    this.jtsTx.rollback();
                    this.localTxStatus = 4;
                    rbe = new RollbackException(I18N.getString("enterprise_distributedtx.mark_rollback"));
                }
                if (caughtException != null) {
                    rbe.initCause(caughtException);
                }
                throw rbe;
            }
            if (this.jtsTx != null) {
                this.jtsTx.commit();
            } else if (this.nonXAResource != null) {
                this.nonXAResource.getXAResource().commit(this.xid, true);
            }
            this.localTxStatus = 3;
            success = true;
        }
        catch (RollbackException ex) {
            this.localTxStatus = 4;
            throw ex;
        }
        catch (SystemException ex) {
            this.localTxStatus = 8;
            success = true;
            throw ex;
        }
        catch (Exception ex) {
            this.localTxStatus = 4;
            SystemException exc = new SystemException();
            exc.initCause(ex);
            throw exc;
        }
        finally {
            Synchronization sync;
            int i;
            ((JavaEETransactionManagerSimplified)this.javaEETM).monitorTxCompleted(this, success);
            ((JavaEETransactionManagerSimplified)this.javaEETM).clearThreadTx();
            for (i = 0; i < this.interposedSyncs.size(); ++i) {
                try {
                    sync = (Synchronization)this.interposedSyncs.elementAt(i);
                    sync.afterCompletion(this.localTxStatus);
                    continue;
                }
                catch (Exception ex) {
                    LOG.log(Level.WARNING, "enterprise_distributedtx.after_completion_excep", ex);
                }
            }
            for (i = 0; i < this.syncs.size(); ++i) {
                try {
                    sync = (Synchronization)this.syncs.elementAt(i);
                    sync.afterCompletion(this.localTxStatus);
                    continue;
                }
                catch (Exception ex) {
                    LOG.log(Level.WARNING, "enterprise_distributedtx.after_completion_excep", ex);
                }
            }
            this.onTxCompletion(success);
            this.jtsTx = null;
        }
    }

    @Override
    public void rollback() throws IllegalStateException, SystemException {
        if (this.isTimerTask) {
            this.cancelTimerTask();
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "--In JavaEETransactionImpl.rollback, jtsTx=" + String.valueOf(this.jtsTx) + " nonXAResource=" + String.valueOf(this.nonXAResource));
        }
        if (this.jtsTx == null) {
            this.checkTransationActive();
        }
        try {
            if (this.jtsTx != null) {
                this.jtsTx.rollback();
            } else if (this.nonXAResource != null) {
                this.nonXAResource.getXAResource().rollback(this.xid);
            }
        }
        catch (SystemException ex) {
            throw ex;
        }
        catch (IllegalStateException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "enterprise_distributedtx.some_excep", ex);
        }
        finally {
            this.localTxStatus = 4;
            ((JavaEETransactionManagerSimplified)this.javaEETM).monitorTxCompleted(this, false);
            ((JavaEETransactionManagerSimplified)this.javaEETM).clearThreadTx();
            if (this.jtsTx == null) {
                Synchronization sync;
                int i;
                for (i = 0; i < this.interposedSyncs.size(); ++i) {
                    try {
                        sync = (Synchronization)this.interposedSyncs.elementAt(i);
                        sync.afterCompletion(4);
                        continue;
                    }
                    catch (Exception ex) {
                        LOG.log(Level.WARNING, "enterprise_distributedtx.after_completion_excep", ex);
                    }
                }
                for (i = 0; i < this.syncs.size(); ++i) {
                    try {
                        sync = (Synchronization)this.syncs.elementAt(i);
                        sync.afterCompletion(4);
                        continue;
                    }
                    catch (Exception ex) {
                        LOG.log(Level.WARNING, "enterprise_distributedtx.after_completion_excep", ex);
                    }
                }
            }
            this.onTxCompletion(false);
            this.jtsTx = null;
        }
    }

    @Override
    public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "--In JavaEETransactionImpl.delistResource: " + String.valueOf(xaRes) + " from " + String.valueOf(this));
        }
        this.checkTransationActive();
        if (this.jtsTx != null) {
            return this.jtsTx.delistResource(xaRes, flag);
        }
        throw new IllegalStateException(I18N.getString("enterprise_distributedtx.deleteresource_for_localtx"));
    }

    @Override
    public boolean enlistResource(XAResource xaRes) throws RollbackException, IllegalStateException, SystemException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "--In JavaEETransactionImpl.enlistResource, jtsTx=" + String.valueOf(this.jtsTx) + " nonXAResource=" + String.valueOf(this.nonXAResource));
        }
        this.checkTransationActive();
        if (this.jtsTx != null) {
            return this.jtsTx.enlistResource(xaRes);
        }
        if (this.nonXAResource != null) {
            throw new IllegalStateException(I18N.getString("enterprise_distributedtx.already_has_nonxa"));
        }
        ((JavaEETransactionManagerSimplified)this.javaEETM).startJTSTx(this);
        return this.jtsTx.enlistResource(xaRes);
    }

    @Override
    public int getStatus() throws SystemException {
        if (this.jtsTx != null) {
            return this.jtsTx.getStatus();
        }
        return this.localTxStatus;
    }

    @Override
    public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "--In JavaEETransactionImpl.registerSynchronization START, jtsTx=" + String.valueOf(this.jtsTx) + ", nonXAResource=" + String.valueOf(this.nonXAResource) + ", sync=" + String.valueOf(sync));
        }
        this.checkTransationActive();
        if (this.jtsTx != null) {
            this.jtsTx.registerSynchronization(sync);
        } else {
            this.syncs.add(sync);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "--In JavaEETransactionImpl.registerSynchronization END, jtsTx=" + String.valueOf(this.jtsTx) + ", nonXAResource=" + String.valueOf(this.nonXAResource) + ", sync=" + String.valueOf(sync));
        }
    }

    @Override
    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.checkTransationActive();
        if (this.jtsTx != null) {
            this.jtsTx.setRollbackOnly();
        } else {
            this.localTxStatus = 1;
        }
    }

    private boolean isRollbackOnly() throws IllegalStateException, SystemException {
        int status = this.jtsTx != null ? this.jtsTx.getStatus() : this.localTxStatus;
        return status == 1;
    }

    private void checkTransationActive() throws SystemException {
        int status = this.getStatus();
        if (status != 1 && status != 0) {
            throw new IllegalStateException(I18N.getString("enterprise_distributedtx.transaction_notactive"));
        }
    }

    public String toString() {
        return "JavaEETransactionImpl: txId=" + this.txId + " nonXAResource=" + String.valueOf(this.nonXAResource) + " jtsTx=" + String.valueOf(this.jtsTx) + " localTxStatus=" + this.localTxStatus + " syncs=" + String.valueOf(this.syncs);
    }

    public String getTransactionId() {
        return this.xid.toString();
    }

    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public void setResources(Set resources, Object poolInfo) {
        this.resourceTable.put(poolInfo, resources);
    }

    @Override
    public Set getResources(Object poolInfo) {
        return this.resourceTable.get(poolInfo);
    }

    @Override
    public Set getAllParticipatingPools() {
        return this.resourceTable.keySet();
    }

    public void setActiveTxCache(Object cache) {
        this.activeTxCache = cache;
    }

    public Object getActiveTxCache() {
        return this.activeTxCache;
    }

    public int getRemainingTimeout() {
        if (this.timeout == 0) {
            return this.timeout;
        }
        if (this.timedOut) {
            return -1;
        }
        return this.timeout - (int)((System.currentTimeMillis() - this.startTime) / 1000L);
    }

    private static class JavaEEXid
    implements Xid {
        private static final int formatId = 987654321;
        private static final byte[] bqual = new byte[]{0};
        private byte[] gtrId = new byte[8];
        private String stringForm = null;

        JavaEEXid(long txId) {
            Utility.longToBytes(txId, this.gtrId, 0);
        }

        @Override
        public int getFormatId() {
            return 987654321;
        }

        @Override
        public byte[] getGlobalTransactionId() {
            return this.gtrId;
        }

        @Override
        public byte[] getBranchQualifier() {
            return bqual;
        }

        public String toString() {
            if (this.stringForm != null) {
                return this.stringForm;
            }
            char[] buff = new char[this.gtrId.length * 2 + 3];
            int pos = 0;
            int globalLen = this.gtrId.length;
            for (int i = 0; i < globalLen; ++i) {
                int currCharHigh = (this.gtrId[i] & 0xF0) >> 4;
                int currCharLow = this.gtrId[i] & 0xF;
                buff[pos++] = (char)(currCharHigh + (currCharHigh > 9 ? 55 : 48));
                buff[pos++] = (char)(currCharLow + (currCharLow > 9 ? 55 : 48));
            }
            buff[pos++] = 95;
            int currCharHigh = 0;
            int currCharLow = 0;
            buff[pos++] = (char)(currCharHigh + (currCharHigh > 9 ? 55 : 48));
            buff[pos++] = (char)(currCharLow + (currCharLow > 9 ? 55 : 48));
            this.stringForm = new String(buff);
            return this.stringForm;
        }
    }
}

