/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.commands;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.server.logging.LoggerInfoMetadata;
import com.sun.enterprise.util.ColumnFormatter;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@ExecuteOn(value={RuntimeType.DAS})
@Service(name="list-loggers")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="list.loggers")
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="list-loggers", description="list-loggers")})
public class ListLoggers
implements AdminCommand {
    private static final String UNKNOWN = "?";
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListLoggers.class);
    @Param(optional=true, name="_internal", defaultValue="false")
    private boolean listInternalLoggers;
    @Inject
    private LoggerInfoMetadata loggerInfoMetadataService;

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        String header_name = localStrings.getLocalString("list.loggers.header.name", "Logger Name");
        String header_subsystem = localStrings.getLocalString("list.loggers.header.subsystem", "Subsystem");
        String header_description = localStrings.getLocalString("list.loggers.header.description", "Logger Description");
        ColumnFormatter colFormatter = new ColumnFormatter(new String[]{header_name, header_subsystem, header_description});
        Locale locale = Locale.getDefault();
        try {
            Set<String> loggers = this.loggerInfoMetadataService.getLoggerNames();
            TreeSet<String> sortedLoggers = new TreeSet<String>(loggers);
            TreeMap<String, String> loggerSubsystems = new TreeMap<String, String>();
            TreeMap<String, String> loggerDescriptions = new TreeMap<String, String>();
            ArrayList<String> loggerList = new ArrayList<String>();
            for (String logger2 : sortedLoggers) {
                String subsystem = this.loggerInfoMetadataService.getSubsystem(logger2);
                String desc = this.loggerInfoMetadataService.getDescription(logger2, locale);
                boolean published = this.loggerInfoMetadataService.isPublished(logger2);
                if (subsystem == null) {
                    subsystem = UNKNOWN;
                }
                if (desc == null) {
                    desc = UNKNOWN;
                }
                if (!published && !this.listInternalLoggers) continue;
                colFormatter.addRow(new Object[]{logger2, subsystem, desc});
                loggerSubsystems.put(logger2, subsystem);
                loggerDescriptions.put(logger2, desc);
                loggerList.add(logger2);
            }
            report.appendMessage(colFormatter.toString());
            report.appendMessage(System.getProperty("line.separator"));
            Properties restData = new Properties();
            restData.put("loggerSubsystems", loggerSubsystems);
            restData.put("loggerDescriptions", loggerDescriptions);
            restData.put("loggers", loggerList);
            report.setExtraProperties(restData);
        }
        catch (Exception ex) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ex.printStackTrace(new PrintStream(out));
            report.setMessage(localStrings.getLocalString("list.loggers.failed", "Error listing loggers: {0}", out.toString()));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

