/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging;

import com.sun.appserv.server.util.Version;
import com.sun.common.util.logging.LoggingConfigImpl;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.io.FileUtils;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.validation.ValidationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.glassfish.api.VersionInfo;
import org.glassfish.api.admin.FileMonitoring;
import org.glassfish.config.support.TranslatedConfigView;
import org.glassfish.embeddable.GlassFishVariable;
import org.glassfish.hk2.api.Rank;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.config.UnprocessedConfigListener;
import org.glassfish.main.jul.GlassFishLogManager;
import org.glassfish.main.jul.GlassFishLogger;
import org.glassfish.main.jul.JULHelperFactory;
import org.glassfish.main.jul.cfg.GlassFishLogManagerConfiguration;
import org.glassfish.main.jul.cfg.LoggingProperties;
import org.glassfish.main.jul.env.LoggingSystemEnvironment;
import org.glassfish.main.jul.handler.GlassFishLogHandler;
import org.glassfish.main.jul.handler.GlassFishLogHandlerConfiguration;
import org.glassfish.main.jul.handler.GlassFishLogHandlerProperty;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Service;

@Service
@RunLevel(value=1)
@Rank(value=50)
public class LogManagerService
implements org.glassfish.internal.api.LogManager {
    private static final Logger LOG = Logger.getLogger(LogManagerService.class.getName(), "com.sun.enterprise.server.logging.LogMessages");
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    FileMonitoring fileMonitoring;
    @Inject
    LoggingConfigImpl loggingConfig;
    @Inject
    UnprocessedConfigListener ucl;
    @Inject
    Domain domain;
    private static final Consumer<Map.Entry<String, String>> PROPERTY_VALUE_RESOLVER = e -> {
        Object value = TranslatedConfigView.getTranslatedValue(e.getValue());
        e.setValue(value == null ? null : value.toString());
    };

    @PostConstruct
    public void postConstruct() {
        if (!GlassFishLogManager.isGlassFishLogManager()) {
            LOG.info(() -> "Detected other than GlassFishLogManager, the LogManagerService's features may be limited. Used log manager: " + String.valueOf(LogManager.getLogManager()));
        }
        this.setProductId();
        File loggingPropertiesFile = this.getOrCreateLoggingProperties();
        this.reconfigure(loggingPropertiesFile);
        this.configureFileMonitoring(loggingPropertiesFile);
        LOG.config("LogManagerService completed successfuly ...");
        LOG.log(Level.INFO, "NCLS-LOGGING-00009", Version.getProductIdInfo());
    }

    @Override
    public Map<String, String> getLoggingProperties() throws IOException {
        Server targetServer = this.domain.getServerNamed(this.env.getInstanceName());
        Map<String, String> loggingProperties = targetServer == null ? this.loggingConfig.getLoggingProperties() : (targetServer.isDas() ? this.loggingConfig.getLoggingProperties() : (targetServer.getCluster() != null ? this.loggingConfig.getLoggingProperties(targetServer.getCluster().getConfigRef()) : (targetServer.isInstance() ? this.loggingConfig.getLoggingProperties(targetServer.getConfigRef()) : this.loggingConfig.getLoggingProperties())));
        Map<String, String> invalidProps = this.validateLoggingProperties(loggingProperties);
        if (!invalidProps.isEmpty()) {
            return this.loggingConfig.deleteLoggingProperties(invalidProps.keySet());
        }
        return loggingProperties;
    }

    @Override
    public File getLoggingPropertiesFile() throws IOException {
        Server targetServer = this.domain.getServerNamed(this.env.getInstanceName());
        if (targetServer == null) {
            return new File(this.env.getConfigDirPath(), "logging.properties");
        }
        if (targetServer.isDas()) {
            return new File(this.env.getConfigDirPath(), "logging.properties");
        }
        if (targetServer.getCluster() != null) {
            File dirForLogging = new File(this.env.getConfigDirPath(), targetServer.getCluster().getConfigRef());
            return new File(dirForLogging, "logging.properties");
        }
        if (targetServer.isInstance()) {
            File dirForLogging = new File(this.env.getConfigDirPath(), targetServer.getConfigRef());
            return new File(dirForLogging, "logging.properties");
        }
        return new File(this.env.getConfigDirPath(), "logging.properties");
    }

    @Override
    public void addHandler(Handler handler) {
        LOG.config(() -> "LogManagerService.addHandler(" + String.valueOf(handler) + ")");
        GlassFishLogger rootLogger = this.getRootLogger();
        if (rootLogger != null && rootLogger.getHandler(handler.getClass()) == null) {
            rootLogger.addHandler(handler);
        }
    }

    @Override
    public PrintStream getErrStream() {
        return LoggingSystemEnvironment.getOriginalStdErr();
    }

    @Override
    public PrintStream getOutStream() {
        return LoggingSystemEnvironment.getOriginalStdOut();
    }

    public Map<String, String> validateLoggingProperties(Map<String, String> loggingProperties) {
        HashMap<String, String> invalidProps = new HashMap<String, String>();
        for (Map.Entry<String, String> propertyEntry : loggingProperties.entrySet()) {
            try {
                this.validateLoggingProperty(propertyEntry.getKey(), propertyEntry.getValue());
            }
            catch (ValidationException ex) {
                LOG.log(Level.WARNING, "Error validating log property.", ex);
                invalidProps.put(propertyEntry.getKey(), propertyEntry.getValue());
            }
        }
        return invalidProps;
    }

    public void validateLoggingProperty(String key, String value) {
        int rotationTimeLimit;
        if (this.isOneOf(key, GlassFishLogHandlerProperty.ROTATION_LIMIT_SIZE, GlassFishLogHandler.class)) {
            int rotationSizeLimit = Integer.parseInt(value);
            if (rotationSizeLimit != 0 && rotationSizeLimit < 1) {
                throw new ValidationException(String.format("'%s' value must be greater than %d, but was %d.", key, 1, rotationSizeLimit));
            }
        } else if (this.isOneOf(key, GlassFishLogHandlerProperty.ROTATION_LIMIT_TIME, GlassFishLogHandler.class) && (rotationTimeLimit = Integer.parseInt(value)) < 0) {
            throw new ValidationException(String.format("'%s' value must be greater than %d, but was %d.", key, 0, rotationTimeLimit));
        }
    }

    @PreDestroy
    public void preDestroy() {
        LOG.config("Completed shutdown of the Log Manager Service");
    }

    private void setProductId() {
        ServiceLocator locator = Globals.getDefaultBaseServiceLocator();
        VersionInfo versionInfo = locator.getService(VersionInfo.class, new Annotation[0]);
        if (versionInfo == null) {
            LoggingSystemEnvironment.setProductId(null);
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(versionInfo.getProductNameAbbreviation());
        sb.append(' ');
        sb.append(versionInfo.getFullVersion());
        LoggingSystemEnvironment.setProductId(sb.toString());
    }

    private File getOrCreateLoggingProperties() {
        String loggingPropertiesJvmOption = System.getProperty("java.util.logging.config.file");
        LOG.finest(() -> "Logging configuration from JVM option java.util.logging.config.file=" + loggingPropertiesJvmOption);
        if (loggingPropertiesJvmOption == null) {
            return this.getExistingLoggingPropertiesFile();
        }
        return new File(loggingPropertiesJvmOption);
    }

    private File getExistingLoggingPropertiesFile() {
        try {
            File configuredFile = this.getLoggingPropertiesFile();
            if (configuredFile.exists()) {
                return configuredFile;
            }
            String rootFolder = this.env.getProps().get(GlassFishVariable.INSTALL_ROOT.getPropertyName());
            String templateDir = rootFolder + File.separator + "lib" + File.separator + "templates";
            File src = new File(templateDir, "logging.properties");
            File dest = new File(this.env.getConfigDirPath(), "logging.properties");
            LOG.log(Level.INFO, "{0} not found, creating new file from template {1}.", new Object[]{dest, src});
            FileUtils.copy(src, dest);
            return dest;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "NCLS-LOGGING-00001", e);
            return null;
        }
    }

    private Handler[] getRootHandlers() {
        return this.getRootLogger().getHandlers();
    }

    private GlassFishLogger getRootLogger() {
        return GlassFishLogManager.getLogManager().getRootLogger();
    }

    private GlassFishLogManagerConfiguration getRuntimeConfiguration() throws IOException {
        Map<String, String> instanceLogCfgMap = this.getResolvedLoggingProperties();
        LoggingProperties instanceLogCfg = new LoggingProperties();
        instanceLogCfg.putAll(instanceLogCfgMap);
        return new GlassFishLogManagerConfiguration(instanceLogCfg);
    }

    private Map<String, String> getResolvedLoggingProperties() throws IOException {
        Map<String, String> properties = this.getLoggingProperties();
        properties.entrySet().stream().forEach(PROPERTY_VALUE_RESOLVER);
        return properties;
    }

    private void reconfigure(File configFile) {
        LOG.info(() -> "Using property file: " + String.valueOf(configFile));
        if (!GlassFishLogManager.isGlassFishLogManager()) {
            try (FileInputStream configuration = new FileInputStream(configFile);){
                LogManager.getLogManager().updateConfiguration(configuration, null);
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "NCLS-LOGGING-00002", e);
            }
            return;
        }
        GlassFishLogManager manager = GlassFishLogManager.getLogManager();
        try {
            GlassFishLogManagerConfiguration cfg = this.getRuntimeConfiguration();
            if (cfg == null) {
                return;
            }
            ReconfigurationAction reconfig = new ReconfigurationAction(cfg);
            manager.reconfigure(cfg, reconfig, null);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "NCLS-LOGGING-00002", e);
        }
    }

    private void configureFileMonitoring(File loggingPropertiesFile) {
        LOG.config("Configuring change detection of the configuration file ...");
        this.fileMonitoring.monitors(loggingPropertiesFile, new LoggingCfgFileChangeListener(this::reconfigure, this::configureFileMonitoring));
    }

    private void reconfigureGlassFishLogHandler() {
        GlassFishLogHandler handler = JULHelperFactory.getHelper().findGlassFishLogHandler();
        if (handler == null) {
            LOG.warning("The GlassFishLogHandler was not found, it's reconfiguration is not possible.");
        } else {
            GlassFishLogHandlerConfiguration cfg = GlassFishLogHandler.createGlassFishLogHandlerConfiguration(GlassFishLogHandler.class);
            handler.reconfigure(cfg);
        }
    }

    private boolean isOneOf(String key, GlassFishLogHandlerProperty attribute, Class<?> ... handlerClasses) {
        for (Class<?> handlerClass : handlerClasses) {
            if (!attribute.getPropertyFullName(handlerClass).equals(key)) continue;
            return true;
        }
        return false;
    }

    private boolean isKnownHandlerClass(String name) {
        try {
            Class<?> handlerClazz = Class.forName(name, false, LogManagerService.class.getClassLoader());
            return Handler.class.isAssignableFrom(handlerClazz);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private final class ReconfigurationAction
    implements GlassFishLogManager.Action {
        private final GlassFishLogManagerConfiguration cfg;
        private final ClassLoader classLoader;

        private ReconfigurationAction(GlassFishLogManagerConfiguration cfg) {
            this.cfg = cfg;
            this.classLoader = Thread.currentThread().getContextClassLoader();
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        @Override
        public void run() {
            LogManagerService.this.reconfigureGlassFishLogHandler();
            HashMap loggerLevels = new HashMap();
            HashMap handlerLevels = new HashMap();
            Handler[] rootHandlers = LogManagerService.this.getRootHandlers();
            LOG.config(() -> "Actual root handlers=" + Arrays.toString(rootHandlers));
            this.cfg.toStream().forEach(entry -> {
                if (this.checkLevels(entry.getKey(), entry.getValue(), handlerLevels, loggerLevels)) {
                    return;
                }
            });
            for (Handler handler : rootHandlers) {
                handler.setLevel(handlerLevels.getOrDefault(handler.getClass().getName(), Level.INFO));
            }
        }

        private boolean checkLevels(String key, String value, Map<String, Level> handlerLevels, Map<String, Level> loggerLevels) {
            if (key.endsWith(".level")) {
                String name = key.substring(0, key.lastIndexOf(".level"));
                Level level = Level.parse(value);
                if (LogManagerService.this.isKnownHandlerClass(name)) {
                    handlerLevels.put(name, level);
                } else {
                    loggerLevels.put(name, level);
                }
                return true;
            }
            return false;
        }
    }

    private static final class LoggingCfgFileChangeListener
    implements FileMonitoring.FileChangeListener {
        private final Consumer<File> reconfiguration;
        private final Consumer<File> fileMonitoring;

        LoggingCfgFileChangeListener(Consumer<File> reconfiguration, Consumer<File> fileMonitoring) {
            this.reconfiguration = reconfiguration;
            this.fileMonitoring = fileMonitoring;
        }

        @Override
        public void changed(File changedFile) {
            LOG.info(() -> "Detected change of file: " + String.valueOf(changedFile));
            this.reconfiguration.accept(changedFile);
        }

        @Override
        public void deleted(File deletedFile) {
            LOG.log(Level.SEVERE, "NCLS-LOGGING-00004", deletedFile.getAbsolutePath());
            Runnable waitingJob = () -> this.waitUntilFileReappears(deletedFile);
            Thread thread = new Thread(waitingJob, "Wait-to-reappear-" + deletedFile.getName());
            thread.setDaemon(true);
            thread.start();
        }

        private void waitUntilFileReappears(File deletedFile) {
            while (!deletedFile.exists()) {
                Thread.onSpinWait();
            }
            LOG.log(Level.INFO, "NCLS-LOGGING-00004-1", deletedFile.getAbsolutePath());
            this.reconfiguration.accept(deletedFile);
            this.fileMonitoring.accept(deletedFile);
        }
    }
}

