/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ssl;

import com.sun.enterprise.security.ssl.J2EEKeyManager;
import com.sun.enterprise.security.ssl.SSLUtils;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.security.KeyStore;
import java.util.Objects;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509KeyManager;
import org.glassfish.grizzly.config.ssl.SSLContextFactory;
import org.glassfish.hk2.api.ServiceLocator;

public class GlassFishSSLContextFactory
extends SSLContextFactory {
    private static final System.Logger LOG = System.getLogger(GlassFishSSLContextFactory.class.getName());
    private final ServiceLocator locator;
    private SSLUtils sslUtils;

    public GlassFishSSLContextFactory(ServiceLocator locator) {
        this.locator = Objects.requireNonNull(locator, "locator");
    }

    @Override
    public SSLContext create() throws IOException {
        this.sslUtils = this.locator.getService(SSLUtils.class, new Annotation[0]);
        return super.create();
    }

    @Override
    protected KeyManager[] getKeyManagers(String algorithm, String keyAlias) throws Exception {
        String keystoreFile = this.getAttribute("keystore");
        LOG.log(System.Logger.Level.DEBUG, "Keystore file = {0}", keystoreFile);
        String keystoreType = this.getAttribute("keystoreType");
        LOG.log(System.Logger.Level.DEBUG, "Keystore type = {0}", keystoreType);
        KeyManager[] kMgrs = this.sslUtils.getKeyManagers(algorithm);
        if (keyAlias != null && keyAlias.length() > 0 && kMgrs != null) {
            for (int i = 0; i < kMgrs.length; ++i) {
                kMgrs[i] = new J2EEKeyManager((X509KeyManager)kMgrs[i], keyAlias);
            }
        }
        return kMgrs;
    }

    @Override
    protected KeyStore getTrustStore() throws IOException {
        return this.sslUtils.getTrustStore();
    }
}

