/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ee.authorization;

import jakarta.security.jacc.PrincipalMapper;
import java.security.Principal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.glassfish.deployment.common.SecurityRoleMapper;
import org.glassfish.deployment.common.SecurityRoleMapperFactory;
import org.glassfish.internal.api.Globals;

public class GlassFishPrincipalMapper
implements PrincipalMapper {
    private final SecurityRoleMapper roleMapper;
    private final Map<String, Set<String>> groupToRoles;
    private final Map<String, Set<String>> callerToRoles;
    private final boolean oneToOneMapping;
    private final boolean anyAuthenticatedUserRoleMapped;

    public GlassFishPrincipalMapper(String contextId) {
        this.roleMapper = Globals.get(SecurityRoleMapperFactory.class).getRoleMapper(contextId);
        this.groupToRoles = this.roleMapper.getGroupToRolesMapping();
        this.callerToRoles = this.roleMapper.getCallerToRolesMapping();
        this.oneToOneMapping = this.groupToRoles.isEmpty() && this.callerToRoles.isEmpty() && this.roleMapper.isDefaultPrincipalToRoleMapping();
        this.anyAuthenticatedUserRoleMapped = this.groupToRoles.values().stream().flatMap(roles -> roles.stream()).anyMatch(role -> role.equals("**"));
    }

    @Override
    public Principal getCallerPrincipal(Subject subject) {
        return this.roleMapper.getCallerPrincipal(subject);
    }

    @Override
    public Set<String> getMappedRoles(Subject subject) {
        Set<String> mappedRoles = this.mapGroupsToRoles(this.roleMapper.getGroups(subject));
        Principal callerPrincipal = this.getCallerPrincipal(subject);
        if (callerPrincipal != null && this.callerToRoles.containsKey(callerPrincipal.getName())) {
            mappedRoles = new HashSet<String>(mappedRoles);
            mappedRoles.addAll((Collection<String>)this.callerToRoles.get(callerPrincipal.getName()));
        }
        return mappedRoles;
    }

    @Override
    public boolean isAnyAuthenticatedUserRoleMapped() {
        return this.anyAuthenticatedUserRoleMapped;
    }

    private Set<String> mapGroupsToRoles(Set<String> groups) {
        if (this.oneToOneMapping) {
            return groups;
        }
        HashSet<String> roles = new HashSet<String>();
        for (String group : groups) {
            if (!this.groupToRoles.containsKey(group)) continue;
            roles.addAll((Collection<String>)this.groupToRoles.get(group));
        }
        return roles;
    }
}

