/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.common;

import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.EmbeddedSecurity;
import com.sun.enterprise.security.SecurityLoggerInfo;
import com.sun.enterprise.util.io.FileUtils;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.internal.embedded.EmbeddedFileSystem;
import org.glassfish.internal.embedded.EmbeddedLifecycle;
import org.glassfish.internal.embedded.Server;
import org.jvnet.hk2.annotations.Service;

@Service
public class EmbeddedSecurityLifeCycle
implements EmbeddedLifecycle {
    private static final Logger _logger = SecurityLoggerInfo.getLogger();
    @Inject
    private EmbeddedSecurity embeddedSecurity;
    @Inject
    @Named(value="default-instance-name")
    private SecurityService securityService;

    @Override
    public void creation(Server server) {
        EmbeddedFileSystem fileSystem = server.getFileSystem();
        File instanceRoot = fileSystem.instanceRoot;
        if (instanceRoot == null) {
            return;
        }
        try {
            List<String> keyFileNames = this.embeddedSecurity.getKeyFileNames(this.securityService);
            File cfgDir = new File(instanceRoot, "config");
            for (String keyFileName : keyFileNames) {
                FileUtils.copyResourceToDirectory(this.embeddedSecurity.parseFileName(keyFileName), cfgDir);
            }
            FileUtils.copyResourceToDirectory("server.policy", cfgDir);
        }
        catch (IOException ioEx) {
            _logger.log(Level.WARNING, "NCLS-SECURITY-01013", ioEx);
        }
    }

    @Override
    public void destruction(Server server) {
    }
}

