/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm;

import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.security.SecurityLoggerInfo;
import com.sun.enterprise.security.auth.realm.Realm;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.config.types.Property;

public class RealmConfig {
    private static Logger logger = SecurityLoggerInfo.getLogger();

    public static void createRealms(String defaultRealm, List<AuthRealm> realms) {
        RealmConfig.createRealms(defaultRealm, realms, null);
    }

    public static void createRealms(String defaultRealm, List<AuthRealm> realms, String configName) {
        String goodRealm = null;
        for (AuthRealm realm : realms) {
            String realmName = realm.getName();
            String realmClass = realm.getClassname();
            try {
                List<Property> realmProps = realm.getProperty();
                Properties props = new Properties();
                for (Property realmProp : realmProps) {
                    props.setProperty(realmProp.getName(), realmProp.getValue());
                }
                Realm.instantiate(realmName, realmClass, props, configName);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Configured realm: " + realmName);
                }
                if (goodRealm != null) continue;
                goodRealm = realmName;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "NCLS-SECURITY-01100", realmName);
                logger.log(Level.WARNING, "NCLS-SECURITY-01000", e);
            }
        }
        if (goodRealm == null) {
            logger.severe("NCLS-SECURITY-01101");
        } else {
            try {
                Realm.getInstance(defaultRealm);
            }
            catch (Exception e) {
                defaultRealm = goodRealm;
            }
            Realm.setDefaultRealm(defaultRealm);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Default realm is set to: " + defaultRealm);
            }
        }
    }
}

