/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.security.ContainerSecurityLifecycle;
import com.sun.enterprise.security.SecurityLifecycleException;
import com.sun.enterprise.security.SecurityLoggerInfo;
import com.sun.enterprise.security.SecurityServicesUtil;
import com.sun.enterprise.security.audit.AuditManager;
import com.sun.enterprise.security.auth.realm.RealmsManager;
import com.sun.enterprise.security.common.Util;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.main.jdke.props.SystemProperties;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class SecurityLifecycle
implements PostConstruct,
PreDestroy {
    private static final Logger _logger = SecurityLoggerInfo.getLogger();
    private static final String SYS_PROP_LOGIN_CONF = "java.security.auth.login.config";
    private static final String SYS_PROP_JAVA_SEC_POLICY = "java.security.policy";
    @Inject
    private SecurityServicesUtil securityServicesUtil;
    @Inject
    private ServiceLocator serviceLocator;
    @Inject
    private RealmsManager realmsManager;
    @Inject
    @Optional
    private ContainerSecurityLifecycle eeSecLifecycle;
    private EventListener listener;

    public SecurityLifecycle() {
        try {
            if (Util.isEmbeddedServer()) {
                SystemProperties.setProperty(SYS_PROP_LOGIN_CONF, Util.writeConfigFileToTempDir("login.conf").toURI().toURL().toExternalForm(), false);
                SystemProperties.setProperty(SYS_PROP_JAVA_SEC_POLICY, Util.writeConfigFileToTempDir("server.policy").getAbsolutePath(), false);
            }
            _logger.info(System.getSecurityManager() == null ? "NCLS-SECURITY-01002" : "NCLS-SECURITY-01001");
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "java_security.init_securitylifecycle_fail", ex);
            throw new RuntimeException(ex.toString(), ex);
        }
    }

    public void onInitialization() {
        try {
            _logger.log(Level.INFO, "NCLS-SECURITY-01010");
            this.realmsManager.createRealms();
            AuditManager auditManager = this.securityServicesUtil.getAuditManager();
            auditManager.loadAuditModules();
            auditManager.serverStarted();
            _logger.log(Level.INFO, "NCLS-SECURITY-01011");
        }
        catch (Exception ex) {
            throw new SecurityLifecycleException(ex);
        }
    }

    @Override
    public void postConstruct() {
        this.onInitialization();
        this.listener = new AuditServerShutdownListener();
        Events events = this.serviceLocator.getService(Events.class, new Annotation[0]);
        events.register(this.listener);
    }

    @Override
    public void preDestroy() {
    }

    public class AuditServerShutdownListener
    implements EventListener {
        @Override
        public void event(EventListener.Event<?> event) {
            if (EventTypes.SERVER_SHUTDOWN.equals(event.type())) {
                SecurityLifecycle.this.securityServicesUtil.getAuditManager().serverShutdown();
            }
        }
    }
}

