/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.security.GUIErrorDialog;
import com.sun.enterprise.security.ssl.SSLUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.glassfish.internal.api.Globals;

class PassphraseDialog
extends JDialog {
    private NameCallback nameCallback = null;
    private PasswordCallback passwordCallback = null;
    private ChoiceCallback choiceCallback = null;
    private JTextField userField;
    private JPasswordField passField;
    private JList choiceList;
    private JFrame frame;
    private JButton okButton;
    private JButton cancelButton;
    private JButton okForKP;
    private JButton cancelForKP;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(PassphraseDialog.class);
    String username = "";
    char[] passphrase = null;
    private JPasswordField keystorePassword;
    private JLabel lbl;
    private JPanel pnl = new JPanel(new GridLayout(2, 0));
    private JPanel bpanel = new JPanel(new FlowLayout());
    private JPanel kpPanel = new JPanel(new FlowLayout());
    private final String pnlKeyStorePassword = "Keystore Password Box";
    private final String pnlCertificateList = "Cerificate Chooser";
    private JPanel pnl2 = new JPanel();

    protected PassphraseDialog(JFrame frame, String title) {
        super(frame, title, true);
        this.frame = frame;
        super.dialogInit();
        this.initbox();
    }

    protected PassphraseDialog(JFrame frame, String title, Callback[] callbacks) {
        super(frame, title, true);
        this.frame = frame;
        super.dialogInit();
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof NameCallback) {
                this.nameCallback = (NameCallback)callbacks[i];
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                this.passwordCallback = (PasswordCallback)callbacks[i];
                continue;
            }
            if (!(callbacks[i] instanceof ChoiceCallback)) continue;
            this.choiceCallback = (ChoiceCallback)callbacks[i];
        }
        this.initbox();
    }

    private void initbox() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.pnl2.setLayout(gridbag);
        this.getContentPane().setLayout(new CardLayout());
        int gridx = 0;
        int gridy = 0;
        this.passField = new JPasswordField(20);
        this.userField = new JTextField(20);
        this.choiceList = new JList();
        if (this.nameCallback != null) {
            c.gridx = gridx++;
            c.gridy = gridy;
            c.anchor = 10;
            c.insets = new Insets(20, 10, 10, 2);
            JLabel jl = new JLabel(this.nameCallback.getPrompt() + ": ");
            gridbag.setConstraints(jl, c);
            this.pnl2.add(jl);
            c.gridx = gridx++;
            c.gridy = gridy++;
            c.fill = 2;
            c.insets = new Insets(20, 3, 10, 10);
            this.userField.setText(this.nameCallback.getDefaultName());
            gridbag.setConstraints(this.userField, c);
            this.userField.selectAll();
            this.pnl2.add(this.userField);
        }
        if (this.passwordCallback != null) {
            gridx = 0;
            c.gridx = gridx++;
            c.gridy = gridy;
            c.anchor = 10;
            c.insets = new Insets(20, 10, 10, 2);
            JLabel l = new JLabel(this.passwordCallback.getPrompt());
            gridbag.setConstraints(l, c);
            this.pnl2.add(l);
            c.gridx = gridx++;
            c.gridy = gridy++;
            c.fill = 2;
            c.insets = new Insets(20, 3, 10, 10);
            gridbag.setConstraints(this.passField, c);
            this.pnl2.add(this.passField);
        }
        if (this.choiceCallback != null) {
            this.lbl = new JLabel(localStrings.getLocalString("enterprise.security.keystore", "Enter the KeyStore Password "));
            this.keystorePassword = new JPasswordField(20);
            this.kpPanel.add(this.lbl);
            this.kpPanel.add(this.keystorePassword);
            final SSLUtils sslUtils = Globals.get(SSLUtils.class);
            this.okForKP = new JButton(localStrings.getLocalString("enterprise.security.ok", " OK "));
            this.okForKP.setActionCommand("ok");
            this.okForKP.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    char[] passKPFromUser = PassphraseDialog.this.keystorePassword.getPassword();
                    if (sslUtils.verifyMasterPassword(passKPFromUser)) {
                        PassphraseDialog.this.okForKP.setEnabled(false);
                        PassphraseDialog.this.cancelForKP.setEnabled(false);
                        PassphraseDialog.this.keystorePassword.setEditable(false);
                        CardLayout cl = (CardLayout)PassphraseDialog.this.getContentPane().getLayout();
                        cl.show(PassphraseDialog.this.getContentPane(), "Cerificate Chooser");
                    } else {
                        String errmessage = localStrings.getLocalString("enterprise.security.IncorrectKeystorePassword", "Incorrect Keystore Password");
                        GUIErrorDialog guierr = new GUIErrorDialog(errmessage);
                        guierr.setVisible(true);
                    }
                    Arrays.fill(passKPFromUser, ' ');
                }
            });
            this.cancelForKP = new JButton(localStrings.getLocalString("enterprise.security.cancel", "Cancel"));
            this.cancelForKP.setActionCommand("cancel");
            this.cancelForKP.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    if (PassphraseDialog.this.choiceCallback != null) {
                        PassphraseDialog.this.choiceCallback.setSelectedIndex(-1);
                    }
                    PassphraseDialog.this.frame.dispose();
                }
            });
            this.bpanel.add(this.okForKP);
            this.bpanel.add(this.cancelForKP);
            this.pnl.add(this.kpPanel);
            this.pnl.add(this.bpanel);
            gridx = 0;
            c.gridx = gridx++;
            c.gridy = gridy;
            c.anchor = 10;
            c.insets = new Insets(20, 10, 10, 2);
            JLabel l = new JLabel(this.choiceCallback.getPrompt());
            gridbag.setConstraints(l, c);
            this.pnl2.add(l);
            c.gridx = gridx++;
            c.gridy = gridy++;
            c.fill = 2;
            c.insets = new Insets(20, 3, 10, 10);
            String[] choices = this.choiceCallback.getChoices();
            this.choiceList.setListData(choices);
            gridbag.setConstraints(this.choiceList, c);
            this.pnl2.add(this.choiceList);
        }
        this.okButton = new JButton(localStrings.getLocalString("enterprise.security.ok", " OK "));
        this.okButton.setActionCommand("ok");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int idx;
                PassphraseDialog.this.username = PassphraseDialog.this.userField.getText();
                if (PassphraseDialog.this.username.trim().length() > 0) {
                    PassphraseDialog.this.nameCallback.setName(PassphraseDialog.this.username);
                }
                if (PassphraseDialog.this.passwordCallback != null) {
                    char[] pass = PassphraseDialog.this.passField.getPassword();
                    PassphraseDialog.this.passwordCallback.setPassword(pass);
                }
                if (PassphraseDialog.this.choiceCallback != null && (idx = PassphraseDialog.this.choiceList.getSelectedIndex()) != -1) {
                    PassphraseDialog.this.choiceCallback.setSelectedIndex(idx);
                }
                PassphraseDialog.this.frame.dispose();
            }
        });
        this.cancelButton = new JButton(localStrings.getLocalString("enterprise.security.cancel", "Cancel"));
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (PassphraseDialog.this.choiceCallback != null) {
                    PassphraseDialog.this.choiceCallback.setSelectedIndex(-1);
                } else {
                    PassphraseDialog.this.username = null;
                    if (PassphraseDialog.this.passphrase != null) {
                        Arrays.fill(PassphraseDialog.this.passphrase, ' ');
                    }
                    PassphraseDialog.this.frame.dispose();
                }
            }
        });
        super.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                if (PassphraseDialog.this.choiceCallback != null) {
                    PassphraseDialog.this.choiceCallback.setSelectedIndex(-1);
                }
                PassphraseDialog.this.frame.dispose();
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(gridbag);
        c.insets = new Insets(5, 0, 5, 15);
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 10;
        c.fill = 0;
        gridbag.setConstraints(this.okButton, c);
        buttonPanel.add(this.okButton);
        c.gridx = 2;
        c.insets = new Insets(5, 15, 5, 0);
        gridbag.setConstraints(this.cancelButton, c);
        buttonPanel.add(this.cancelButton);
        c.gridx = 0;
        c.gridy = gridy++;
        c.gridwidth = 2;
        c.insets = new Insets(0, 0, 5, 0);
        c.fill = 2;
        c.anchor = 17;
        gridbag.setConstraints(buttonPanel, c);
        this.pnl2.add(buttonPanel);
        this.getContentPane().add((Component)this.pnl, "Keystore Password Box");
        this.getContentPane().add((Component)this.pnl2, "Cerificate Chooser");
        CardLayout cl = (CardLayout)this.getContentPane().getLayout();
        if (this.choiceCallback != null) {
            cl.show(this.getContentPane(), "Keystore Password Box");
        } else {
            cl.show(this.getContentPane(), "Cerificate Chooser");
        }
        this.pack();
        this.setSize(this.getPreferredSize());
    }
}

