/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool.monitor;

import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.resource.pool.PoolLifeCycleListenerRegistry;
import com.sun.enterprise.resource.pool.PoolStatus;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.RangeStatistic;
import org.glassfish.external.statistics.annotations.Reset;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.external.statistics.impl.RangeStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.resourcebase.resources.api.PoolInfo;

@AMXMetadata(type="connector-connection-pool-mon", group="monitoring")
@ManagedObject
@Description(value="Connector Connection Pool Statistics")
public class ConnectorConnPoolStatsProvider {
    private static final System.Logger LOG = System.getLogger(ConnectorConnPoolStatsProvider.class.getName());
    private final PoolInfo poolInfo;
    private PoolLifeCycleListenerRegistry poolRegistry;
    private final CountStatisticImpl numConnFailedValidation = new CountStatisticImpl("NumConnFailedValidation", "count", "The total number of connections in the connection pool that failed validation from the start time until the last sample time.");
    private final CountStatisticImpl numConnTimedOut = new CountStatisticImpl("NumConnTimedOut", "count", "The total number of connections in the pool that timed out between the start time and the last sample time.");
    private final RangeStatisticImpl numConnFree = new RangeStatisticImpl(0L, 0L, 0L, "NumConnFree", "count", "The total number of free connections in the pool as of the last sampling.", System.currentTimeMillis(), System.currentTimeMillis());
    private final RangeStatisticImpl numConnUsed = new RangeStatisticImpl(0L, 0L, 0L, "NumConnUsed", "count", "Provides connection usage statistics. The total number of connections that are currently being used, as well as information about the maximum number of connections that were used (the high water mark).", System.currentTimeMillis(), System.currentTimeMillis());
    private final RangeStatisticImpl connRequestWaitTime = new RangeStatisticImpl(0L, 0L, 0L, "ConnRequestWaitTime", "millisecond", "The longest and shortest wait times of connection requests. The current value indicates the wait time of the last request that was serviced by the pool.", System.currentTimeMillis(), System.currentTimeMillis());
    private final CountStatisticImpl numConnDestroyed = new CountStatisticImpl("NumConnDestroyed", "count", "Number of physical connections that were destroyed since the last reset.");
    private final CountStatisticImpl numConnAcquired = new CountStatisticImpl("NumConnAcquired", "count", "Number of logical connections acquired from the pool.");
    private final CountStatisticImpl numConnReleased = new CountStatisticImpl("NumConnReleased", "count", "Number of logical connections released to the pool.");
    private final CountStatisticImpl numConnCreated = new CountStatisticImpl("NumConnCreated", "count", "The number of physical connections that were created since the last reset.");
    private final CountStatisticImpl numPotentialConnLeak = new CountStatisticImpl("NumPotentialConnLeak", "count", "Number of potential connection leaks");
    private final CountStatisticImpl numConnSuccessfullyMatched = new CountStatisticImpl("NumConnSuccessfullyMatched", "count", "Number of connections succesfully matched");
    private final CountStatisticImpl numConnNotSuccessfullyMatched = new CountStatisticImpl("NumConnNotSuccessfullyMatched", "count", "Number of connections rejected during matching");
    private final CountStatisticImpl totalConnRequestWaitTime = new CountStatisticImpl("TotalConnRequestWaitTime", "millisecond", "Total wait time per successful connection request");
    private final CountStatisticImpl averageConnWaitTime = new CountStatisticImpl("AverageConnWaitTime", "millisecond", "Average wait-time-duration per successful connection request");
    private final CountStatisticImpl waitQueueLength = new CountStatisticImpl("WaitQueueLength", "count", "Number of connection requests in the queue waiting to be serviced.");
    private static final String JCA_PROBE_LISTENER = "glassfish:jca:connection-pool:";

    public ConnectorConnPoolStatsProvider(PoolInfo poolInfo) {
        this.poolInfo = poolInfo;
    }

    @ProbeListener(value="glassfish:jca:connection-pool:potentialConnLeakEvent")
    public void potentialConnLeakEvent(@ProbeParam(value="poolName") String poolName, @ProbeParam(value="appName") String appName, @ProbeParam(value="moduleName") String moduleName) {
        if (this.isMyPool(poolName, appName, moduleName)) {
            LOG.log(System.Logger.Level.DEBUG, "Connection Leak event received for pool: {0}", this.poolInfo);
            this.numPotentialConnLeak.increment();
        }
    }

    @ProbeListener(value="glassfish:jca:connection-pool:connectionTimedOutEvent")
    public void connectionTimedOutEvent(@ProbeParam(value="poolName") String poolName, @ProbeParam(value="appName") String appName, @ProbeParam(value="moduleName") String moduleName) {
        if (this.isMyPool(poolName, appName, moduleName)) {
            LOG.log(System.Logger.Level.DEBUG, "Connection Timed-out event received for pool: {0}", this.poolInfo);
            this.numConnTimedOut.increment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ProbeListener(value="glassfish:jca:connection-pool:decrementNumConnFreeEvent")
    public void decrementNumConnFreeEvent(@ProbeParam(value="poolName") String poolName, @ProbeParam(value="appName") String appName, @ProbeParam(value="moduleName") String moduleName) {
        if (this.isMyPool(poolName, appName, moduleName)) {
            LOG.log(System.Logger.Level.DEBUG, "Decrement Num Connections Free event received for pool: {0}", this.poolInfo);
            RangeStatisticImpl rangeStatisticImpl = this.numConnFree;
            synchronized (rangeStatisticImpl) {
                this.numConnFree.setCurrent(this.numConnFree.getCurrent() - 1L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ProbeListener(value="glassfish:jca:connection-pool:incrementNumConnFreeEvent")
    public void incrementNumConnFreeEvent(@ProbeParam(value="poolName") String poolName, @ProbeParam(value="appName") String appName, @ProbeParam(value="moduleName") String moduleName, @ProbeParam(value="beingDestroyed") boolean beingDestroyed, @ProbeParam(value="steadyPoolSize") int steadyPoolSize) {
        if (this.isMyPool(poolName, appName, moduleName)) {
            LOG.log(System.Logger.Level.DEBUG, "Increment Num Connections Free event received for pool: {0}", this.poolInfo);
            if (beingDestroyed) {
                RangeStatisticImpl rangeStatisticImpl = this.numConnFree;
                synchronized (rangeStatisticImpl) {
                    RangeStatisticImpl rangeStatisticImpl2 = this.numConnUsed;
                    synchronized (rangeStatisticImpl2) {
                        if (this.numConnFree.getCurrent() + this.numConnUsed.getCurrent() < (long)steadyPoolSize) {
                            this.numConnFree.setCurrent(this.numConnFree.getCurrent() + 1L);
                        }
                    }
                }
            }
            RangeStatisticImpl rangeStatisticImpl = this.numConnFree;
            synchronized (rangeStatisticImpl) {
                this.numConnFree.setCurrent(this.numConnFree.getCurrent() + 1L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ProbeListener(value="glassfish:jca:connection-pool:decrementConnectionUsedEvent")
    public void decrementConnectionUsedEvent(@ProbeParam(value="poolName") String poolName, @ProbeParam(value="appName") String appName, @ProbeParam(value="moduleName") String moduleName) {
        if (this.isMyPool(poolName, appName, moduleName)) {
            LOG.log(System.Logger.Level.DEBUG, "Decrement Num Connections Used event received for pool: {0}", this.poolInfo);
            RangeStatisticImpl rangeStatisticImpl = this.numConnUsed;
            synchronized (rangeStatisticImpl) {
                long newValue = this.numConnUsed.getCurrent() - 1L;
                if (newValue < 0L) {
                    return;
                }
                this.numConnUsed.setCurrent(newValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ProbeListener(value="glassfish:jca:connection-pool:connectionsFreedEvent")
    public void connectionsFreedEvent(@ProbeParam(value="poolName") String poolName, @ProbeParam(value="appName") String appName, @ProbeParam(value="moduleName") String moduleName, @ProbeParam(value="count") int count) {
        if (this.isMyPool(poolName, appName, moduleName)) {
            LOG.log(System.Logger.Level.DEBUG, "Connections Freed event received for pool: {0}, count={1}.", this.poolInfo, count);
            RangeStatisticImpl rangeStatisticImpl = this.numConnFree;
            synchronized (rangeStatisticImpl) {
                this.numConnFree.setCurrent(count);
                LOG.log(System.Logger.Level.DEBUG, "Pool: {0}; used/free={1}/{2}, freed={3}", this.poolInfo, this.numConnUsed.getCurrent(), this.numConnFree.getCurrent(), count);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ProbeListener(value="glassfish:jca:connection-pool:connectionUsedEvent")
    public void connectionUsedEvent(@ProbeParam(value="poolName") String poolName, @ProbeParam(value="appName") String appName, @ProbeParam(value="moduleName") String moduleName) {
        if (this.isMyPool(poolName, appName, moduleName)) {
            LOG.log(System.Logger.Level.DEBUG, "Connection Used event received for pool: {0}", this.poolInfo);
            RangeStatisticImpl rangeStatisticImpl = this.numConnUsed;
            synchronized (rangeStatisticImpl) {
                this.numConnUsed.setCurrent(this.numConnUsed.getCurrent() + 1L);
            }
        }
    }

    @ProbeListener(value="glassfish:jca:connection-pool:connectionValidationFailedEvent")
    public void connectionValidationFailedEvent(@ProbeParam(value="poolName") String poolName, @ProbeParam(value="appName") String appName, @ProbeParam(value="moduleName") String moduleName, @ProbeParam(value="increment") int increment) {
        if (this.isMyPool(poolName, appName, moduleName)) {
            LOG.log(System.Logger.Level.DEBUG, "Connection Validation Failed event received for pool: {0}", this.poolInfo);
            this.numConnFailedValidation.increment(increment);
        }
    }

    @ProbeListener(value="glassfish:jca:connection-pool:connectionRequestServedEvent")
    public void connectionRequestServedEvent(@ProbeParam(value="poolName") String poolName, @ProbeParam(value="appName") String appName, @ProbeParam(value="moduleName") String moduleName, @ProbeParam(value="timeTakenInMillis") long timeTakenInMillis) {
        if (this.isMyPool(poolName, appName, moduleName)) {
            LOG.log(System.Logger.Level.DEBUG, "Connection request served event received for pool: {0}", this.poolInfo);
            this.connRequestWaitTime.setCurrent(timeTakenInMillis);
            this.totalConnRequestWaitTime.increment(timeTakenInMillis);
        }
    }

    @ProbeListener(value="glassfish:jca:connection-pool:connectionDestroyedEvent")
    public void connectionDestroyedEvent(@ProbeParam(value="poolName") String poolName, @ProbeParam(value="appName") String appName, @ProbeParam(value="moduleName") String moduleName) {
        if (this.isMyPool(poolName, appName, moduleName)) {
            LOG.log(System.Logger.Level.DEBUG, "Connection destroyed event received for pool: {0}", this.poolInfo);
            this.numConnDestroyed.increment();
        }
    }

    @ProbeListener(value="glassfish:jca:connection-pool:connectionAcquiredEvent")
    public void connectionAcquiredEvent(@ProbeParam(value="poolName") String poolName, @ProbeParam(value="appName") String appName, @ProbeParam(value="moduleName") String moduleName) {
        if (this.isMyPool(poolName, appName, moduleName)) {
            LOG.log(System.Logger.Level.DEBUG, "Connection acquired event received for pool: {0}", this.poolInfo);
            this.numConnAcquired.increment();
        }
    }

    @ProbeListener(value="glassfish:jca:connection-pool:connectionReleasedEvent")
    public void connectionReleasedEvent(@ProbeParam(value="poolName") String poolName, @ProbeParam(value="appName") String appName, @ProbeParam(value="moduleName") String moduleName) {
        if (this.isMyPool(poolName, appName, moduleName)) {
            LOG.log(System.Logger.Level.DEBUG, "Connection Released event received for pool: {0}", this.poolInfo);
            this.numConnReleased.increment();
        }
    }

    @ProbeListener(value="glassfish:jca:connection-pool:connectionCreatedEvent")
    public void connectionCreatedEvent(@ProbeParam(value="poolName") String poolName, @ProbeParam(value="appName") String appName, @ProbeParam(value="moduleName") String moduleName) {
        if (this.isMyPool(poolName, appName, moduleName)) {
            LOG.log(System.Logger.Level.DEBUG, "Connection Created event received for pool: {0}", this.poolInfo);
            this.numConnCreated.increment();
        }
    }

    @Reset
    public void reset() {
        LOG.log(System.Logger.Level.DEBUG, "Reset event received for pool: {0}", this.poolInfo);
        PoolStatus status = ConnectorRuntime.getRuntime().getPoolManager().getPoolStatus(this.poolInfo);
        this.numConnUsed.setCurrent(status.getNumConnUsed());
        this.numConnFree.setCurrent(status.getNumConnFree());
        this.numConnCreated.reset();
        this.numConnDestroyed.reset();
        this.numConnFailedValidation.reset();
        this.numConnTimedOut.reset();
        this.numConnAcquired.reset();
        this.numConnReleased.reset();
        this.connRequestWaitTime.reset();
        this.numConnSuccessfullyMatched.reset();
        this.numConnNotSuccessfullyMatched.reset();
        this.numPotentialConnLeak.reset();
        this.averageConnWaitTime.reset();
        this.totalConnRequestWaitTime.reset();
        this.waitQueueLength.reset();
    }

    @ProbeListener(value="glassfish:jca:connection-pool:connectionMatchedEvent")
    public void connectionMatchedEvent(@ProbeParam(value="poolName") String poolName, @ProbeParam(value="appName") String appName, @ProbeParam(value="moduleName") String moduleName) {
        if (this.isMyPool(poolName, appName, moduleName)) {
            LOG.log(System.Logger.Level.DEBUG, "Connection Matched event received for pool: {0}", this.poolInfo);
            this.numConnSuccessfullyMatched.increment();
        }
    }

    @ProbeListener(value="glassfish:jca:connection-pool:connectionNotMatchedEvent")
    public void connectionNotMatchedEvent(@ProbeParam(value="poolName") String poolName, @ProbeParam(value="appName") String appName, @ProbeParam(value="moduleName") String moduleName) {
        if (this.isMyPool(poolName, appName, moduleName)) {
            LOG.log(System.Logger.Level.DEBUG, "Connection Not Matched event received for pool: {0}", this.poolInfo);
            this.numConnNotSuccessfullyMatched.increment();
        }
    }

    @ProbeListener(value="glassfish:jca:connection-pool:connectionRequestQueuedEvent")
    public void connectionRequestQueuedEvent(@ProbeParam(value="poolName") String poolName, @ProbeParam(value="appName") String appName, @ProbeParam(value="moduleName") String moduleName) {
        if (this.isMyPool(poolName, appName, moduleName)) {
            LOG.log(System.Logger.Level.DEBUG, "Wait Queue Length Modified event received for pool: {0}", this.poolInfo);
            this.waitQueueLength.increment();
        }
    }

    @ProbeListener(value="glassfish:jca:connection-pool:connectionRequestDequeuedEvent")
    public void connectionRequestDequeuedEvent(@ProbeParam(value="poolName") String poolName, @ProbeParam(value="appName") String appName, @ProbeParam(value="moduleName") String moduleName) {
        if (this.isMyPool(poolName, appName, moduleName)) {
            LOG.log(System.Logger.Level.DEBUG, "Wait Queue Length Modified event received for pool: {0}", this.poolInfo);
            this.waitQueueLength.decrement();
        }
    }

    protected PoolInfo getPoolInfo() {
        return this.poolInfo;
    }

    protected void setPoolRegistry(PoolLifeCycleListenerRegistry registry) {
        this.poolRegistry = registry;
    }

    protected PoolLifeCycleListenerRegistry getPoolRegistry() {
        return this.poolRegistry;
    }

    @ManagedAttribute(id="numpotentialconnleak")
    public CountStatistic getNumPotentialConnLeakCount() {
        return this.numPotentialConnLeak;
    }

    @ManagedAttribute(id="numconnfailedvalidation")
    public CountStatistic getNumConnFailedValidation() {
        return this.numConnFailedValidation;
    }

    @ManagedAttribute(id="numconntimedout")
    public CountStatistic getNumConnTimedOut() {
        return this.numConnTimedOut;
    }

    @ManagedAttribute(id="numconnused")
    public RangeStatistic getNumConnUsed() {
        return this.numConnUsed;
    }

    @ManagedAttribute(id="numconnfree")
    public RangeStatistic getNumConnFree() {
        return this.numConnFree;
    }

    @ManagedAttribute(id="connrequestwaittime")
    public RangeStatistic getConnRequestWaitTime() {
        return this.connRequestWaitTime;
    }

    @ManagedAttribute(id="numconndestroyed")
    public CountStatistic getNumConnDestroyed() {
        return this.numConnDestroyed;
    }

    @ManagedAttribute(id="numconnacquired")
    public CountStatistic getNumConnAcquired() {
        return this.numConnAcquired;
    }

    @ManagedAttribute(id="numconncreated")
    public CountStatistic getNumConnCreated() {
        return this.numConnCreated;
    }

    @ManagedAttribute(id="numconnreleased")
    public CountStatistic getNumConnReleased() {
        return this.numConnReleased;
    }

    @ManagedAttribute(id="numconnsuccessfullymatched")
    public CountStatistic getNumConnSuccessfullyMatched() {
        return this.numConnSuccessfullyMatched;
    }

    @ManagedAttribute(id="numconnnotsuccessfullymatched")
    public CountStatistic getNumConnNotSuccessfullyMatched() {
        return this.numConnNotSuccessfullyMatched;
    }

    @ManagedAttribute(id="averageconnwaittime")
    public CountStatistic getAverageConnWaitTime() {
        long connAquired = this.numConnAcquired.getCount();
        long averageWaitTime = connAquired == 0L ? 0L : this.totalConnRequestWaitTime.getCount() / connAquired;
        this.averageConnWaitTime.setCount(averageWaitTime);
        return this.averageConnWaitTime;
    }

    @ManagedAttribute(id="waitqueuelength")
    public CountStatistic getWaitQueueLength() {
        return this.waitQueueLength;
    }

    private boolean isMyPool(String poolName, String appName, String moduleName) {
        PoolInfo other = new PoolInfo(SimpleJndiName.of(poolName), appName, moduleName);
        return this.poolInfo.equals(other);
    }
}

