/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool;

import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceState;
import com.sun.enterprise.transaction.api.JavaEETransaction;
import com.sun.logging.LogDomains;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.resourcebase.resources.api.PoolInfo;

public class PoolTxHelper {
    private PoolInfo poolInfo;
    protected static final Logger _logger = LogDomains.getLogger(PoolTxHelper.class, "jakarta.enterprise.resource.resourceadapter");

    public PoolTxHelper(PoolInfo poolInfo) {
        this.poolInfo = poolInfo;
    }

    public boolean isLocalResourceEligibleForReuse(ResourceHandle h) {
        boolean result = false;
        if (!this.isLocalResourceInTransaction(h)) {
            try {
                this.enforceDelistment(h);
            }
            catch (SystemException se) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Exception while delisting the local resource [ of pool : " + String.valueOf(this.poolInfo) + " ] forcibily from transaction", se);
                }
                return result;
            }
            h.getResourceState().setEnlisted(false);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Pool: isLocalResourceEligibleForReuse, eligible=true, enlisted changed to true for handle=" + String.valueOf(h));
            }
            result = true;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Pool: isLocalResourceEligibleForReuse, eligible=false, handle=" + String.valueOf(h));
        }
        return result;
    }

    private void enforceDelistment(ResourceHandle h) throws SystemException {
        Set set;
        JavaEETransaction txn = (JavaEETransaction)ConnectorRuntime.getRuntime().getTransaction();
        if (txn != null && (set = txn.getResources(this.poolInfo)) != null) {
            set.remove(h);
        }
    }

    public boolean isLocalTransactionInProgress() {
        boolean result;
        block3: {
            result = false;
            try {
                JavaEETransaction txn = (JavaEETransaction)ConnectorRuntime.getRuntime().getTransaction();
                if (txn != null) {
                    result = txn.isLocalTx();
                }
            }
            catch (SystemException e) {
                if (!_logger.isLoggable(Level.FINE)) break block3;
                _logger.log(Level.FINE, "Exception while checking whether a local transaction is in progress while using pool : " + String.valueOf(this.poolInfo), e);
            }
        }
        return result;
    }

    public boolean isLocalResourceInTransaction(ResourceHandle h) {
        boolean result;
        block3: {
            result = true;
            try {
                JavaEETransaction txn = (JavaEETransaction)ConnectorRuntime.getRuntime().getTransaction();
                if (txn != null) {
                    result = this.isNonXAResourceInTransaction(txn, h);
                }
            }
            catch (SystemException e) {
                if (!_logger.isLoggable(Level.FINE)) break block3;
                _logger.log(Level.FINE, "Exception while checking whether the resource [ of pool : " + String.valueOf(this.poolInfo) + " ] is nonxa and is enlisted in transaction : ", e);
            }
        }
        return result;
    }

    public boolean isNonXAResource(ResourceHandle resource) {
        return !resource.getResourceSpec().isXA();
    }

    private boolean isNonXAResourceInTransaction(JavaEETransaction tran, ResourceHandle resource) {
        return resource.equals(tran.getNonXAResource());
    }

    public boolean isNonXAResourceAndFree(JavaEETransaction tran, ResourceHandle resource) {
        return !resource.getResourceState().isBusy() && this.isNonXAResource(resource) && this.isNonXAResourceInTransaction(tran, resource);
    }

    public void resourceEnlisted(Transaction tran, ResourceHandle resource) {
        block5: {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Pool: resourceEnlisted START, tran=" + String.valueOf(tran) + ", resource=" + String.valueOf(resource) + ", poolInfo=" + String.valueOf(this.poolInfo));
            }
            try {
                JavaEETransaction j2eetran = (JavaEETransaction)tran;
                HashSet<ResourceHandle> set = j2eetran.getResources(this.poolInfo);
                if (set == null) {
                    set = new HashSet<ResourceHandle>();
                    j2eetran.setResources(set, this.poolInfo);
                }
                set.add(resource);
            }
            catch (ClassCastException e) {
                if (!_logger.isLoggable(Level.FINE)) break block5;
                _logger.log(Level.FINE, "Pool [ " + String.valueOf(this.poolInfo) + " ]: resourceEnlisted: transaction is not J2EETransaction but a " + tran.getClass().getName(), e);
            }
        }
        ResourceState state = resource.getResourceState();
        state.setEnlisted(true);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Pool: resourceEnlisted END, tran=" + String.valueOf(tran) + ", resource=" + String.valueOf(resource));
        }
    }

    public List<ResourceHandle> transactionCompleted(Transaction tran, int status, PoolInfo poolInfo) {
        JavaEETransaction j2eetran;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Pool: transactionCompleted START, tran= " + String.valueOf(tran) + ", poolInfo=" + String.valueOf(poolInfo));
        }
        ArrayList<ResourceHandle> delistedResources = new ArrayList<ResourceHandle>();
        try {
            j2eetran = (JavaEETransaction)tran;
        }
        catch (ClassCastException e) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Pool: transactionCompleted: transaction is not J2EETransaction but a " + tran.getClass().getName(), e);
            }
            return delistedResources;
        }
        Set set = j2eetran.getResources(poolInfo);
        if (set == null) {
            return delistedResources;
        }
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            ResourceHandle resource = (ResourceHandle)iter.next();
            ResourceState state = resource.getResourceState();
            state.setEnlisted(false);
            delistedResources.add(resource);
            iter.remove();
            if (!_logger.isLoggable(Level.FINE)) continue;
            _logger.log(Level.FINE, "Pool: transactionCompleted: " + String.valueOf(resource));
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Pool: transactionCompleted END, tran= " + String.valueOf(tran));
        }
        return delistedResources;
    }
}

