/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.listener;

import com.sun.enterprise.resource.listener.ConnectionEventListener;
import com.sun.logging.LogDomains;
import jakarta.resource.spi.ConnectionEvent;
import jakarta.resource.spi.ManagedConnection;
import java.util.logging.Logger;

public class UnpooledConnectionEventListener
extends ConnectionEventListener {
    private static Logger _logger = LogDomains.getLogger(UnpooledConnectionEventListener.class, "jakarta.enterprise.resource.resourceadapter");

    @Override
    public void connectionClosed(ConnectionEvent connectionEvent) {
        ManagedConnection managedConnection = (ManagedConnection)connectionEvent.getSource();
        try {
            managedConnection.destroy();
        }
        catch (Throwable re) {
            _logger.fine("error while destroying Unpooled Managed Connection");
        }
        _logger.fine("UnpooledConnectionEventListener: Connection closed");
    }

    @Override
    public void badConnectionClosed(ConnectionEvent connectionEvent) {
        ManagedConnection managedConnection = (ManagedConnection)connectionEvent.getSource();
        managedConnection.removeConnectionEventListener(this);
        this.connectionClosed(connectionEvent);
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent evt) {
    }

    @Override
    public void localTransactionStarted(ConnectionEvent evt) {
    }

    @Override
    public void localTransactionCommitted(ConnectionEvent evt) {
    }

    @Override
    public void localTransactionRolledback(ConnectionEvent evt) {
    }
}

