/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.listener;

import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.listener.ConnectionEventListener;
import com.sun.enterprise.resource.pool.PoolManager;
import jakarta.resource.spi.ConnectionEvent;
import jakarta.resource.spi.ManagedConnection;
import java.util.IdentityHashMap;
import java.util.Map;

public class LocalTxConnectionEventListener
extends ConnectionEventListener {
    private static final System.Logger LOG = System.getLogger(LocalTxConnectionEventListener.class.getName());
    private final PoolManager poolManager = ConnectorRuntime.getRuntime().getPoolManager();
    private final IdentityHashMap<Object, ResourceHandle> associatedHandles = new IdentityHashMap(10);
    private final ResourceHandle resource;

    public LocalTxConnectionEventListener(ResourceHandle resource) {
        this.resource = resource;
        LOG.log(System.Logger.Level.DEBUG, () -> "Created LocalTxConnectionEventListener for " + String.valueOf(resource) + ", this=" + String.valueOf(this));
    }

    @Override
    public synchronized void connectionClosed(ConnectionEvent evt) {
        if (LOG.isLoggable(System.Logger.Level.DEBUG)) {
            LOG.log(System.Logger.Level.DEBUG, () -> "connectionClosed START, resource=" + String.valueOf(this.resource) + ", this=" + String.valueOf(this));
            for (Map.Entry<Object, ResourceHandle> entry : this.associatedHandles.entrySet()) {
                LOG.log(System.Logger.Level.DEBUG, () -> "connectionClosed associatedHandles: key=" + String.valueOf(entry.getKey()) + ", handle=" + String.valueOf(entry.getValue()) + ", resource=" + String.valueOf(((ResourceHandle)entry.getValue()).getResource()));
            }
        }
        Object connectionHandle = evt.getConnectionHandle();
        ResourceHandle handle = this.associatedHandles.getOrDefault(connectionHandle, this.resource);
        this.poolManager.resourceClosed(handle);
        LOG.log(System.Logger.Level.DEBUG, () -> "connectionClosed END, resource=" + String.valueOf(this.resource) + ", handle=" + String.valueOf(handle) + ", this=" + String.valueOf(this));
    }

    @Override
    public synchronized void connectionErrorOccurred(ConnectionEvent evt) {
        this.resource.setConnectionErrorOccurred();
        ManagedConnection mc = (ManagedConnection)evt.getSource();
        mc.removeConnectionEventListener(this);
        this.poolManager.resourceErrorOccurred(this.resource);
    }

    @Override
    public synchronized void badConnectionClosed(ConnectionEvent evt) {
        Object connectionHandle = evt.getConnectionHandle();
        ResourceHandle handle = this.associatedHandles.getOrDefault(connectionHandle, this.resource);
        ManagedConnection mc = (ManagedConnection)evt.getSource();
        mc.removeConnectionEventListener(this);
        this.poolManager.badResourceClosed(handle);
    }

    @Override
    public void localTransactionStarted(ConnectionEvent evt) {
    }

    @Override
    public void localTransactionCommitted(ConnectionEvent evt) {
    }

    @Override
    public void localTransactionRolledback(ConnectionEvent evt) {
    }

    public synchronized void associateHandle(Object userHandle, ResourceHandle resourceHandle) {
        LOG.log(System.Logger.Level.DEBUG, () -> "associateHandle for userHandle=" + String.valueOf(userHandle) + ", resourceHandle=" + String.valueOf(resourceHandle) + ", this=" + String.valueOf(this));
        this.associatedHandles.put(userHandle, resourceHandle);
    }

    public synchronized ResourceHandle removeAssociation(Object userHandle) {
        LOG.log(System.Logger.Level.DEBUG, () -> "removeAssociation for userHandle=" + String.valueOf(userHandle) + ", this=" + String.valueOf(this));
        return this.associatedHandles.remove(userHandle);
    }

    public synchronized Map<Object, ResourceHandle> getAssociatedHandlesAndClearMap() {
        LOG.log(System.Logger.Level.DEBUG, () -> "getAssociatedHandlesAndClearMap, this=" + String.valueOf(this));
        IdentityHashMap result = (IdentityHashMap)this.associatedHandles.clone();
        this.associatedHandles.clear();
        return result;
    }
}

