/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.deployer;

import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.resource.deployer.AbstractConnectorResourceDeployer;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.connectors.config.ResourceAdapterConfig;
import org.glassfish.resourcebase.resources.api.ResourceDeployerInfo;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
@ResourceDeployerInfo(value=ResourceAdapterConfig.class)
public class ResourceAdapterConfigDeployer
extends AbstractConnectorResourceDeployer<ResourceAdapterConfig> {
    private static final Logger LOG = LogDomains.getLogger(ResourceAdapterConfigDeployer.class, "jakarta.enterprise.resource.resourceadapter");
    @Inject
    private Provider<ConnectorRuntime> connectorRuntimeProvider;

    @Override
    public synchronized void deployResource(ResourceAdapterConfig resource, String applicationName, String moduleName) throws Exception {
        this.deployResource(resource);
    }

    @Override
    public synchronized void deployResource(ResourceAdapterConfig resource) throws Exception {
        String rarName = resource.getResourceAdapterName();
        ConnectorRuntime crt = this.getConnectorRuntime();
        LOG.log(Level.FINE, "Calling backend to add resource adapterConfig ", rarName);
        crt.addResourceAdapterConfig(rarName, resource);
        LOG.log(Level.FINE, "Added resource adapterConfig in backend", rarName);
    }

    private ConnectorRuntime getConnectorRuntime() {
        return this.connectorRuntimeProvider.get();
    }

    @Override
    public void undeployResource(ResourceAdapterConfig resource, String applicationName, String moduleName) throws Exception {
        this.undeployResource(resource);
    }

    @Override
    public synchronized void undeployResource(ResourceAdapterConfig resource) throws Exception {
        ResourceAdapterConfig domainConfig = resource;
        String rarName = domainConfig.getResourceAdapterName();
        ConnectorRuntime crt = this.getConnectorRuntime();
        crt.deleteResourceAdapterConfig(rarName);
    }

    @Override
    public boolean handles(Object resource) {
        return resource instanceof ResourceAdapterConfig;
    }

    @Override
    public synchronized void disableResource(ResourceAdapterConfig resource) throws Exception {
    }

    @Override
    public synchronized void enableResource(ResourceAdapterConfig resource) throws Exception {
    }
}

