/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.allocator;

import com.sun.appserv.connectors.internal.api.ConnectorConstants;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.PoolingException;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.resource.AssocWithThreadResourceHandle;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.resource.allocator.ResourceAllocator;
import com.sun.enterprise.resource.pool.PoolManager;
import com.sun.logging.LogDomains;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConnectionRequestInfo;
import jakarta.resource.spi.ManagedConnection;
import jakarta.resource.spi.ManagedConnectionFactory;
import jakarta.resource.spi.ValidatingManagedConnectionFactory;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;

public abstract class AbstractConnectorAllocator
implements ResourceAllocator {
    protected static final Logger LOG = LogDomains.getLogger(AbstractConnectorAllocator.class, "jakarta.enterprise.resource.resourceadapter");
    protected PoolManager poolMgr;
    protected ResourceSpec spec;
    protected ConnectionRequestInfo reqInfo;
    protected Subject subject;
    protected ManagedConnectionFactory mcf;
    protected ConnectorDescriptor desc;
    protected ClientSecurityInfo info;

    public AbstractConnectorAllocator() {
    }

    public AbstractConnectorAllocator(PoolManager poolMgr, ManagedConnectionFactory mcf, ResourceSpec spec, Subject subject, ConnectionRequestInfo reqInfo, ClientSecurityInfo info, ConnectorDescriptor desc) {
        this.poolMgr = poolMgr;
        this.mcf = mcf;
        this.spec = spec;
        this.subject = subject;
        this.reqInfo = reqInfo;
        this.info = info;
        this.desc = desc;
    }

    public Set getInvalidConnections(Set connectionSet) throws ResourceException {
        if (this.mcf instanceof ValidatingManagedConnectionFactory) {
            return ((ValidatingManagedConnectionFactory)((Object)this.mcf)).getInvalidConnections(connectionSet);
        }
        return null;
    }

    @Override
    public boolean isConnectionValid(ResourceHandle h) {
        HashSet<ManagedConnection> conn = new HashSet<ManagedConnection>();
        conn.add(h.getResource());
        Set invalids = null;
        try {
            invalids = this.getInvalidConnections(conn);
        }
        catch (ResourceException re) {
            Object[] args = new Object[]{h.getResourceSpec().getPoolInfo(), re.getClass(), re.getMessage()};
            LOG.log(Level.WARNING, "pool.get_invalid_connections_resourceexception", args);
            LOG.log(Level.FINE, "Failed to check if the connection is valid.", re);
        }
        return (invalids == null || invalids.isEmpty()) && !h.hasConnectionErrorOccurred();
    }

    @Override
    public void destroyResource(ResourceHandle resourceHandle) throws PoolingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void fillInResourceObjects(ResourceHandle resourceHandle) throws PoolingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public void cleanup(ResourceHandle h) throws PoolingException {
        try {
            ManagedConnection mc = h.getResource();
            mc.cleanup();
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "managed_con.cleanup-failed", ex);
            throw new PoolingException(ex.toString(), ex);
        }
    }

    @Override
    public boolean matchConnection(ResourceHandle h) {
        HashSet<ManagedConnection> set = new HashSet<ManagedConnection>();
        set.add(h.getResource());
        try {
            ManagedConnection mc = this.mcf.matchManagedConnections(set, this.subject, this.reqInfo);
            return mc != null;
        }
        catch (ResourceException ex) {
            return false;
        }
    }

    @Override
    public void closeUserConnection(ResourceHandle resource) throws PoolingException {
        try {
            ManagedConnection mc = resource.getResource();
            mc.cleanup();
        }
        catch (ResourceException ex) {
            throw new PoolingException(ex);
        }
    }

    @Override
    public boolean shareableWithinComponent() {
        return false;
    }

    @Override
    public Object getSharedConnection(ResourceHandle h) throws PoolingException {
        throw new UnsupportedOperationException();
    }

    protected ResourceHandle createResourceHandle(ManagedConnection resource, ResourceSpec spec, ResourceAllocator alloc) {
        ConnectorConstants.PoolType pt = ConnectorConstants.PoolType.STANDARD_POOL;
        try {
            pt = ConnectorRuntime.getRuntime().getPoolType(spec.getPoolInfo());
        }
        catch (ConnectorRuntimeException cre) {
            LOG.log(Level.WARNING, "unable_to_determine_pool_type", spec.getPoolInfo());
        }
        if (pt == ConnectorConstants.PoolType.ASSOCIATE_WITH_THREAD_POOL) {
            return new AssocWithThreadResourceHandle(resource, spec, alloc);
        }
        return new ResourceHandle(resource, spec, alloc);
    }

    @Override
    public boolean hasValidatingMCF() {
        return this.mcf instanceof ValidatingManagedConnectionFactory;
    }
}

