/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming.util;

import com.sun.enterprise.naming.spi.NamingObjectFactory;
import java.util.concurrent.atomic.AtomicReference;
import javax.naming.Context;
import javax.naming.NamingException;
import org.glassfish.api.naming.SimpleJndiName;
import org.jvnet.hk2.annotations.Service;

@Service
public class JndiNamingObjectFactory
implements NamingObjectFactory {
    private static final System.Logger LOG = System.getLogger(JndiNamingObjectFactory.class.getName());
    private final SimpleJndiName name;
    private final SimpleJndiName jndiName;
    private final AtomicReference<Object> value;
    private final boolean cacheResult;

    public JndiNamingObjectFactory(SimpleJndiName name, SimpleJndiName jndiName, boolean cacheResult) {
        this.name = name;
        this.jndiName = jndiName;
        this.cacheResult = cacheResult;
        this.value = new AtomicReference();
    }

    @Override
    public boolean isCreateResultCacheable() {
        return this.cacheResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T create(Context ic) throws NamingException {
        LOG.log(System.Logger.Level.TRACE, "create(ic={0}); jndiName={1}, cacheResult={2}", ic, this.jndiName, this.cacheResult);
        Object result = null;
        try {
            ic.addToEnvironment("com.sun.enterprise.naming.logicalName", this.name);
            if (this.cacheResult) {
                result = this.value.get();
                if (result == null) {
                    Object tempResult = ic.lookup(this.jndiName.toString());
                    result = this.value.compareAndSet(null, tempResult) ? tempResult : this.value.get();
                }
            } else {
                result = ic.lookup(this.jndiName.toString());
            }
        }
        finally {
            ic.removeFromEnvironment("com.sun.enterprise.naming.logicalName");
        }
        return (T)result;
    }
}

