/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap.cp;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.main.jdke.cl.GlassfishUrlClassLoader;

final class ClassPathBuilder {
    private final List<File> files = new ArrayList<File>();

    ClassPathBuilder() {
    }

    ClassPathBuilder addJar(File jar) throws IOException {
        if (!jar.exists()) {
            throw new IOException("No such file: " + String.valueOf(jar));
        }
        this.files.add(jar);
        return this;
    }

    ClassPathBuilder addJarFolder(File folder, String ... excludes) throws IOException {
        if (!folder.isDirectory()) {
            throw new IOException("Not a directory " + String.valueOf(folder));
        }
        FileFilter filter = pathname -> {
            for (String name : excludes) {
                if (!pathname.getName().equals(name)) continue;
                return false;
            }
            return pathname.getPath().endsWith(".jar");
        };
        File[] children = folder.listFiles(filter);
        if (children == null) {
            return this;
        }
        for (File child : children) {
            this.addJar(child);
        }
        return this;
    }

    ClassLoader build(ClassLoader parent) {
        PrivilegedAction<GlassfishUrlClassLoader> action = () -> {
            URL[] urls = (URL[])this.files.stream().map(ClassPathBuilder::toURL).toArray(URL[]::new);
            return new GlassfishUrlClassLoader("OSGi", urls, parent);
        };
        return AccessController.doPrivileged(action);
    }

    private static URL toURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("File cannot be converted to URL: " + file.getAbsolutePath(), e);
        }
    }
}

