/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.util;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.InjectionCapable;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.ManagedBeanDescriptor;
import com.sun.enterprise.deployment.MessageDestinationDescriptor;
import com.sun.enterprise.deployment.MessageDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceEnvReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.deployment.types.MessageDestinationReferencer;
import com.sun.enterprise.deployment.util.ComponentVisitor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.DefaultDOLVisitor;
import com.sun.enterprise.deployment.util.TypeUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Utility;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.logging.annotation.LogMessageInfo;

public class ComponentValidator
extends DefaultDOLVisitor
implements ComponentVisitor {
    private static final Logger LOG = DOLUtils.deplLogger;
    @LogMessageInfo(message="Could not load {0}", level="FINE")
    private static final String LOAD_ERROR = "AS-DEPLOYMENT-00014";
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ComponentValidator.class);
    protected BundleDescriptor bundleDescriptor;
    protected Application application;

    @Override
    public void accept(BundleDescriptor bundleDescriptor) {
        this.bundleDescriptor = bundleDescriptor;
        super.accept(bundleDescriptor);
    }

    @Override
    protected void accept(MessageDestinationReferencer msgDestReferencer) {
        if (msgDestReferencer.isLinkedToMessageDestination()) {
            return;
        }
        if (msgDestReferencer.ownedByMessageDestinationRef() && msgDestReferencer.getMessageDestinationRefOwner().getJndiName() != null) {
            return;
        }
        MessageDestinationDescriptor msgDest = msgDestReferencer.resolveLinkName();
        if (msgDest == null) {
            String linkName = msgDestReferencer.getMessageDestinationLinkName();
            LOG.log(Level.WARNING, "AS-DEPLOYMENT-00015", new Object[]{"message-destination", linkName, msgDestReferencer.getClass()});
        } else if (msgDestReferencer instanceof MessageDestinationReferenceDescriptor) {
            ((MessageDestinationReferenceDescriptor)msgDestReferencer).setJndiName(msgDest.getJndiName());
        }
    }

    protected Application getApplication() {
        return this.application;
    }

    protected BundleDescriptor getBundleDescriptor() {
        return this.bundleDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void accept(EjbReference ejbRef) {
        Map<String, EjbIntfInfo> ejbIntfInfoMap;
        LOG.log(Level.FINE, "Visiting Ref {0}", ejbRef);
        if (ejbRef.getEjbDescriptor() != null) {
            return;
        }
        if (ejbRef.getType() == null) {
            if (ejbRef.isEJB30ClientView()) {
                ejbRef.setType("Session");
            } else {
                void var3_5;
                String homeIntf = ejbRef.getEjbHomeInterface();
                BundleDescriptor bundleDescriptor = ejbRef.getReferringBundleDescriptor();
                if (bundleDescriptor == null) {
                    BundleDescriptor bundleDescriptor2 = this.getBundleDescriptor();
                }
                ClassLoader classLoader = var3_5.getClassLoader();
                Class<?> clazz = null;
                try {
                    clazz = classLoader.loadClass(homeIntf);
                    for (Method method : clazz.getDeclaredMethods()) {
                        if (!method.getName().equals("findByPrimaryKey")) continue;
                        ejbRef.setType("Entity");
                        break;
                    }
                    if (ejbRef.getType() == null) {
                        ejbRef.setType("Session");
                    }
                }
                catch (Exception e) {
                    LogRecord lr = new LogRecord(Level.FINE, LOAD_ERROR);
                    Object[] args = new Object[]{homeIntf};
                    lr.setParameters(args);
                    lr.setThrown(e);
                    LOG.log(lr);
                }
            }
        }
        if (!(ejbRef.getJndiName() == null || ejbRef.getJndiName().isEmpty() || ejbRef.isLocal() && ejbRef.getLinkName() != null)) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Ref " + ejbRef.getName() + " is bound to Ejb with JNDI Name " + String.valueOf(ejbRef.getJndiName()));
            }
            if (this.getEjbDescriptors() != null) {
                for (EjbDescriptor ejbDescriptor : this.getEjbDescriptors()) {
                    if (!ejbRef.getJndiName().equals(ejbDescriptor.getJndiName())) continue;
                    ejbRef.setEjbDescriptor(ejbDescriptor);
                    return;
                }
            }
        }
        if (!(ejbRef.getJndiName() != null && !ejbRef.getJndiName().isEmpty() || ejbRef.getLinkName() != null && !ejbRef.getLinkName().isEmpty() || ejbRef.hasLookupName() || (ejbIntfInfoMap = this.getEjbIntfMap()).isEmpty())) {
            String string;
            String string2 = string = ejbRef.isEJB30ClientView() ? ejbRef.getEjbInterface() : ejbRef.getEjbHomeInterface();
            if (string == null) {
                String msg = localStrings.getLocalString("enterprise.deployment.util.no_remoteinterface", "Cannot resolve reference {0} because it does not declare a remote interface or remote home interface of target bean", ejbRef);
                throw new IllegalArgumentException(msg);
            }
            EjbIntfInfo intfInfo = ejbIntfInfoMap.get(string);
            if (intfInfo != null) {
                int numMatches = intfInfo.ejbs.size();
                if (numMatches == 1) {
                    EjbDescriptor target = intfInfo.ejbs.iterator().next();
                    EjbBundleDescriptor targetModule = target.getEjbBundleDescriptor();
                    BundleDescriptor sourceModule = ejbRef.getReferringBundleDescriptor();
                    Application app = targetModule.getApplication();
                    Object ejbLinkName = target.getName();
                    if (!sourceModule.isPackagedAsSingleModule(targetModule)) {
                        String relativeUri = null;
                        relativeUri = sourceModule == app ? targetModule.getModuleDescriptor().getArchiveUri() : this.getApplication().getRelativeUri(sourceModule, targetModule);
                        ejbLinkName = relativeUri + "#" + (String)ejbLinkName;
                    }
                    ejbRef.setLinkName((String)ejbLinkName);
                } else {
                    String msg = localStrings.getLocalString("enterprise.deployment.util.multiple_ejbs_with_interface", "Cannot resolve reference {0} because there are {1} ejbs in the application with interface {2}.", ejbRef, numMatches, string);
                    throw new IllegalArgumentException(msg);
                }
            }
        }
        if (ejbRef.getLinkName() == null) {
            if (ejbRef.isLocal()) {
                if (ejbRef.hasLookupName()) {
                    return;
                }
                throw new RuntimeException("Cannot resolve reference " + String.valueOf(ejbRef));
            }
            if (!ejbRef.hasJndiName() && !ejbRef.hasLookupName()) {
                SimpleJndiName jndiName = SimpleJndiName.of(ejbRef.isEJB30ClientView() ? ejbRef.getEjbInterface() : ejbRef.getEjbHomeInterface());
                ejbRef.setJndiName(jndiName);
                LOG.log(Level.FINE, "Applying default to ejb reference: {0}", ejbRef);
            }
            return;
        }
        String homeClassName = ejbRef.getEjbHomeInterface();
        String string = ejbRef.getEjbInterface();
        String type2 = ejbRef.getType();
        EjbDescriptor ejbReferee = null;
        String linkName = ejbRef.getLinkName();
        int ind = linkName.lastIndexOf(35);
        if (ind == -1) {
            Application app = this.getApplication();
            EjbBundleDescriptor ebd = this.getEjbBundleDescriptor();
            if (app != null && ebd != null && ebd.hasEjbByName(linkName)) {
                ejbReferee = ebd.getEjbByName(linkName);
            } else if (app != null && app.hasEjbByName(linkName)) {
                ejbReferee = app.getEjbByName(ejbRef.getLinkName());
            } else if (app != null && linkName.matches("^[^/#]+/[^/#]+$")) {
                String ejbName;
                String[] ejbLinkParts = linkName.split("/");
                String moduleName = ejbLinkParts[0];
                if (app.hasEjbByName(moduleName, ejbName = ejbLinkParts[1])) {
                    ejbReferee = app.getEjbByName(moduleName, ejbName);
                }
            } else if (this.getEjbDescriptor() != null) {
                try {
                    ejbReferee = this.getEjbDescriptor().getEjbBundleDescriptor().getEjbByName(ejbRef.getLinkName());
                }
                catch (IllegalArgumentException e) {
                    LOG.warning("Unresolved <ejb-link>: " + linkName);
                    return;
                }
            }
        } else {
            String ejbName = linkName.substring(ind + 1);
            String jarPath = linkName.substring(0, ind);
            BundleDescriptor referringJar = ejbRef.getReferringBundleDescriptor();
            if (referringJar == null) {
                ejbRef.setReferringBundleDescriptor(this.getBundleDescriptor());
                referringJar = this.getBundleDescriptor();
            }
            if (this.getApplication() != null) {
                BundleDescriptor refereeJar = null;
                refereeJar = referringJar instanceof Application ? ((Application)referringJar).getModuleByUri(jarPath) : this.getApplication().getRelativeBundle(referringJar, jarPath);
                if (refereeJar != null && refereeJar instanceof EjbBundleDescriptor) {
                    ejbReferee = ((EjbBundleDescriptor)refereeJar).getEjbByName(ejbName);
                }
            }
        }
        if (ejbReferee == null) {
            if (ejbRef.isLocal()) {
                LOG.severe("Unresolved <ejb-link>: " + linkName);
                throw new RuntimeException("Error: Unresolved <ejb-link>: " + linkName);
            }
            ArchiveType moduleType = ejbRef.getReferringBundleDescriptor().getModuleType();
            if (moduleType != null && moduleType.equals(DOLUtils.carType())) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Unresolved <ejb-link>: " + linkName);
                }
            } else {
                LOG.warning("Unresolved <ejb-link>: " + linkName);
            }
            return;
        }
        if (ejbRef.isEJB30ClientView()) {
            BundleDescriptor referringBundle = ejbRef.getReferringBundleDescriptor();
            if (referringBundle == null && this.getEjbBundleDescriptor() == null || referringBundle != null && Objects.equals(DOLUtils.carType(), referringBundle.getModuleType()) || referringBundle != null && Objects.equals(DOLUtils.warType(), referringBundle.getModuleType()) && this.getApplication() == null && referringBundle.getModuleType() != null) {
                ejbRef.setLocal(false);
                if (!ejbReferee.getRemoteBusinessClassNames().contains(string)) {
                    msg = "Target ejb " + ejbReferee.getName() + " for remote ejb 3.0 reference " + ejbRef.getName() + " does not expose a remote business interface of type " + string;
                    throw new RuntimeException(msg);
                }
            } else if (ejbReferee.getLocalBusinessClassNames().contains(string)) {
                ejbRef.setLocal(true);
            } else if (ejbReferee.getRemoteBusinessClassNames().contains(string)) {
                ejbRef.setLocal(false);
            } else if (ejbReferee.isLocalBean()) {
                ejbRef.setLocal(true);
            } else {
                msg = "Warning : Unable to determine local business vs. remote business designation for EJB 3.0 ref " + String.valueOf(ejbRef);
                throw new RuntimeException(msg);
            }
        }
        ejbRef.setEjbDescriptor(ejbReferee);
        if (LOG.isLoggable(Level.FINE) && this.getEjbDescriptor() != null) {
            LOG.fine("Done Visiting " + this.getEjbDescriptor().getName() + " reference " + String.valueOf(ejbRef));
        }
        if (ejbRef.isEJB30ClientView()) {
            Set<String> targetBusinessIntfs = ejbRef.isLocal() ? ejbReferee.getLocalBusinessClassNames() : ejbReferee.getRemoteBusinessClassNames();
            EjbDescriptor ejbDesc = ejbRef.getEjbDescriptor();
            if (!targetBusinessIntfs.contains(string) && ejbDesc.isLocalBean() && !string.equals(ejbReferee.getEjbClassName())) {
                LOG.log(Level.WARNING, "enterprise.deployment.backend.ejbRefTypeMismatch", new Object[]{ejbRef.getName(), string, ejbReferee.getName(), ejbRef.isLocal() ? "Local Business" : "Remote Business", targetBusinessIntfs.toString()});
                if (targetBusinessIntfs.size() == 1) {
                    Iterator<String> iter = targetBusinessIntfs.iterator();
                    ejbRef.setEjbInterface(iter.next());
                }
            }
        } else {
            String targetComponentIntf;
            String targetHome;
            String string3 = targetHome = ejbRef.isLocal() ? ejbReferee.getLocalHomeClassName() : ejbReferee.getHomeClassName();
            if (!homeClassName.equals(targetHome)) {
                LOG.log(Level.WARNING, "enterprise.deployment.backend.ejbRefTypeMismatch", new Object[]{ejbRef.getName(), homeClassName, ejbReferee.getName(), ejbRef.isLocal() ? "Local Home" : "Remote Home", targetHome});
                if (targetHome != null) {
                    ejbRef.setEjbHomeInterface(targetHome);
                }
            }
            String string4 = targetComponentIntf = ejbRef.isLocal() ? ejbReferee.getLocalClassName() : ejbReferee.getRemoteClassName();
            if (string != null && !string.equals(targetComponentIntf)) {
                LOG.log(Level.WARNING, "enterprise.deployment.backend.ejbRefTypeMismatch", new Object[]{ejbRef.getName(), string, ejbReferee.getName(), ejbRef.isLocal() ? "Local" : "Remote", targetComponentIntf});
                if (targetComponentIntf != null) {
                    ejbRef.setEjbInterface(targetComponentIntf);
                }
            }
        }
        ejbRef.setJndiName(ejbReferee.getJndiName());
        if (!type2.equals(ejbRef.getType())) {
            LOG.log(Level.WARNING, "Detected type {0} doesn't match the configured type {1} for ejb reference {2}", new Object[]{ejbRef.getName(), type2, ejbRef.getClass()});
            ejbRef.setType(ejbRef.getType());
        }
    }

    protected Collection<? extends EjbDescriptor> getEjbDescriptors() {
        if (this.getApplication() != null) {
            return this.getApplication().getEjbDescriptors();
        }
        if (this.getEjbBundleDescriptor() != null) {
            return this.getEjbBundleDescriptor().getEjbs();
        }
        return new HashSet();
    }

    protected EjbDescriptor getEjbDescriptor() {
        return null;
    }

    protected EjbBundleDescriptor getEjbBundleDescriptor() {
        return null;
    }

    private Map<String, EjbIntfInfo> getEjbIntfMap() {
        HashMap<String, EjbIntfInfo> intfInfoMap = new HashMap<String, EjbIntfInfo>();
        for (EjbDescriptor ejbDescriptor : this.getEjbDescriptors()) {
            EjbDescriptor next = ejbDescriptor;
            if (next.isRemoteInterfacesSupported()) {
                this.addIntfInfo(intfInfoMap, next.getHomeClassName(), EjbIntfType.REMOTE_HOME, next);
            }
            if (next.isRemoteBusinessInterfacesSupported()) {
                for (String nextIntf : next.getRemoteBusinessClassNames()) {
                    this.addIntfInfo(intfInfoMap, nextIntf, EjbIntfType.REMOTE_BUSINESS, next);
                }
            }
            if (next.isLocalInterfacesSupported()) {
                this.addIntfInfo(intfInfoMap, next.getLocalHomeClassName(), EjbIntfType.LOCAL_HOME, next);
            }
            if (next.isLocalBusinessInterfacesSupported()) {
                for (String nextIntf : next.getLocalBusinessClassNames()) {
                    this.addIntfInfo(intfInfoMap, nextIntf, EjbIntfType.LOCAL_BUSINESS, next);
                }
            }
            if (!next.isLocalBean()) continue;
            this.addIntfInfo(intfInfoMap, next.getEjbClassName(), EjbIntfType.NO_INTF_LOCAL_BUSINESS, next);
        }
        return intfInfoMap;
    }

    private void addIntfInfo(Map<String, EjbIntfInfo> intfInfoMap, String intf, EjbIntfType intfType, EjbDescriptor ejbDesc) {
        EjbIntfInfo intfInfo = intfInfoMap.get(intf);
        if (intfInfo == null) {
            EjbIntfInfo newInfo = new EjbIntfInfo();
            newInfo.ejbs = new HashSet<EjbDescriptor>();
            newInfo.ejbs.add(ejbDesc);
            intfInfoMap.put(intf, newInfo);
        } else {
            intfInfo.ejbs.add(ejbDesc);
        }
    }

    @Override
    protected void accept(ServiceReferenceDescriptor serviceRef) {
        Set<ServiceRefPortInfo> portsInfo = serviceRef.getPortsInfo();
        for (ServiceRefPortInfo next : portsInfo) {
            WebServiceEndpoint portComponentLink;
            if (!next.hasPortComponentLinkName() || next.isLinkedToPortComponent() || (portComponentLink = next.resolveLinkName()) != null) continue;
            String linkName = next.getPortComponentLinkName();
            LOG.log(Level.WARNING, "AS-DEPLOYMENT-00015", new Object[]{"port-component", linkName, next.getClass()});
        }
    }

    @Override
    protected void accept(ResourceReferenceDescriptor resRef) {
        this.computeRuntimeDefault(resRef);
    }

    @Override
    protected void accept(ResourceEnvReferenceDescriptor resourceEnvRef) {
        String refType;
        Map<String, ManagedBeanDescriptor> managedBeanMap;
        if ((resourceEnvRef.getJndiName() == null || resourceEnvRef.getJndiName().isEmpty()) && (managedBeanMap = this.getManagedBeanMap()).containsKey(refType = resourceEnvRef.getRefType())) {
            ManagedBeanDescriptor desc = managedBeanMap.get(refType);
            SimpleJndiName jndiName = Objects.equals(this.bundleDescriptor.getModuleType(), DOLUtils.carType()) ? desc.getAppJndiName() : desc.getGlobalJndiName();
            resourceEnvRef.setJndiName(jndiName);
            resourceEnvRef.setIsManagedBean(true);
            resourceEnvRef.setManagedBeanDescriptor(desc);
        }
        this.computeRuntimeDefault(resourceEnvRef);
    }

    protected void accept(MessageDestinationReferenceDescriptor msgDestRef) {
        this.computeRuntimeDefault(msgDestRef);
    }

    @Override
    protected void accept(MessageDestinationDescriptor msgDest) {
        this.computeRuntimeDefault(msgDest);
    }

    protected void accept(InjectionCapable injectable) {
        this.acceptWithCL(injectable);
        this.acceptWithoutCL(injectable);
    }

    protected void acceptWithCL(InjectionCapable injectable) {
        for (InjectionTarget target : injectable.getInjectionTargets()) {
            if (target.getFieldName() != null || target.getMethodName() != null) continue;
            String injectTargetName = target.getTargetName();
            String targetClassName = target.getClassName();
            ClassLoader classLoader = this.getBundleDescriptor().getClassLoader();
            Class<?> targetClazz = null;
            try {
                targetClazz = classLoader.loadClass(targetClassName);
            }
            catch (ClassNotFoundException cnfe) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Injection class " + targetClassName + " not found for " + String.valueOf(injectable));
                }
                return;
            }
            boolean matched = false;
            String setterMethodName = TypeUtil.propertyNameToSetterMethod(injectTargetName);
            for (Method next : targetClazz.getDeclaredMethods()) {
                Class<?>[] paramTypes;
                if (!next.getName().equals(setterMethodName) || next.getParameterTypes().length != 1) continue;
                target.setMethodName(next.getName());
                if (injectable.getInjectResourceType() == null && (paramTypes = next.getParameterTypes()).length == 1) {
                    String resourceType = paramTypes[0].getName();
                    injectable.setInjectResourceType(resourceType);
                }
                matched = true;
                break;
            }
            if (matched) continue;
            try {
                Field field = targetClazz.getDeclaredField(injectTargetName);
                target.setFieldName(injectTargetName);
                if (injectable.getInjectResourceType() == null) {
                    String resourceType = field.getType().getName();
                    injectable.setInjectResourceType(resourceType);
                }
                matched = true;
            }
            catch (NoSuchFieldException nsfe) {
                String msg = "No matching injection setter method or injection field found for injection property " + injectTargetName + " on class " + targetClassName + " for component dependency " + String.valueOf(injectable);
                throw new RuntimeException(msg, nsfe);
            }
        }
    }

    protected void acceptWithoutCL(InjectionCapable injectable) {
    }

    protected void computeRunAsPrincipalDefault(RunAsIdentityDescriptor runAs, Application application) {
        if (runAs != null && Utility.isEmpty(runAs.getRoleName())) {
            LOG.log(Level.WARNING, "enterprise.deployment.backend.emptyRoleName");
            return;
        }
        if (runAs != null && Utility.isEmpty(runAs.getPrincipal()) && application != null && application.getRoleMapper() != null) {
            Set<Principal> principals;
            String principalName = null;
            String roleName = runAs.getRoleName();
            Subject subject = application.getRoleMapper().getRoleToSubjectMapping().get(roleName);
            if (subject != null && !(principals = subject.getPrincipals()).isEmpty()) {
                principalName = principals.iterator().next().getName();
                LOG.log(Level.WARNING, "The run-as principal {0} was assigned by the deployment system based on the specified role. Please consider defining an explicit run-as principal in the sun-specific deployment descriptor.", principalName);
            }
            if (Utility.isEmpty(principalName)) {
                throw new RuntimeException("The RunAs role \"" + roleName + "\" is not mapped to a principal.");
            }
            runAs.setPrincipal(principalName);
        }
    }

    private Map<String, ManagedBeanDescriptor> getManagedBeanMap() {
        Object desc;
        BundleDescriptor thisBundle = this.getBundleDescriptor();
        Set<Object> managedBeans = new HashSet();
        if (thisBundle != null && (desc = thisBundle.getModuleDescriptor().getDescriptor()) instanceof BundleDescriptor) {
            managedBeans = ((BundleDescriptor)desc).getManagedBeans();
        }
        HashMap<String, ManagedBeanDescriptor> managedBeanMap = new HashMap<String, ManagedBeanDescriptor>();
        for (ManagedBeanDescriptor managedBean : managedBeans) {
            String beanClassName = managedBean.getBeanClassName();
            managedBeanMap.put(beanClassName, managedBean);
        }
        return managedBeanMap;
    }

    private void computeRuntimeDefault(ResourceReferenceDescriptor resRef) {
        if (resRef.getType() != null && resRef.getType().equals("org.omg.CORBA.ORB")) {
            resRef.setJndiName(new SimpleJndiName("java:comp/ORB"));
        } else if (resRef.getJndiName() == null || resRef.getJndiName().isEmpty()) {
            if (resRef.getType() != null) {
                if (resRef.getType().equals("javax.sql.DataSource")) {
                    resRef.setLookupName(new SimpleJndiName("java:comp/DefaultDataSource"));
                } else if (resRef.getType().equals("jakarta.jms.ConnectionFactory")) {
                    resRef.setLookupName(new SimpleJndiName("java:comp/DefaultJMSConnectionFactory"));
                } else {
                    resRef.setJndiName(this.getDefaultResourceJndiName(resRef.getName()));
                }
            } else {
                resRef.setJndiName(this.getDefaultResourceJndiName(resRef.getName()));
            }
        }
    }

    private void computeRuntimeDefault(ResourceEnvReferenceDescriptor resourceEnvRef) {
        String refType = resourceEnvRef.getRefType();
        if (refType != null && refType.equals("jakarta.transaction.UserTransaction")) {
            resourceEnvRef.setJndiName(new SimpleJndiName("java:comp/UserTransaction"));
            return;
        }
        if (refType != null && refType.equals("jakarta.transaction.TransactionSynchronizationRegistry")) {
            String jndiName = "java:comp/TransactionSynchronizationRegistry";
            resourceEnvRef.setJndiName(new SimpleJndiName(jndiName));
            return;
        }
        if (resourceEnvRef.getJndiName() != null && !resourceEnvRef.getJndiName().isEmpty()) {
            return;
        }
        if (refType == null) {
            resourceEnvRef.setJndiName(this.getDefaultResourceJndiName(resourceEnvRef.getName()));
            return;
        }
        if (refType.equals("jakarta.enterprise.concurrent.ManagedExecutorService")) {
            resourceEnvRef.setLookupName(new SimpleJndiName("java:comp/DefaultManagedExecutorService"));
        } else if (refType.equals("jakarta.enterprise.concurrent.ManagedScheduledExecutorService")) {
            String jndiName = "java:comp/DefaultManagedScheduledExecutorService";
            resourceEnvRef.setLookupName(new SimpleJndiName(jndiName));
        } else if (refType.equals("jakarta.enterprise.concurrent.ManagedThreadFactory")) {
            resourceEnvRef.setLookupName(new SimpleJndiName("java:comp/DefaultManagedThreadFactory"));
        } else if (refType.equals("jakarta.enterprise.concurrent.ContextService")) {
            resourceEnvRef.setLookupName(new SimpleJndiName("java:comp/DefaultContextService"));
        } else {
            resourceEnvRef.setJndiName(this.getDefaultResourceJndiName(resourceEnvRef.getName()));
        }
    }

    private void computeRuntimeDefault(MessageDestinationReferenceDescriptor msgDestRef) {
        if (msgDestRef.getJndiName() == null || msgDestRef.getJndiName().isEmpty()) {
            msgDestRef.setJndiName(this.getDefaultResourceJndiName(msgDestRef.getName()));
        }
    }

    private void computeRuntimeDefault(MessageDestinationDescriptor msgDest) {
        if (msgDest.getJndiName() == null || msgDest.getJndiName().isEmpty()) {
            msgDest.setJndiName(this.getDefaultResourceJndiName(msgDest.getName()));
        }
    }

    private SimpleJndiName getDefaultResourceJndiName(String resName) {
        return SimpleJndiName.of(resName);
    }

    private static class EjbIntfInfo {
        Set<EjbDescriptor> ejbs;

        private EjbIntfInfo() {
        }
    }

    private static enum EjbIntfType {
        NONE,
        REMOTE_HOME,
        REMOTE_BUSINESS,
        LOCAL_HOME,
        LOCAL_BUSINESS,
        NO_INTF_LOCAL_BUSINESS;

    }
}

