/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.deploy.shared;

import com.sun.enterprise.deployment.deploy.shared.Util;
import java.io.IOException;
import java.net.URI;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.jar.JarEntry;
import org.glassfish.api.deployment.archive.Archive;
import org.glassfish.api.deployment.archive.ReadableArchive;

public abstract class JarArchive
implements Archive {
    protected ReadableArchive parentArchive;
    protected Map<Class<?>, Object> extraData = new HashMap();
    protected Map<String, Object> archiveMetaData = new HashMap<String, Object>();

    @Override
    public Enumeration<String> entries(String prefix) {
        Enumeration<String> allEntries = this.entries();
        Vector<String> entries = new Vector<String>();
        while (allEntries.hasMoreElements()) {
            String name = allEntries.nextElement();
            if (name == null || !name.startsWith(prefix)) continue;
            entries.add(name);
        }
        return entries.elements();
    }

    @Override
    public String getName() {
        return JarArchive.getName(this.getURI());
    }

    protected abstract JarEntry getJarEntry(String var1);

    public boolean exists(String name) throws IOException {
        return this.getJarEntry(name) != null;
    }

    @Override
    public boolean isDirectory(String name) {
        JarEntry entry = this.getJarEntry(name);
        if (entry == null) {
            throw new IllegalArgumentException(name);
        }
        return entry.isDirectory();
    }

    static String getName(URI uri) {
        String path = Util.getURIName(uri);
        int lastDot = path.lastIndexOf(46);
        int endOfName = lastDot == -1 ? path.length() : lastDot;
        return path.substring(0, endOfName);
    }

    public void setParentArchive(ReadableArchive parentArchive) {
        this.parentArchive = parentArchive;
    }

    public ReadableArchive getParentArchive() {
        return this.parentArchive;
    }

    public synchronized <U> U getExtraData(Class<U> dataType) {
        return dataType.cast(this.extraData.get(dataType));
    }

    public synchronized <U> void setExtraData(Class<U> dataType, U instance) {
        this.extraData.put(dataType, instance);
    }

    public synchronized <U> void removeExtraData(Class<U> dataType) {
        this.extraData.remove(dataType);
    }

    public void addArchiveMetaData(String metaDataKey, Object metaData) {
        if (metaData != null) {
            this.archiveMetaData.put(metaDataKey, metaData);
        }
    }

    public <T> T getArchiveMetaData(String metaDataKey, Class<T> metadataType) {
        Object metaData = this.archiveMetaData.get(metaDataKey);
        if (metaData != null) {
            return metadataType.cast(metaData);
        }
        return null;
    }

    public void removeArchiveMetaData(String metaDataKey) {
        this.archiveMetaData.remove(metaDataKey);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "]";
    }
}

