/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.archivist;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.EARBasedPersistenceHelper;
import com.sun.enterprise.deployment.archivist.ExtensionsArchivistFor;
import com.sun.enterprise.deployment.archivist.PersistenceArchivist;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.glassfish.api.deployment.archive.Archive;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.jvnet.hk2.annotations.Service;
import org.xml.sax.SAXException;

@Service
@ExtensionsArchivistFor(value="jpa")
public class EarPersistenceArchivist
extends PersistenceArchivist {
    @Override
    public boolean supportsModuleType(ArchiveType moduleType) {
        return DOLUtils.earType().equals(moduleType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RootDeploymentDescriptor open(Archivist main, ReadableArchive earArchive, RootDeploymentDescriptor descriptor) throws IOException, SAXException {
        if (deplLogger.isLoggable(Level.FINE)) {
            deplLogger.logp(Level.FINE, "EarArchivist", "readPersistenceDeploymentDescriptors", "archive = {0}", earArchive.getURI());
        }
        HashMap<String, ReadableArchive> probablePersitenceArchives = new HashMap<String, ReadableArchive>();
        try {
            if (!(descriptor instanceof Application)) {
                RootDeploymentDescriptor rootDeploymentDescriptor = null;
                return rootDeploymentDescriptor;
            }
            Application app = (Application)Application.class.cast(descriptor);
            EARBasedPersistenceHelper.addLibraryAndTopLevelCandidates(earArchive, app, true, probablePersitenceArchives);
            for (Map.Entry pathToArchiveEntry : probablePersitenceArchives.entrySet()) {
                this.readPersistenceDeploymentDescriptor(main, (ReadableArchive)pathToArchiveEntry.getValue(), (String)pathToArchiveEntry.getKey(), descriptor);
            }
        }
        finally {
            for (Archive subArchive : probablePersitenceArchives.values()) {
                subArchive.close();
            }
        }
        return null;
    }
}

