/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.archivist;

import com.sun.enterprise.config.serverbeans.DasConfig;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.io.ApplicationDeploymentDescriptorFile;
import com.sun.enterprise.deployment.util.ApplicationValidator;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.ModuleDescriptor;
import org.jvnet.hk2.annotations.Service;
import org.xml.sax.SAXException;

@Service
public class ApplicationFactory {
    protected static final Logger logger = DOLUtils.getDefaultLogger();
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(Archivist.class);
    @Inject
    ArchiveFactory archiveFactory;
    @Inject
    ArchivistFactory archivistFactory;
    @Inject
    DasConfig dasConfig;

    public Application openArchive(URI jarFile, String archiveType) throws IOException, SAXException {
        return this.openArchive(jarFile, archiveType, false);
    }

    public Application openArchive(Archivist archivist, URI jarFile, boolean handleRuntimeInfo) throws IOException, SAXException {
        ReadableArchive archive = this.archiveFactory.openArchive(jarFile);
        Application application = this.openArchive(archivist, archive, handleRuntimeInfo);
        archive.close();
        return application;
    }

    public Application openArchive(Archivist archivist, ReadableArchive in, boolean handleRuntimeInfo) throws IOException, SAXException {
        return this.openArchive(in.getURI().getSchemeSpecificPart(), archivist, in, handleRuntimeInfo);
    }

    public Application openArchive(String appName, Archivist archivist, ReadableArchive in, boolean handleRuntimeInfo) throws IOException, SAXException {
        Application application;
        archivist.setHandleRuntimeInfo(false);
        Object descriptor = archivist.open(in);
        if (descriptor instanceof Application) {
            application = (Application)descriptor;
            application.setAppName(appName);
            application.setRegistrationName(appName);
        } else {
            if (descriptor == null) {
                logger.log(Level.SEVERE, localStrings.getLocalString("enterprise.deployment.cannotreadDDs", "Cannot read the Deployment Descriptors for module {0}", in.getURI()));
                return null;
            }
            ModuleDescriptor<BundleDescriptor> newModule = archivist.createModuleDescriptor(descriptor);
            newModule.setArchiveUri(in.getURI().getSchemeSpecificPart());
            application = Application.createVirtualApplication(appName, newModule);
        }
        if (handleRuntimeInfo) {
            archivist.setHandleRuntimeInfo(true);
            archivist.readRuntimeDeploymentDescriptor(in, descriptor);
        }
        application.setClassLoader(archivist.getClassLoader());
        application.visit(new ApplicationValidator());
        return application;
    }

    public Application createApplicationFromStandardDD(ReadableArchive archive, String archiveType) throws IOException, SAXException {
        Object archivist = this.archivistFactory.getArchivist(archiveType, null);
        String xmlValidationLevel = this.dasConfig.getDeployXmlValidation();
        ((Archivist)archivist).setXMLValidationLevel(xmlValidationLevel);
        if (xmlValidationLevel.equals("none")) {
            ((Archivist)archivist).setXMLValidation(false);
        }
        Object desc = ((Archivist)archivist).readStandardDeploymentDescriptor(archive);
        Application application = null;
        if (desc instanceof Application) {
            application = (Application)desc;
        } else {
            ModuleDescriptor<BundleDescriptor> newModule = ((Archivist)archivist).createModuleDescriptor(desc);
            newModule.setArchiveUri(archive.getURI().getSchemeSpecificPart());
            String moduleName = newModule.getModuleName();
            application = Application.createVirtualApplication(moduleName, newModule);
        }
        return application;
    }

    public Application openWith(Application application, ReadableArchive archive, Archivist archivist) throws IOException, SAXException {
        archivist.openWith(application, archive);
        if (application.isVirtual()) {
            application.setClassLoader(archivist.getClassLoader());
            application.visit(new ApplicationValidator());
        }
        return application;
    }

    public Application openArchive(URI jarFile, String archiveType, boolean handleRuntimeInfo) throws IOException, SAXException {
        Object archivist = this.archivistFactory.getArchivist(archiveType);
        return this.openArchive((Archivist)archivist, jarFile, handleRuntimeInfo);
    }

    public String getApplicationName(File jarFile) throws IOException {
        if (!jarFile.exists()) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionjarfiledoesn'texist", "{0} does not exist", jarFile));
        }
        try (JarFile jar = new JarFile(jarFile);){
            ApplicationDeploymentDescriptorFile node = new ApplicationDeploymentDescriptorFile();
            node.setXMLValidation(false);
            ZipEntry deploymentEntry = jar.getEntry(node.getDeploymentDescriptorPath());
            if (deploymentEntry == null) {
                String string = null;
                return string;
            }
            Application application = (Application)node.read(jar.getInputStream(deploymentEntry));
            String string = application.getDisplayName();
            return string;
        }
    }
}

