/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.impl;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.annotation.introspection.DefaultAnnotationScanner;
import com.sun.enterprise.deployment.util.DOLUtils;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.zip.ZipException;
import org.glassfish.apf.impl.JavaEEScanner;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.hk2.classmodel.reflect.AnnotatedElement;
import org.glassfish.hk2.classmodel.reflect.AnnotationType;
import org.glassfish.hk2.classmodel.reflect.ClassModel;
import org.glassfish.hk2.classmodel.reflect.ExtensibleType;
import org.glassfish.hk2.classmodel.reflect.InterfaceModel;
import org.glassfish.hk2.classmodel.reflect.Member;
import org.glassfish.hk2.classmodel.reflect.Parser;
import org.glassfish.hk2.classmodel.reflect.ParsingContext;
import org.glassfish.hk2.classmodel.reflect.Type;
import org.glassfish.logging.annotation.LogMessageInfo;

public abstract class ModuleScanner<T extends Descriptor>
extends JavaEEScanner<T> {
    private static final Logger LOG = DOLUtils.getDefaultLogger();
    @LogMessageInfo(message="Exception caught during annotation scanning.", cause="An exception was caught that indicates that the annotation is incorrect.", action="Correct the annotation.", level="SEVERE")
    private static final String ANNOTATION_SCANNING_EXCEPTION = "AS-DEPLOYMENT-00005";
    @LogMessageInfo(message="Adding {0} since {1} is annotated with {2}.", level="CONFIG")
    private static final String ANNOTATION_ADDED = "AS-DEPLOYMENT-00006";
    @LogMessageInfo(message="Adding {0} since it is implementing {1}.", level="CONFIG")
    private static final String INTERFACE_ADDED = "AS-DEPLOYMENT-00007";
    @LogMessageInfo(message="Inconsistent type definition.  {0} is neither an annotation nor an interface.", cause="The annotation is incorrect.", action="Correct the annotation.", level="SEVERE")
    private static final String INCORRECT_ANNOTATION = "AS-DEPLOYMENT-00008";
    @LogMessageInfo(message="The exception {0} occurred while examining the jar at file path:  {1}.", level="WARNING")
    private static final String JAR_EXCEPTION = "AS-DEPLOYMENT-00009";
    @LogMessageInfo(message="No classloader can be found to use", cause="The archive being processed is not correct.", action="Examine the archive to determine what is incorrect.", level="SEVERE")
    private static final String NO_CLASSLOADER = "AS-DEPLOYMENT-00010";
    @LogMessageInfo(message="Error in annotation processing:", level="WARNING")
    private static final String ANNOTATION_ERROR = "AS-DEPLOYMENT-00011";
    @LogMessageInfo(message="Cannot load {0}  reason : {1}.", level="WARNING")
    private static final String CLASSLOADING_ERROR = "AS-DEPLOYMENT-00012";
    @LogMessageInfo(message="An exception was caught during library jar processing:  {0}.", level="WARNING")
    private static final String LIBRARY_JAR_ERROR = "AS-DEPLOYMENT-00013";
    private static ExecutorService executorService;
    @Inject
    private DefaultAnnotationScanner defaultScanner;
    protected File archiveFile;
    protected ClassLoader classLoader;
    protected Parser classParser;
    protected Set<URI> scannedURI = new HashSet<URI>();
    protected Set<String> entries = new HashSet<String>();
    private boolean needScanAnnotation;

    public void process(ReadableArchive archiveFile, T descriptor, ClassLoader classLoader, Parser parser) throws IOException {
        File file = new File(archiveFile.getURI());
        this.setParser(parser);
        if (LOG.isLoggable(Level.CONFIG)) {
            LOG.log(Level.CONFIG, "Processing file={0}, descriptor={1}, classLoader={2}", new Object[]{archiveFile, descriptor, classLoader});
        }
        this.process(file, descriptor, classLoader);
        this.completeProcess(descriptor, archiveFile);
        this.calculateResults(descriptor);
    }

    protected void setParser(Parser parser) {
        if (parser == null) {
            ParsingContext pc = new ParsingContext.Builder().executorService(this.getExecutorService()).build();
            parser = new Parser(pc);
            this.needScanAnnotation = true;
        }
        this.classParser = parser;
    }

    protected void completeProcess(T descriptor, ReadableArchive archive) throws IOException {
        this.addLibraryJars(descriptor, archive);
    }

    protected void calculateResults(T descriptor) {
        try {
            this.classParser.awaitTermination();
        }
        catch (InterruptedException e) {
            LOG.log(Level.SEVERE, ANNOTATION_SCANNING_EXCEPTION, e);
            return;
        }
        ParsingContext context = this.classParser.getContext();
        boolean isFullAttribute = descriptor instanceof BundleDescriptor ? ((BundleDescriptor)descriptor).isFullAttribute() : false;
        Set<String> annotationsToProcess = this.defaultScanner.getAnnotations(isFullAttribute);
        for (String annotation : annotationsToProcess) {
            Type type2 = context.getTypes().getBy(annotation);
            if (type2 == null) continue;
            if (type2 instanceof AnnotationType) {
                AnnotationType at = (AnnotationType)type2;
                for (AnnotatedElement ae : at.allAnnotatedTypes()) {
                    ExtensibleType<?> t = ae instanceof Member ? ((Member)((Object)ae)).getDeclaringType() : (ExtensibleType<?>)ae;
                    if (!t.wasDefinedIn(this.scannedURI)) continue;
                    if (LOG.isLoggable(Level.CONFIG)) {
                        LOG.log(Level.CONFIG, ANNOTATION_ADDED, new Object[]{t.getName(), ae.getName(), at.getName()});
                    }
                    this.entries.add(t.getName());
                }
                continue;
            }
            if (type2 instanceof InterfaceModel) {
                InterfaceModel im = (InterfaceModel)type2;
                for (ClassModel cm : im.allImplementations()) {
                    if (LOG.isLoggable(Level.CONFIG)) {
                        LOG.log(Level.CONFIG, INTERFACE_ADDED, new Object[]{cm.getName(), im.getName()});
                    }
                    this.entries.add(cm.getName());
                }
                continue;
            }
            LOG.log(Level.SEVERE, INCORRECT_ANNOTATION, annotation);
        }
        LOG.log(Level.FINE, "Done with results");
    }

    protected void addScanClassName(String className) {
        if (className != null && !className.isEmpty()) {
            this.entries.add(className);
        }
    }

    protected void addScanJar(File jarFile) throws IOException {
        try {
            if (!jarFile.exists()) {
                return;
            }
            this.scannedURI.add(jarFile.toURI());
            if (this.needScanAnnotation) {
                this.classParser.parse(jarFile, null);
            }
        }
        catch (ZipException ze) {
            LOG.log(Level.WARNING, JAR_EXCEPTION, new Object[]{ze.getMessage(), jarFile.getPath()});
        }
    }

    protected void addScanURI(URI jarURI) throws IOException {
        this.addScanJar(new File(jarURI));
    }

    protected void addScanDirectory(File directory) throws IOException {
        this.scannedURI.add(directory.toURI());
        if (this.needScanAnnotation) {
            this.classParser.parse(directory, null);
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public Set<Class<?>> getElements() {
        HashSet elements = new HashSet();
        if (this.getClassLoader() == null) {
            LOG.log(Level.SEVERE, NO_CLASSLOADER);
            return elements;
        }
        for (String className : this.entries) {
            LOG.log(Level.FINEST, "Getting {0}", className);
            try {
                elements.add(this.classLoader.loadClass(className));
            }
            catch (NoClassDefFoundError err) {
                LOG.log(Level.WARNING, ANNOTATION_ERROR, err);
            }
            catch (ClassNotFoundException cnfe) {
                LogRecord lr = new LogRecord(Level.WARNING, CLASSLOADING_ERROR);
                Object[] args = new Object[]{className, cnfe.getMessage()};
                lr.setParameters(args);
                lr.setThrown(cnfe);
                LOG.log(lr);
            }
        }
        return elements;
    }

    protected void addLibraryJars(T bundleDesc, ReadableArchive moduleArchive) {
        List<Object> libraryURIs = new ArrayList();
        try {
            if (bundleDesc instanceof BundleDescriptor) {
                libraryURIs = DOLUtils.getLibraryJarURIs((BundleDescriptor)bundleDesc, moduleArchive);
            }
            for (URI uri : libraryURIs) {
                File libFile = new File(uri);
                if (libFile.isFile()) {
                    this.addScanJar(libFile);
                    continue;
                }
                if (!libFile.isDirectory()) continue;
                this.addScanDirectory(libFile);
            }
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, LIBRARY_JAR_ERROR, ex.getMessage());
        }
    }

    protected synchronized ExecutorService getExecutorService() {
        if (executorService != null) {
            return executorService;
        }
        Runtime runtime = Runtime.getRuntime();
        int nrOfProcessors = runtime.availableProcessors();
        executorService = Executors.newFixedThreadPool(nrOfProcessors, r -> {
            Thread t = new Thread(r);
            t.setName("dol-jar-scanner");
            t.setDaemon(true);
            t.setContextClassLoader(this.getClass().getClassLoader());
            return t;
        });
        return executorService;
    }
}

