/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import com.sun.enterprise.deployment.ManagedExecutorDefinitionDescriptor;
import com.sun.enterprise.deployment.MetadataSource;
import com.sun.enterprise.deployment.annotation.handlers.ConcurrencyDefinitionConvertor;
import com.sun.enterprise.deployment.annotation.handlers.ManagedExecutorDefinitionData;
import jakarta.enterprise.concurrent.ManagedExecutorDefinition;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.glassfish.config.support.TranslatedConfigView;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.jvnet.hk2.annotations.Service;

@Service
class ManagedExecutorDefinitionConverter
extends ConcurrencyDefinitionConvertor<ManagedExecutorDefinitionData, ManagedExecutorDefinitionDescriptor> {
    private static final System.Logger LOG = System.getLogger(ManagedExecutorDefinitionConverter.class.getName());

    ManagedExecutorDefinitionConverter() {
        super(ManagedExecutorDefinitionDescriptor.class, JavaEEResourceType.MEDD);
    }

    @Override
    ManagedExecutorDefinitionDescriptor createDescriptor(ManagedExecutorDefinitionData data) {
        return new ManagedExecutorDefinitionDescriptor(data, MetadataSource.ANNOTATION);
    }

    @Override
    ManagedExecutorDefinitionData getData(ManagedExecutorDefinitionDescriptor descriptor) {
        return descriptor.getData();
    }

    Set<ManagedExecutorDefinitionData> convert(ManagedExecutorDefinition[] annotation) {
        LOG.log(System.Logger.Level.TRACE, "convert(annotation={0})", new Object[]{annotation});
        if (annotation == null) {
            return Collections.emptySet();
        }
        return Arrays.stream(annotation).map(this::convert).collect(Collectors.toSet());
    }

    ManagedExecutorDefinitionData convert(ManagedExecutorDefinition annotation) {
        LOG.log(System.Logger.Level.DEBUG, "convert(annotation={0})", annotation);
        ManagedExecutorDefinitionData data = new ManagedExecutorDefinitionData();
        data.setName(TranslatedConfigView.expandValue(annotation.name()));
        data.setContext(TranslatedConfigView.expandValue(annotation.context()));
        for (Class<?> clazz : annotation.qualifiers()) {
            data.addQualifier(clazz.getCanonicalName());
        }
        data.setUseVirtualThreads(annotation.virtual());
        if (annotation.hungTaskThreshold() < 0L) {
            data.setHungAfterSeconds(0L);
        } else {
            data.setHungAfterSeconds(annotation.hungTaskThreshold());
        }
        if (annotation.maxAsync() < 0) {
            data.setMaximumPoolSize(Integer.MAX_VALUE);
        } else {
            data.setMaximumPoolSize(annotation.maxAsync());
        }
        return data;
    }

    @Override
    void merge(ManagedExecutorDefinitionData annotation, ManagedExecutorDefinitionData descriptor) {
        LOG.log(System.Logger.Level.DEBUG, "merge(annotation={0}, descriptor={1})", annotation, descriptor);
        if (!annotation.getName().equals(descriptor.getName())) {
            throw new IllegalArgumentException("Cannot merge managed executors with different names: " + annotation.getName() + " x " + descriptor.getName());
        }
        this.mergeQualifiers(annotation, descriptor);
        if (!descriptor.getUseVirtualThreads()) {
            descriptor.setUseVirtualThreads(annotation.getUseVirtualThreads());
        }
        if (descriptor.getHungAfterSeconds() <= 0L && annotation.getHungAfterSeconds() != 0L) {
            descriptor.setHungAfterSeconds(annotation.getHungAfterSeconds());
        }
        if (descriptor.getMaximumPoolSize() <= 0 && annotation.getMaximumPoolSize() > 0 && annotation.getMaximumPoolSize() < Integer.MAX_VALUE) {
            descriptor.setMaximumPoolSize(annotation.getMaximumPoolSize());
        }
        if (descriptor.getContext() == null && annotation.getContext() != null && !annotation.getContext().isBlank()) {
            descriptor.setContext(TranslatedConfigView.expandValue(annotation.getContext()));
        }
    }
}

