/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import com.sun.enterprise.deployment.ContextServiceDefinitionDescriptor;
import com.sun.enterprise.deployment.MetadataSource;
import com.sun.enterprise.deployment.annotation.handlers.ConcurrencyDefinitionConvertor;
import com.sun.enterprise.deployment.annotation.handlers.ContextServiceDefinitionData;
import jakarta.enterprise.concurrent.ContextServiceDefinition;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.glassfish.config.support.TranslatedConfigView;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.jvnet.hk2.annotations.Service;

@Service
class ContextServiceDefinitionConverter
extends ConcurrencyDefinitionConvertor<ContextServiceDefinitionData, ContextServiceDefinitionDescriptor> {
    private static final System.Logger LOG = System.getLogger(ContextServiceDefinitionConverter.class.getName());

    ContextServiceDefinitionConverter() {
        super(ContextServiceDefinitionDescriptor.class, JavaEEResourceType.CSDD);
    }

    @Override
    ContextServiceDefinitionDescriptor createDescriptor(ContextServiceDefinitionData annotation) {
        return new ContextServiceDefinitionDescriptor(annotation, MetadataSource.ANNOTATION);
    }

    @Override
    ContextServiceDefinitionData getData(ContextServiceDefinitionDescriptor descriptor) {
        return descriptor.getData();
    }

    Set<ContextServiceDefinitionData> convert(ContextServiceDefinition[] definitions) {
        LOG.log(System.Logger.Level.TRACE, "convert(definitions={0})", new Object[]{definitions});
        if (definitions == null) {
            return Collections.emptySet();
        }
        return Arrays.stream(definitions).map(this::convert).collect(Collectors.toSet());
    }

    ContextServiceDefinitionData convert(ContextServiceDefinition annotation) {
        LOG.log(System.Logger.Level.DEBUG, "convert(definition={0})", annotation);
        Set<String> unused = this.collectUnusedContexts(annotation);
        ContextServiceDefinitionData data = new ContextServiceDefinitionData();
        data.setName(TranslatedConfigView.expandValue(annotation.name()));
        data.setPropagated(this.evaluateContexts(annotation.propagated(), unused));
        data.setCleared(this.evaluateContexts(annotation.cleared(), unused));
        data.setUnchanged(this.evaluateContexts(annotation.unchanged(), unused));
        for (Class<?> clazz : annotation.qualifiers()) {
            data.addQualifier(clazz.getCanonicalName());
        }
        return data;
    }

    private Set<String> collectUnusedContexts(ContextServiceDefinition definition) {
        boolean previous;
        HashSet<String> usedContexts = new HashSet<String>();
        for (String context : definition.propagated()) {
            usedContexts.add(context);
        }
        for (String context : definition.cleared()) {
            previous = usedContexts.add(context);
            if (previous) continue;
            throw new IllegalArgumentException("Duplicit context " + context + " in " + String.valueOf(usedContexts) + " and cleared context attributes in ContextServiceDefinition annotation!");
        }
        for (String context : definition.unchanged()) {
            previous = usedContexts.add(context);
            if (previous) continue;
            throw new IllegalArgumentException("Duplicit context " + context + " in " + previous + " and unchanged context attributes in ContextServiceDefinition annotation!");
        }
        HashSet<String> allStandardContexts = new HashSet<String>(Set.of("Application", "Security", "Transaction"));
        allStandardContexts.removeAll(usedContexts);
        return allStandardContexts;
    }

    private Set<String> evaluateContexts(String[] sourceContexts, Set<String> unusedContexts) {
        HashSet<String> contexts = new HashSet<String>();
        for (String context : sourceContexts) {
            if ("Remaining".equals(context)) {
                contexts.addAll(unusedContexts);
                contexts.add("Remaining");
                continue;
            }
            contexts.add(context);
        }
        return contexts;
    }

    @Override
    void merge(ContextServiceDefinitionData annotation, ContextServiceDefinitionData descriptor) {
        LOG.log(System.Logger.Level.DEBUG, "merge(annotation={0}, descriptor={1})", annotation, descriptor);
        if (!annotation.getName().equals(descriptor.getName())) {
            throw new IllegalArgumentException("Cannot merge context services with different names: " + annotation.getName() + " x " + descriptor.getName());
        }
        if (descriptor.getCleared() == null && annotation.getCleared() != null) {
            descriptor.setCleared(new HashSet<String>(annotation.getCleared()));
        }
        if (descriptor.getPropagated() == null && annotation.getPropagated() != null) {
            descriptor.setPropagated(new HashSet<String>(annotation.getPropagated()));
        }
        if (descriptor.getUnchanged() == null && annotation.getUnchanged() != null) {
            descriptor.setUnchanged(new HashSet<String>(annotation.getUnchanged()));
        }
        this.mergeQualifiers(annotation, descriptor);
    }
}

