/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.MessageDestinationDescriptor;
import com.sun.enterprise.deployment.MessageDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.types.MessageDestinationReferencer;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.deployment.common.RootDeploymentDescriptor;

public class MessageDestinationReferencerImpl
implements MessageDestinationReferencer,
Serializable {
    private static final long serialVersionUID = 1L;
    private String messageDestinationLinkName;
    private MessageDestinationDescriptor messageDestination;
    private MessageDestinationReferenceDescriptor ownerMsgDestRef;
    private EjbMessageBeanDescriptor ownerMsgBean;

    public MessageDestinationReferencerImpl(MessageDestinationReferencerImpl other) {
        this.messageDestinationLinkName = other.messageDestinationLinkName;
        this.messageDestination = other.messageDestination;
        this.ownerMsgDestRef = other.ownerMsgDestRef;
        this.ownerMsgBean = other.ownerMsgBean;
    }

    public MessageDestinationReferencerImpl(Descriptor desc) {
        if (desc instanceof MessageDestinationReferenceDescriptor) {
            this.ownerMsgDestRef = (MessageDestinationReferenceDescriptor)desc;
        } else if (desc instanceof EjbMessageBeanDescriptor) {
            this.ownerMsgBean = (EjbMessageBeanDescriptor)((Object)desc);
        } else {
            throw new IllegalArgumentException("Invalid desc = " + String.valueOf(desc));
        }
    }

    @Override
    public boolean ownedByMessageDestinationRef() {
        return this.ownerMsgDestRef != null;
    }

    @Override
    public MessageDestinationReferenceDescriptor getMessageDestinationRefOwner() {
        return this.ownerMsgDestRef;
    }

    @Override
    public boolean ownedByMessageBean() {
        return this.ownerMsgBean != null;
    }

    @Override
    public EjbMessageBeanDescriptor getMessageBeanOwner() {
        return this.ownerMsgBean;
    }

    @Override
    public boolean isLinkedToMessageDestination() {
        return this.messageDestination != null;
    }

    private BundleDescriptor getBundleDescriptor() {
        return this.ownedByMessageDestinationRef() ? this.ownerMsgDestRef.getReferringBundleDescriptor() : this.ownerMsgBean.getEjbBundleDescriptor();
    }

    @Override
    public String getMessageDestinationLinkName() {
        return this.messageDestinationLinkName;
    }

    @Override
    public void setMessageDestinationLinkName(String linkName) {
        this.setMessageDestinationLinkName(linkName, false);
    }

    @Override
    public MessageDestinationDescriptor setMessageDestinationLinkName(String linkName, boolean resolve) {
        this.messageDestinationLinkName = linkName;
        if (resolve) {
            return this.resolveLinkName();
        }
        return null;
    }

    @Override
    public MessageDestinationDescriptor resolveLinkName() {
        MessageDestinationDescriptor msgDest = null;
        String linkName = this.messageDestinationLinkName;
        if (linkName != null && !linkName.isEmpty()) {
            int hashIndex = linkName.indexOf(35);
            BundleDescriptor bundleDescriptor = this.getBundleDescriptor();
            Application app = bundleDescriptor.getApplication();
            if (app == null && bundleDescriptor instanceof Application) {
                app = (Application)bundleDescriptor;
            }
            BundleDescriptor targetBundle = null;
            String msgDestName = linkName;
            if (app != null) {
                if (hashIndex != -1) {
                    String relativeModuleUri = linkName.substring(0, hashIndex);
                    msgDestName = linkName.substring(hashIndex + 1);
                    targetBundle = app.getRelativeBundle(bundleDescriptor, relativeModuleUri);
                } else if (bundleDescriptor.hasMessageDestinationByName(msgDestName)) {
                    targetBundle = bundleDescriptor;
                } else {
                    Set<BundleDescriptor> modules = app.getBundleDescriptors();
                    for (BundleDescriptor next : modules) {
                        if (!next.hasMessageDestinationByName(msgDestName)) continue;
                        targetBundle = next;
                        break;
                    }
                    if (targetBundle == null) {
                        Collection<RootDeploymentDescriptor> extensionBundles = bundleDescriptor.getExtensionsDescriptors();
                        for (RootDeploymentDescriptor next : extensionBundles) {
                            if (!(next instanceof BundleDescriptor) || !((BundleDescriptor)next).hasMessageDestinationByName(msgDestName)) continue;
                            targetBundle = (BundleDescriptor)next;
                            break;
                        }
                    }
                }
            }
            try {
                if (targetBundle != null) {
                    msgDest = targetBundle.getMessageDestinationByName(msgDestName);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (msgDest != null) {
            this.setMessageDestination(msgDest);
        }
        return msgDest;
    }

    @Override
    public MessageDestinationDescriptor getMessageDestination() {
        return this.messageDestination;
    }

    @Override
    public void setMessageDestination(MessageDestinationDescriptor newMsgDest) {
        if (this.messageDestination != null) {
            this.messageDestination.removeReferencer(this);
        }
        if (newMsgDest != null) {
            newMsgDest.addReferencer(this);
            BundleDescriptor bundleDescriptor = this.getBundleDescriptor();
            BundleDescriptor targetBundleDescriptor = newMsgDest.getBundleDescriptor();
            Object linkName = newMsgDest.getName();
            if (bundleDescriptor != targetBundleDescriptor) {
                Application app = bundleDescriptor.getApplication();
                String relativeUri = app.getRelativeUri(bundleDescriptor, targetBundleDescriptor);
                linkName = relativeUri + "#" + (String)linkName;
            }
            this.messageDestinationLinkName = linkName;
        }
        this.messageDestination = newMsgDest;
    }
}

