/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbInterceptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.InjectionCapable;
import com.sun.enterprise.deployment.InjectionInfo;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.InterceptorDescriptor;
import com.sun.enterprise.deployment.JndiEnvironmentRefsGroupDescriptor;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.util.ApplicationValidator;
import com.sun.enterprise.deployment.util.ManagedBeanVisitor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.api.naming.SimpleJndiName;

public final class ManagedBeanDescriptor
extends JndiEnvironmentRefsGroupDescriptor {
    private static final long serialVersionUID = 1L;
    private String name;
    private String beanClassName;
    private BundleDescriptor enclosingBundle;
    private Object interceptorBuilder;
    private final Collection<Object> beanInstances = new HashSet<Object>();
    private final Map<Object, Object> beanSupportingInfo = new HashMap<Object, Object>();
    private List<InterceptorDescriptor> classInterceptorChain = new LinkedList<InterceptorDescriptor>();
    private final Set<LifecycleCallbackDescriptor> aroundInvokeDescs = new HashSet<LifecycleCallbackDescriptor>();
    private final Map<MethodDescriptor, List<InterceptorDescriptor>> methodInterceptorsMap = new HashMap<MethodDescriptor, List<InterceptorDescriptor>>();

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isNamed() {
        return this.name != null;
    }

    public void setBeanClassName(String className) {
        this.beanClassName = className;
    }

    public String getBeanClassName() {
        return this.beanClassName;
    }

    public void setBundle(BundleDescriptor bundle2) {
        this.enclosingBundle = bundle2;
        super.setBundleDescriptor(bundle2);
    }

    public BundleDescriptor getBundle() {
        return this.enclosingBundle;
    }

    public void setInterceptorBuilder(Object b) {
        this.interceptorBuilder = b;
    }

    public Object getInterceptorBuilder() {
        return this.interceptorBuilder;
    }

    public boolean hasInterceptorBuilder() {
        return this.interceptorBuilder != null;
    }

    public void addBeanInstanceInfo(Object o) {
        this.addBeanInstanceInfo(o, null);
    }

    public void addBeanInstanceInfo(Object o, Object supportingInfo) {
        this.beanInstances.add(o);
        if (supportingInfo != null) {
            this.beanSupportingInfo.put(o, supportingInfo);
        }
    }

    public Collection<Object> getBeanInstances() {
        return new HashSet<Object>(this.beanInstances);
    }

    public Object getSupportingInfoForBeanInstance(Object o) {
        return this.beanSupportingInfo.get(o);
    }

    public void clearBeanInstanceInfo(Object beanInstance) {
        this.beanInstances.remove(beanInstance);
        this.beanSupportingInfo.remove(beanInstance);
    }

    public void clearAllBeanInstanceInfo() {
        this.beanInstances.clear();
        this.beanSupportingInfo.clear();
        this.interceptorBuilder = null;
    }

    public Set<String> getAllInterceptorClasses() {
        HashSet<String> classes = new HashSet<String>();
        for (InterceptorDescriptor interceptorDescriptor : this.classInterceptorChain) {
            classes.add(interceptorDescriptor.getInterceptorClassName());
        }
        for (List list : this.methodInterceptorsMap.values()) {
            for (InterceptorDescriptor interceptor : list) {
                classes.add(interceptor.getInterceptorClassName());
            }
        }
        return classes;
    }

    public void setClassInterceptorChain(List<InterceptorDescriptor> chain) {
        this.classInterceptorChain = new LinkedList<InterceptorDescriptor>(chain);
    }

    public void setMethodLevelInterceptorChain(MethodDescriptor m, List<InterceptorDescriptor> chain) {
        this.methodInterceptorsMap.put(m, chain);
    }

    public List<InterceptorDescriptor> getAroundConstructCallbackInterceptors(Class clz, Constructor ctor) {
        LinkedList<InterceptorDescriptor> callbackInterceptors = new LinkedList<InterceptorDescriptor>();
        Class[] ctorParamTypes = ctor.getParameterTypes();
        String[] parameterClassNames = new MethodDescriptor().getParameterClassNamesFor(null, ctorParamTypes);
        MethodDescriptor mDesc = new MethodDescriptor(clz.getSimpleName(), null, parameterClassNames, "Bean");
        List<InterceptorDescriptor> interceptors = this.methodInterceptorsMap.get(mDesc);
        if (interceptors == null) {
            interceptors = this.classInterceptorChain;
        }
        for (InterceptorDescriptor next : interceptors) {
            if (next.getCallbackDescriptors(LifecycleCallbackDescriptor.CallbackType.AROUND_CONSTRUCT).isEmpty()) continue;
            callbackInterceptors.add(next);
        }
        return callbackInterceptors;
    }

    public List<InterceptorDescriptor> getCallbackInterceptors(LifecycleCallbackDescriptor.CallbackType type2) {
        LinkedList<InterceptorDescriptor> callbackInterceptors = new LinkedList<InterceptorDescriptor>();
        for (InterceptorDescriptor next : this.classInterceptorChain) {
            if (next.getCallbackDescriptors(type2).isEmpty()) continue;
            callbackInterceptors.add(next);
        }
        if (this.hasCallbackDescriptor(type2)) {
            InterceptorDescriptor beanClassCallbackInfo = new InterceptorDescriptor();
            beanClassCallbackInfo.setFromBeanClass(true);
            beanClassCallbackInfo.addCallbackDescriptors(type2, this.getCallbackDescriptors(type2));
            beanClassCallbackInfo.setInterceptorClassName(this.getBeanClassName());
            callbackInterceptors.add(beanClassCallbackInfo);
        }
        return callbackInterceptors;
    }

    public Set<LifecycleCallbackDescriptor> getAroundInvokeDescriptors() {
        return this.aroundInvokeDescs;
    }

    public void addAroundInvokeDescriptor(LifecycleCallbackDescriptor aroundInvokeDesc) {
        String className = aroundInvokeDesc.getLifecycleCallbackClass();
        boolean found = false;
        for (LifecycleCallbackDescriptor next : this.getAroundInvokeDescriptors()) {
            if (!next.getLifecycleCallbackClass().equals(className)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.getAroundInvokeDescriptors().add(aroundInvokeDesc);
        }
    }

    public LifecycleCallbackDescriptor getAroundInvokeDescriptorByClass(String className) {
        for (LifecycleCallbackDescriptor next : this.getAroundInvokeDescriptors()) {
            if (!next.getLifecycleCallbackClass().equals(className)) continue;
            return next;
        }
        return null;
    }

    public boolean hasAroundInvokeMethod() {
        return !this.getAroundInvokeDescriptors().isEmpty();
    }

    public List<InterceptorDescriptor> getAroundInvokeInterceptors(Method m) {
        MethodDescriptor mDesc = new MethodDescriptor(m);
        List<InterceptorDescriptor> aroundInvokeInterceptors = this.methodInterceptorsMap.get(mDesc);
        if (aroundInvokeInterceptors == null) {
            aroundInvokeInterceptors = new LinkedList<InterceptorDescriptor>();
            for (InterceptorDescriptor desc : this.classInterceptorChain) {
                if (!desc.hasAroundInvokeDescriptor()) continue;
                aroundInvokeInterceptors.add(desc);
            }
        }
        if (this.hasAroundInvokeMethod()) {
            EjbInterceptor interceptorInfo = new EjbInterceptor();
            interceptorInfo.setFromBeanClass(true);
            interceptorInfo.addAroundInvokeDescriptors(this.getAroundInvokeDescriptors());
            interceptorInfo.setInterceptorClassName(this.beanClassName);
            aroundInvokeInterceptors.add(interceptorInfo);
        }
        return aroundInvokeInterceptors;
    }

    public SimpleJndiName getGlobalJndiName() {
        if (this.enclosingBundle == null) {
            return null;
        }
        Application app = this.enclosingBundle.getApplication();
        String appName = app.isVirtual() ? null : this.enclosingBundle.getApplication().getAppName();
        String modName = this.enclosingBundle.getModuleDescriptor().getModuleName();
        StringBuilder javaGlobalPrefix = new StringBuilder(64).append("java:global/");
        if (appName != null) {
            javaGlobalPrefix.append(appName);
            javaGlobalPrefix.append('/');
        }
        javaGlobalPrefix.append(modName);
        javaGlobalPrefix.append('/');
        Object componentName = this.isNamed() ? this.name : "___internal_managed_bean_" + this.beanClassName;
        javaGlobalPrefix.append((String)componentName);
        return new SimpleJndiName(javaGlobalPrefix.toString());
    }

    public SimpleJndiName getAppJndiName() {
        if (this.enclosingBundle == null) {
            return null;
        }
        String modName = this.enclosingBundle.getModuleDescriptor().getModuleName();
        StringBuilder javaAppPrefix = new StringBuilder().append("java:app/");
        javaAppPrefix.append(modName);
        javaAppPrefix.append('/');
        Object componentName = this.isNamed() ? this.name : "___internal_managed_bean_" + this.beanClassName;
        javaAppPrefix.append((String)componentName);
        return new SimpleJndiName(javaAppPrefix.toString());
    }

    @Override
    public void print(StringBuffer toStringBuffer) {
    }

    public void validate() {
        this.visit(new ApplicationValidator());
    }

    public void visit(ManagedBeanVisitor aVisitor) {
        aVisitor.accept(this);
    }

    @Override
    public List<InjectionCapable> getInjectableResourcesByClass(String className) {
        LinkedList<EnvironmentProperty> injectables = new LinkedList<EnvironmentProperty>();
        for (EnvironmentProperty envEntry : this.getEnvironmentProperties()) {
            if (!envEntry.hasContent()) continue;
            injectables.add(envEntry);
        }
        injectables.addAll(this.getEjbReferenceDescriptors());
        injectables.addAll(this.getServiceReferenceDescriptors());
        injectables.addAll(this.getResourceReferenceDescriptors());
        injectables.addAll(this.getResourceEnvReferenceDescriptors());
        injectables.addAll(this.getMessageDestinationReferenceDescriptors());
        injectables.addAll(this.getEntityManagerFactoryReferenceDescriptors());
        injectables.addAll(this.getEntityManagerReferenceDescriptors());
        LinkedList<InjectionCapable> injectablesByClass = new LinkedList<InjectionCapable>();
        for (InjectionCapable injectionCapable : injectables) {
            if (!injectionCapable.isInjectable()) continue;
            for (InjectionTarget target : injectionCapable.getInjectionTargets()) {
                if (!target.getClassName().equals(className)) continue;
                injectablesByClass.add(injectionCapable);
            }
        }
        return injectablesByClass;
    }

    @Override
    public InjectionInfo getInjectionInfoByClass(Class<?> clazz) {
        String className = clazz.getName();
        LifecycleCallbackDescriptor postConstructDesc = this.getPostConstructDescriptorByClass(className);
        String postConstructMethodName = postConstructDesc == null ? null : postConstructDesc.getLifecycleCallbackMethod();
        LifecycleCallbackDescriptor preDestroyDesc = this.getPreDestroyDescriptorByClass(className);
        String preDestroyMethodName = preDestroyDesc == null ? null : preDestroyDesc.getLifecycleCallbackMethod();
        InjectionInfo injectionInfo = new InjectionInfo(className, postConstructMethodName, preDestroyMethodName, this.getInjectableResourcesByClass(className));
        return injectionInfo;
    }

    @Override
    public LifecycleCallbackDescriptor getPostConstructDescriptorByClass(String className) {
        for (LifecycleCallbackDescriptor next : this.getPostConstructDescriptors()) {
            if (!next.getLifecycleCallbackClass().equals(className)) continue;
            return next;
        }
        return null;
    }

    @Override
    public LifecycleCallbackDescriptor getPreDestroyDescriptorByClass(String className) {
        for (LifecycleCallbackDescriptor next : this.getPreDestroyDescriptors()) {
            if (!next.getLifecycleCallbackClass().equals(className)) continue;
            return next;
        }
        return null;
    }
}

