/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.AdminObject;
import com.sun.enterprise.deployment.AuthMechanism;
import com.sun.enterprise.deployment.CommonResourceBundleDescriptor;
import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.ConnectorConfigProperty;
import com.sun.enterprise.deployment.InboundResourceAdapter;
import com.sun.enterprise.deployment.LicenseDescriptor;
import com.sun.enterprise.deployment.MessageListener;
import com.sun.enterprise.deployment.OrderedSet;
import com.sun.enterprise.deployment.OutboundResourceAdapter;
import com.sun.enterprise.deployment.SecurityPermission;
import com.sun.enterprise.deployment.runtime.connector.SunConnector;
import com.sun.enterprise.deployment.util.ComponentVisitor;
import com.sun.enterprise.deployment.util.ConnectorTracerVisitor;
import com.sun.enterprise.deployment.util.ConnectorValidator;
import com.sun.enterprise.deployment.util.ConnectorVisitor;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.deployment.common.DescriptorVisitor;

public class ConnectorDescriptor
extends CommonResourceBundleDescriptor {
    private static final long serialVersionUID = 1L;
    private String connectorDescription = "";
    private String vendorName = "";
    private String eisType = "";
    private String version = "";
    private String resourceAdapterVersion = "";
    private LicenseDescriptor licenseDescriptor;
    private final Set<ConnectorConfigProperty> configProperties = new OrderedSet<ConnectorConfigProperty>();
    private Set<SecurityPermission> securityPermissions = new OrderedSet<SecurityPermission>();
    private String resourceAdapterClass = "";
    private OutboundResourceAdapter outboundRA;
    private InboundResourceAdapter inboundRA;
    private final Set<AdminObject> adminObjects = new OrderedSet<AdminObject>();
    private SunConnector sunConnector;
    private final Set<String> requiredWorkContexts = new OrderedSet<String>();
    private transient Set<AnnotationInfo> connectorAnnotations = new OrderedSet<AnnotationInfo>();
    private boolean validConnectorAnnotationProcessed;
    private transient Map<String, Set<AnnotationInfo>> configPropertyAnnotations = new HashMap<String, Set<AnnotationInfo>>();
    private final Set<SimpleJndiName> defaultResourceNames;
    private transient Set<String> configPropertyProcessedClasses = new HashSet<String>();

    public ConnectorDescriptor() {
        this.defaultResourceNames = new OrderedSet<SimpleJndiName>();
    }

    public Set<String> getRequiredWorkContexts() {
        return this.requiredWorkContexts;
    }

    public void addRequiredWorkContext(String workContextClass) {
        this.requiredWorkContexts.add(workContextClass);
    }

    public void removeRequiredWorkContext(String workContextClass) {
        this.requiredWorkContexts.remove(workContextClass);
    }

    @Override
    public String getDefaultSpecVersion() {
        return "2.0";
    }

    public Set<SecurityPermission> getSecurityPermissions() {
        if (this.securityPermissions == null) {
            this.securityPermissions = new OrderedSet<SecurityPermission>();
        }
        return this.securityPermissions;
    }

    public void addSecurityPermission(SecurityPermission permission) {
        this.securityPermissions.add(permission);
    }

    public void removeSecurityPermission(SecurityPermission permission) {
        this.securityPermissions.remove(permission);
    }

    public String getResourceAdapterClass() {
        return this.resourceAdapterClass;
    }

    public void setResourceAdapterClass(String raClass) {
        this.resourceAdapterClass = raClass;
    }

    public Set<ConnectorConfigProperty> getConfigProperties() {
        return this.configProperties;
    }

    public void addConfigProperty(ConnectorConfigProperty configProperty) {
        this.configProperties.add(configProperty);
    }

    public void removeConfigProperty(ConnectorConfigProperty configProperty) {
        this.configProperties.remove(configProperty);
    }

    public LicenseDescriptor getLicenseDescriptor() {
        return this.licenseDescriptor;
    }

    public void setLicenseDescriptor(LicenseDescriptor licenseDescriptor) {
        this.licenseDescriptor = licenseDescriptor;
    }

    public OutboundResourceAdapter getOutboundResourceAdapter() {
        return this.outboundRA;
    }

    public void setOutboundResourceAdapter(OutboundResourceAdapter outboundRA) {
        this.outboundRA = outboundRA;
    }

    public InboundResourceAdapter getInboundResourceAdapter() {
        return this.inboundRA;
    }

    public void setInboundResourceAdapter(InboundResourceAdapter inboundRA) {
        this.inboundRA = inboundRA;
    }

    public Set<AdminObject> getAdminObjects() {
        return this.adminObjects;
    }

    public void addAdminObject(AdminObject admin) {
        boolean duplicate = false;
        if (duplicate) {
            throw new IllegalStateException("Cannot add duplicate admin object with interface [ " + admin.getAdminObjectInterface() + " ], class [ " + admin.getAdminObjectClass() + " ]");
        }
        this.adminObjects.add(admin);
    }

    public void removeAdminObject(AdminObject admin) {
        this.adminObjects.remove(admin);
    }

    public boolean hasAdminObjects() {
        return !this.adminObjects.isEmpty();
    }

    public boolean getOutBoundDefined() {
        return this.outboundRA != null;
    }

    public boolean getInBoundDefined() {
        return this.inboundRA != null;
    }

    public String getConnectorDescription() {
        return this.connectorDescription;
    }

    public void setConnectorDescription(String description) {
        this.connectorDescription = description;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public void setVendorName(String vendorName) {
        this.vendorName = vendorName;
    }

    public String getEisType() {
        return this.eisType;
    }

    public void setEisType(String eisType) {
        this.eisType = eisType;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getResourceAdapterVersion() {
        return this.resourceAdapterVersion;
    }

    public void setResourceAdapterVersion(String resourceAdapterVersion) {
        this.resourceAdapterVersion = resourceAdapterVersion;
    }

    public String getDeployName() {
        return this.getModuleDescriptor().getArchiveUri();
    }

    @Override
    public void visit(DescriptorVisitor aVisitor) {
        if (aVisitor instanceof ConnectorVisitor) {
            this.visit((ComponentVisitor)aVisitor);
        } else {
            super.visit(aVisitor);
        }
    }

    public ConnectionDefDescriptor getConnectionDefinitionByCFType(String type2) {
        return this.getConnectionDefinitionByCFType(type2, true);
    }

    public ConnectionDefDescriptor getConnectionDefinitionByCFType(String type2, boolean useDefault) {
        if (this.outboundRA == null) {
            return null;
        }
        for (ConnectionDefDescriptor desc : this.outboundRA.getConnectionDefs()) {
            if (type2 == null) {
                if (useDefault && this.outboundRA.getConnectionDefs().size() == 1) {
                    return desc;
                }
                return null;
            }
            if (!desc.getConnectionFactoryIntf().equals(type2)) continue;
            return desc;
        }
        return null;
    }

    public int getNumOfSupportedCFs() {
        if (this.outboundRA == null) {
            return 0;
        }
        return this.outboundRA.getConnectionDefs().size();
    }

    public AdminObject getAdminObject(String adminObjectInterface, String adminObjectClass) {
        for (AdminObject ao : this.getAdminObjects()) {
            if (!adminObjectInterface.equals(ao.getAdminObjectInterface()) || !adminObjectClass.equals(ao.getAdminObjectClass())) continue;
            return ao;
        }
        return null;
    }

    public List<AdminObject> getAdminObjectsByType(String type2) {
        ArrayList<AdminObject> adminObjects = new ArrayList<AdminObject>();
        for (AdminObject ao : this.getAdminObjects()) {
            if (!type2.equals(ao.getAdminObjectInterface())) continue;
            adminObjects.add(ao);
        }
        return adminObjects;
    }

    public List<AdminObject> getAdminObjectsByClass(String adminObjectClass) {
        ArrayList<AdminObject> adminObjects = new ArrayList<AdminObject>();
        for (AdminObject ao : this.getAdminObjects()) {
            if (!adminObjectClass.equals(ao.getAdminObjectClass())) continue;
            adminObjects.add(ao);
        }
        return adminObjects;
    }

    @Override
    public void print(StringBuffer toStringBuffer) {
        StringBuffer buf = toStringBuffer;
        super.print(buf);
        buf.append("\n displayName : " + super.getName());
        buf.append("\n connector_description : " + this.connectorDescription);
        buf.append("\n smallIcon : " + super.getSmallIconUri());
        buf.append("\n largeIcon : " + super.getLargeIconUri());
        buf.append("\n vendorName : " + this.vendorName);
        buf.append("\n eisType : " + this.eisType);
        buf.append("\n resourceadapter version : " + this.resourceAdapterVersion);
        if (this.getLicenseDescriptor() != null) {
            buf.append("\n license_description : " + this.getLicenseDescriptor().getDescription());
            buf.append("\n licenseRequired : " + this.getLicenseDescriptor().getLicenseRequiredValue());
        }
        buf.append("\n resourceAdapterClass : " + this.resourceAdapterClass);
        buf.append("\n resourceAdapterClass [" + this.resourceAdapterClass + "] config properties :");
        this.appendConfigProperties(this.configProperties, buf);
        if (this.outboundRA == null) {
            buf.append("\n Outbound Resource Adapter NOT available");
        } else {
            Descriptor conf;
            buf.append("\n Outbound Resource Adapter Info : ");
            buf.append("\n connection-definitions: ");
            for (ConnectionDefDescriptor connectionDefDescriptor : this.outboundRA.getConnectionDefs()) {
                buf.append("\n------------\n");
                ConnectionDefDescriptor conDef = connectionDefDescriptor;
                buf.append("MCF : " + conDef.getManagedConnectionFactoryImpl() + ", ");
                buf.append("\n MCF [" + conDef.getManagedConnectionFactoryImpl() + "] config properties :");
                this.appendConfigProperties(conDef.getConfigProperties(), buf);
                buf.append("[CF Interface : " + conDef.getConnectionFactoryIntf() + "], ");
                buf.append("[CF Class : " + conDef.getConnectionFactoryImpl() + "], ");
                buf.append("[Connection Interface : " + conDef.getConnectionIntf() + "], ");
                buf.append("[Connection Class : " + conDef.getConnectionImpl() + "] ");
                buf.append("\n------------\n");
            }
            buf.append("\n transaction-support : " + this.outboundRA.getTransSupport());
            buf.append("\n authentication-mechanism: ");
            for (Descriptor descriptor : this.outboundRA.getAuthMechanisms()) {
                conf = (AuthMechanism)descriptor;
                buf.append("\n------------\n");
                buf.append("[Type : " + ((AuthMechanism)conf).getAuthMechType() + "], ");
                buf.append("[Interface : " + ((AuthMechanism)conf).getCredentialInterface() + "]");
                buf.append("\n------------");
            }
            buf.append("\n reauthenticate-support : " + this.outboundRA.getReauthenticationSupport());
            buf.append("\n security-permission : ");
            for (Descriptor descriptor : this.getSecurityPermissions()) {
                conf = (SecurityPermission)descriptor;
                buf.append("\n------------\n");
                buf.append("[persmission : " + ((SecurityPermission)conf).getPermission() + "], ");
                buf.append("[discription : " + conf.getDescription() + "]");
                buf.append("\n------------");
            }
        }
        if (this.inboundRA == null) {
            buf.append("\n Inbound Resource Adapter NOT available");
        } else {
            buf.append("\n Inbound Resource Adapter Info : ");
            buf.append("\n Message Listeners Info : ");
            for (Descriptor descriptor : this.inboundRA.getMessageListeners()) {
                buf.append("\n------------\n");
                MessageListener l = (MessageListener)descriptor;
                buf.append("[Type : " + l.getMessageListenerType() + "], ");
                buf.append("[AS Class : " + l.getActivationSpecClass() + "]");
                buf.append("\n------------ ");
            }
        }
        if (this.adminObjects.size() == 0) {
            buf.append("\n Admin Objects NOT available");
        } else {
            buf.append("\n Admin Objects Info : ");
            for (Descriptor descriptor : this.adminObjects) {
                buf.append("\n------------\n");
                AdminObject a = (AdminObject)descriptor;
                buf.append("[Type : " + a.getAdminObjectInterface() + "], ");
                buf.append("[Class : " + a.getAdminObjectClass() + "]");
                this.appendConfigProperties(a.getConfigProperties(), buf);
                buf.append("\n------------ ");
            }
        }
    }

    private StringBuffer appendConfigProperties(Set props, StringBuffer buf) {
        buf.append("\n------------");
        for (Object prop : props) {
            ConnectorConfigProperty config = (ConnectorConfigProperty)prop;
            buf.append("[Name : " + config.getName() + "], ");
            buf.append("[Value: " + config.getValue() + "], ");
            buf.append("[Type : " + config.getType() + "]");
            buf.append("[Confidential : " + config.isConfidential() + "]");
            buf.append("[Ignore : " + config.isIgnore() + "]");
            buf.append("[SupportsDynamicUpdates : " + config.isSupportsDynamicUpdates() + "]");
        }
        buf.append("\n------------");
        return buf;
    }

    @Override
    public ArchiveType getModuleType() {
        return DOLUtils.rarType();
    }

    @Override
    public DescriptorVisitor getTracerVisitor() {
        return new ConnectorTracerVisitor();
    }

    @Override
    public ComponentVisitor getBundleVisitor() {
        return new ConnectorValidator();
    }

    public MessageListener getSupportedMessageListener(String type2) {
        if (this.inboundRA == null) {
            return null;
        }
        for (MessageListener l : this.inboundRA.getMessageListeners()) {
            if (!l.getMessageListenerType().equals(type2)) continue;
            return l;
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public SunConnector getSunDescriptor() {
        return this.sunConnector;
    }

    public void setSunDescriptor(SunConnector connector) {
        this.sunConnector = connector;
    }

    public void addConnectorAnnotation(AnnotationInfo c) {
        this.connectorAnnotations.add(c);
    }

    public Set<AnnotationInfo> getConnectorAnnotations() {
        return this.connectorAnnotations;
    }

    public void setValidConnectorAnnotationProcessed(boolean processed) {
        this.validConnectorAnnotationProcessed = processed;
    }

    public boolean getValidConnectorAnnotationProcessed() {
        return this.validConnectorAnnotationProcessed;
    }

    public void addConfigPropertyAnnotation(String className, AnnotationInfo info) {
        Set<AnnotationInfo> configProperties = this.configPropertyAnnotations.get(className);
        if (configProperties == null) {
            configProperties = new HashSet<AnnotationInfo>();
            this.configPropertyAnnotations.put(className, configProperties);
        }
        configProperties.add(info);
    }

    public Collection<AnnotationInfo> getConfigPropertyAnnotations(String className) {
        return this.configPropertyAnnotations.get(className);
    }

    public Map<String, Set<AnnotationInfo>> getAllConfigPropertyAnnotations() {
        return this.configPropertyAnnotations;
    }

    public Set<String> getConfigPropertyProcessedClasses() {
        return this.configPropertyProcessedClasses;
    }

    public void addConfigPropertyProcessedClass(String className) {
        this.configPropertyProcessedClasses.add(className);
    }

    public Collection<SimpleJndiName> getDefaultResourcesNames() {
        return this.defaultResourceNames;
    }

    public void addDefaultResourceName(SimpleJndiName resourceName) {
        this.defaultResourceNames.add(resourceName);
    }
}

