/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.util;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.enterprise.connectors.util.ConnectorDDTransformUtils;
import com.sun.enterprise.connectors.util.MCFConfigParser;
import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.ConnectorConfigProperty;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.OutboundResourceAdapter;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MCFConfigParserImpl
implements MCFConfigParser {
    private static final Logger _logger = LogDomains.getLogger(MCFConfigParserImpl.class, "jakarta.enterprise.resource.resourceadapter");

    @Override
    public String[] getConnectionDefinitionNames(ConnectorDescriptor desc) throws ConnectorRuntimeException {
        if (desc == null) {
            throw new ConnectorRuntimeException("Invalid arguments");
        }
        ConnectionDefDescriptor[] cdd = ConnectorDDTransformUtils.getConnectionDefs(desc);
        String[] connDefNames = new String[cdd.length];
        for (int i = 0; i < cdd.length; ++i) {
            connDefNames[i] = cdd[i].getConnectionFactoryIntf();
        }
        return connDefNames;
    }

    @Override
    public Properties getJavaBeanProps(ConnectorDescriptor desc, String connectionDefName, String rarName) throws ConnectorRuntimeException {
        ConnectionDefDescriptor cdd = this.getConnectionDefinition(desc, connectionDefName);
        if (cdd == null) {
            return null;
        }
        Properties mergedVals = null;
        Set<ConnectorConfigProperty> ddVals = cdd.getConfigProperties();
        String className = cdd.getManagedConnectionFactoryImpl();
        if (className != null && className.length() != 0) {
            Properties introspectedVals = configParserUtil.introspectJavaBean(className, ddVals, true, rarName);
            mergedVals = configParserUtil.mergeProps(ddVals, introspectedVals);
        }
        return mergedVals;
    }

    private ConnectionDefDescriptor getConnectionDefinition(ConnectorDescriptor desc, String connectionDefName) throws ConnectorRuntimeException {
        if (desc == null || connectionDefName == null) {
            throw new ConnectorRuntimeException("Invalid arguments");
        }
        OutboundResourceAdapter ora = desc.getOutboundResourceAdapter();
        if (ora == null || ora.getConnectionDefs().size() == 0) {
            return null;
        }
        Set<ConnectionDefDescriptor> connectionDefs = ora.getConnectionDefs();
        if (connectionDefs == null || connectionDefs.size() == 0) {
            return null;
        }
        Iterator<ConnectionDefDescriptor> iter = connectionDefs.iterator();
        ConnectionDefDescriptor cdd = null;
        boolean connectionDefFound = false;
        while (iter.hasNext()) {
            cdd = iter.next();
            if (!connectionDefName.equals(cdd.getConnectionFactoryIntf())) continue;
            connectionDefFound = true;
            break;
        }
        if (!connectionDefFound) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "No such connectiondefinition found in ra.xml", connectionDefName);
            }
            throw new ConnectorRuntimeException("No such connectiondefinition found in ra.xml : " + connectionDefName);
        }
        return cdd;
    }

    @Override
    public List<String> getConfidentialProperties(ConnectorDescriptor desc, String rarName, String ... keyFields) throws ConnectorRuntimeException {
        Set<ConnectorConfigProperty> configProperties;
        if (keyFields == null || keyFields.length == 0 || keyFields[0] == null) {
            throw new ConnectorRuntimeException("ConnectionDefinitionName must be specified");
        }
        ConnectionDefDescriptor cdd = this.getConnectionDefinition(desc, keyFields[0]);
        ArrayList<String> confidentialProperties = new ArrayList<String>();
        if (cdd != null && (configProperties = cdd.getConfigProperties()) != null) {
            for (ConnectorConfigProperty ccp : configProperties) {
                if (!ccp.isConfidential()) continue;
                confidentialProperties.add(ccp.getName());
            }
        }
        return confidentialProperties;
    }
}

