/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.service;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.appserv.connectors.internal.spi.ConnectorNamingEvent;
import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.connectors.ConnectorDescriptorInfo;
import com.sun.enterprise.connectors.naming.ConnectorNamingEventNotifier;
import com.sun.enterprise.connectors.naming.ConnectorResourceNamingEventNotifier;
import com.sun.enterprise.connectors.service.ConnectorAdminServiceUtils;
import com.sun.enterprise.connectors.service.ConnectorService;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.resourcebase.resources.api.PoolInfo;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.glassfish.resourcebase.resources.naming.ResourceNamingService;
import org.glassfish.resources.naming.SerializableObjectRefAddr;

public class ConnectorResourceAdminServiceImpl
extends ConnectorService {
    private final ResourceNamingService namingService;

    public ConnectorResourceAdminServiceImpl() {
        this.namingService = this._runtime.getResourceNamingService();
    }

    public void createConnectorResource(ResourceInfo resourceInfo, PoolInfo poolInfo, String resourceType) throws ConnectorRuntimeException {
        ConnectorConnectionPool ccp = null;
        SimpleJndiName jndiNameForPool = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(poolInfo);
        try {
            ccp = (ConnectorConnectionPool)this.namingService.lookup(poolInfo, jndiNameForPool);
        }
        catch (NamingException ne) {
            _logger.log(Level.INFO, "Probably the pool {0} is not yet initialized (lazy-loading), trying to check ...", poolInfo);
            try {
                this.checkAndLoadPool(poolInfo);
                ccp = (ConnectorConnectionPool)this.namingService.lookup(poolInfo, jndiNameForPool);
            }
            catch (NamingException e) {
                throw new ConnectorRuntimeException("Failed to lookup pool name " + String.valueOf(jndiNameForPool) + " or " + String.valueOf(poolInfo), ne);
            }
        }
        ConnectorDescriptorInfo cdi = ccp.getConnectorDescriptorInfo();
        Reference ref = new Reference(cdi.getConnectionFactoryClass(), "com.sun.enterprise.resource.naming.ConnectorObjectFactory", null);
        RefAddr addr = new SerializableObjectRefAddr(PoolInfo.class.getName(), poolInfo);
        ref.add(addr);
        addr = new StringRefAddr("rarName", cdi.getRarName());
        ref.add(addr);
        SerializableObjectRefAddr resAddr = new SerializableObjectRefAddr(ResourceInfo.class.getName(), resourceInfo);
        ref.add(resAddr);
        try {
            this.namingService.publishObject(resourceInfo, ref, true);
            _registry.addResourceInfo(resourceInfo);
        }
        catch (NamingException ne) {
            throw new ConnectorRuntimeException("Failed to publish connection factory for " + String.valueOf(poolInfo), ne);
        }
        ConnectorResourceNamingEventNotifier.getInstance().notifyListeners(new ConnectorNamingEvent(resourceInfo.getName(), 0));
    }

    public void deleteConnectorResource(ResourceInfo resourceInfo) throws ConnectorRuntimeException {
        try {
            this.namingService.unpublishObject(resourceInfo);
        }
        catch (NamingException ne) {
            if (ne instanceof NameNotFoundException) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "rardeployment.connectorresource_removal_from_jndi_error", resourceInfo);
                    _logger.log(Level.FINE, "", ne);
                }
                return;
            }
            throw new ConnectorRuntimeException("Failed to delete connector resource from jndi", ne);
        }
        finally {
            _registry.removeResourceInfo(resourceInfo);
        }
    }

    public ConnectorNamingEventNotifier getResourceRebindEventNotifier() {
        return ConnectorResourceNamingEventNotifier.getInstance();
    }

    public <T> T lookup(ResourceInfo resourceInfo) throws NamingException {
        SimpleJndiName jndiName;
        Hashtable<String, String> env;
        _logger.log(Level.FINEST, "lookup(resourceInfo={0})", resourceInfo);
        String suffix = ConnectorsUtil.getValidSuffix(resourceInfo.getName());
        if (suffix == null) {
            env = null;
            jndiName = resourceInfo.getName();
        } else {
            env = new Hashtable<String, String>();
            env.put("com.sun.enterprise.connectors.jndisuffix", suffix);
            jndiName = resourceInfo.getName().removeSuffix(suffix);
        }
        ResourceInfo actualResourceInfo = new ResourceInfo(jndiName, resourceInfo.getApplicationName(), resourceInfo.getModuleName());
        return this.namingService.lookup(actualResourceInfo, actualResourceInfo.getName(), env);
    }
}

