/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.deployment.annotation.handlers;

import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.annotation.context.RarBundleContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractHandler;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.resource.spi.Connector;
import jakarta.resource.spi.SecurityPermission;
import java.lang.annotation.Annotation;
import java.util.logging.Level;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.apf.ResultType;
import org.glassfish.apf.impl.HandlerProcessingResultImpl;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=SecurityPermission.class)
public class SecurityPermissionHandler
extends AbstractHandler {
    protected static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(SecurityPermissionHandler.class);

    @Override
    public HandlerProcessingResult processAnnotation(AnnotationInfo element) throws AnnotationProcessorException {
        AnnotatedElementHandler aeHandler = element.getProcessingContext().getHandler();
        SecurityPermission securityPermission = (SecurityPermission)element.getAnnotation();
        if (aeHandler instanceof RarBundleContext) {
            boolean isConnectionDefinition = this.hasConnectorAnnotation(element);
            if (isConnectionDefinition) {
                RarBundleContext rarContext = (RarBundleContext)aeHandler;
                ConnectorDescriptor desc = rarContext.getDescriptor();
                String firstDesc = "";
                if (securityPermission.description().length > 0) {
                    firstDesc = securityPermission.description()[0];
                }
                com.sun.enterprise.deployment.SecurityPermission permission = new com.sun.enterprise.deployment.SecurityPermission(firstDesc, securityPermission.permissionSpec());
                desc.addSecurityPermission(permission);
            } else {
                this.getFailureResult(element, "Not a @Connector annotation : @SecurityPermission must be specified along with @Connector annotation", true);
            }
        } else {
            this.getFailureResult(element, "Not a rar bundle context", true);
        }
        return this.getDefaultProcessedResult();
    }

    @Override
    public Class<? extends Annotation>[] getTypeDependencies() {
        return this.getConnectorAnnotationTypes();
    }

    @Override
    protected HandlerProcessingResult getDefaultProcessedResult() {
        return HandlerProcessingResultImpl.getDefaultResult(this.getAnnotationType(), ResultType.PROCESSED);
    }

    private boolean hasConnectorAnnotation(AnnotationInfo element) {
        Class c = (Class)element.getAnnotatedElement();
        return c.getAnnotation(Connector.class) != null;
    }

    private HandlerProcessingResultImpl getFailureResult(AnnotationInfo element, String message, boolean doLog) {
        HandlerProcessingResultImpl result = new HandlerProcessingResultImpl();
        result.addResult(this.getAnnotationType(), ResultType.FAILED);
        if (doLog) {
            Class c = (Class)element.getAnnotatedElement();
            String className = c.getName();
            Object[] args = new Object[]{element.getAnnotation(), className, message};
            String localString = localStrings.getLocalString("enterprise.deployment.annotation.handlers.connectorannotationfailure", "failed to handle annotation [ {0} ] on class [ {1} ], reason : {2}", args);
            logger.log(Level.WARNING, localString);
        }
        return result;
    }
}

