/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.deployment.annotation.handlers;

import com.sun.enterprise.deployment.ConnectionFactoryDefinitionDescriptor;
import com.sun.enterprise.deployment.MetadataSource;
import com.sun.enterprise.deployment.ResourceDescriptor;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractResourceHandler;
import com.sun.enterprise.deployment.annotation.handlers.ResourceAnnotationControl;
import jakarta.resource.ConnectionFactoryDefinition;
import java.lang.annotation.Annotation;
import java.util.Properties;
import java.util.Set;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=ConnectionFactoryDefinition.class)
public class ConnectionFactoryDefinitionHandler
extends AbstractResourceHandler {
    private static final ResourceAnnotationControl CTRL = new ResourceAnnotationControl(ConnectionFactoryDefinition.class);

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, ResourceContainerContext[] rcContexts) throws AnnotationProcessorException {
        ConnectionFactoryDefinition connectorFactoryDefnAn = (ConnectionFactoryDefinition)ainfo.getAnnotation();
        return this.processAnnotation(connectorFactoryDefnAn, ainfo, rcContexts);
    }

    protected HandlerProcessingResult processAnnotation(ConnectionFactoryDefinition connectorFactoryDefnAn, AnnotationInfo aiInfo, ResourceContainerContext[] rcContexts) throws AnnotationProcessorException {
        Class annotatedClass = (Class)aiInfo.getAnnotatedElement();
        Annotation[] annotations = annotatedClass.getAnnotations();
        boolean warClass = this.isAWebComponentClass(annotations);
        boolean ejbClass = this.isAEjbComponentClass(annotations);
        for (ResourceContainerContext context : rcContexts) {
            ConnectionFactoryDefinitionDescriptor desc;
            if (!CTRL.canProcessAnnotation(annotatedClass, ejbClass, warClass, context)) {
                return this.getDefaultProcessedResult();
            }
            Set<ResourceDescriptor> cfdDescs = context.getResourceDescriptors(JavaEEResourceType.CFD);
            if (this.isDefinitionAlreadyPresent(cfdDescs, desc = this.createDescriptor(connectorFactoryDefnAn))) {
                this.merge(cfdDescs, connectorFactoryDefnAn);
                continue;
            }
            context.addResourceDescriptor(desc);
        }
        return this.getDefaultProcessedResult();
    }

    private boolean isDefinitionAlreadyPresent(Set<ResourceDescriptor> cfdDescs, ConnectionFactoryDefinitionDescriptor desc) {
        boolean result = false;
        for (ResourceDescriptor descriptor : cfdDescs) {
            if (!descriptor.equals(desc)) continue;
            result = true;
            break;
        }
        return result;
    }

    private void merge(Set<ResourceDescriptor> cfdDescs, ConnectionFactoryDefinition defn) {
        for (ResourceDescriptor orgDesc : cfdDescs) {
            ConnectionFactoryDefinitionDescriptor desc = (ConnectionFactoryDefinitionDescriptor)orgDesc;
            if (!desc.getName().equals(defn.name())) continue;
            if (desc.getDescription() == null && defn.description() != null && !defn.description().isEmpty()) {
                desc.setDescription(defn.description());
            }
            if (desc.getInterfaceName() == null || desc.getInterfaceName().trim().isEmpty()) {
                desc.setInterfaceName(defn.interfaceName());
            }
            if (desc.getResourceAdapter() == null || desc.getResourceAdapter().trim().isEmpty()) {
                desc.setResourceAdapter(defn.resourceAdapter());
            }
            if (!desc.isTransactionSupportSet()) {
                desc.setTransactionSupport(defn.transactionSupport().toString());
            }
            if (desc.getMaxPoolSize() < 0) {
                desc.setMaxPoolSize(defn.maxPoolSize());
            }
            if (desc.getMinPoolSize() < 0) {
                desc.setMinPoolSize(defn.minPoolSize());
            }
            Properties properties = desc.getProperties();
            String[] defnProperties = defn.properties();
            if (defnProperties.length <= 0) break;
            for (String property : defnProperties) {
                int index = property.indexOf(61);
                if (index <= 0 || index >= property.length() - 1) continue;
                String name = property.substring(0, index);
                String value = property.substring(index + 1);
                if (properties.get(name) != null) continue;
                properties.put(name, value);
            }
        }
    }

    private ConnectionFactoryDefinitionDescriptor createDescriptor(ConnectionFactoryDefinition defn) {
        ConnectionFactoryDefinitionDescriptor desc = new ConnectionFactoryDefinitionDescriptor();
        desc.setMetadataSource(MetadataSource.ANNOTATION);
        desc.setName(defn.name());
        desc.setResourceAdapter(defn.resourceAdapter());
        desc.setInterfaceName(defn.interfaceName());
        desc.setTransactionSupport(defn.transactionSupport().toString());
        desc.setMaxPoolSize(defn.maxPoolSize());
        desc.setMinPoolSize(defn.minPoolSize());
        if (defn.description() != null && !defn.description().isEmpty()) {
            desc.setDescription(defn.description());
        }
        if (defn.properties() != null) {
            Properties properties = desc.getProperties();
            String[] defnProperties = defn.properties();
            if (defnProperties.length > 0) {
                for (String property : defnProperties) {
                    int index = property.indexOf("=");
                    if (index <= 0 || index >= property.length() - 1) continue;
                    String name = property.substring(0, index);
                    String value = property.substring(index + 1);
                    properties.put(name.trim(), value.trim());
                }
            }
        }
        return desc;
    }
}

