/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.util;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.net.NetUtils;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Objects;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.config.support.GlassFishConfigBean;
import org.glassfish.config.support.PropertyResolver;
import org.glassfish.embeddable.GlassFishVariable;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.jvnet.hk2.config.Dom;

public final class ServerHelper {
    private final Server server;
    private final Config config;

    public ServerHelper(Server theServer, Config theConfig) {
        this.server = theServer;
        this.config = theConfig;
        if (this.server == null || this.config == null) {
            throw new IllegalArgumentException();
        }
    }

    public final int getAdminPort() {
        try {
            String portString = ServerHelper.getAdminPortString(this.server, this.config);
            if (portString == null) {
                return -1;
            }
            return Integer.parseInt(portString);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public final String getAdminHost() {
        String addr = ServerHelper.translateAddressAndPort(ServerHelper.getAdminListener(this.config), this.server, this.config)[0];
        if (addr != null && !addr.equals("0.0.0.0")) {
            return addr;
        }
        Dom serverDom = Objects.requireNonNull(Dom.unwrap(this.server));
        Domain domain = serverDom.getHabitat().getService(Domain.class, new Annotation[0]);
        Nodes nodes = serverDom.getHabitat().getService(Nodes.class, new Annotation[0]);
        ServerEnvironment env = serverDom.getHabitat().getService(ServerEnvironment.class, new Annotation[0]);
        if (this.server.isDas()) {
            if (env.isDas()) {
                return System.getProperty(GlassFishVariable.HOST_NAME.getSystemPropertyName());
            }
            return null;
        }
        String hostName = null;
        String nodeName = this.server.getNodeRef();
        if (StringUtils.ok(nodeName)) {
            Node node = nodes.getNode(nodeName);
            if (node != null) {
                hostName = node.getNodeHost();
            }
            if (hostName == null && nodeName.equals("localhost-" + domain.getName())) {
                hostName = "localhost";
            }
        }
        if (StringUtils.ok(hostName)) {
            return hostName;
        }
        return null;
    }

    public final boolean isListeningOnAdminPort() {
        try {
            return NetUtils.isRunning(this.getAdminHost(), this.getAdminPort());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static NetworkListener getAdminListener(Config config) {
        NetworkConfig networkConfig = config.getNetworkConfig();
        if (networkConfig == null) {
            throw new IllegalStateException("Can't operate without <http-service>");
        }
        List<NetworkListener> listeners = networkConfig.getNetworkListeners().getNetworkListener();
        if (listeners == null || listeners.isEmpty()) {
            throw new IllegalStateException("Can't operate without at least one <network-listener>");
        }
        for (NetworkListener listener : listeners) {
            if (!"admin-listener".equals(listener.getName())) continue;
            return listener;
        }
        return listeners.get(0);
    }

    private static String getAdminPortString(Server server, Config config) {
        if (server == null || config == null) {
            return null;
        }
        return ServerHelper.translateAddressAndPort(ServerHelper.getAdminListener(config), server, config)[1];
    }

    private static String[] translateAddressAndPort(NetworkListener adminListener, Server server, Config config) {
        String[] ret = new String[2];
        String portString = null;
        String addressString = null;
        try {
            Dom serverDom = Objects.requireNonNull(Dom.unwrap(server));
            Domain domain = serverDom.getHabitat().getService(Domain.class, new Annotation[0]);
            NetworkListener adminListenerRaw = GlassFishConfigBean.getRawView(adminListener);
            portString = adminListenerRaw.getPort();
            addressString = adminListenerRaw.getAddress();
            PropertyResolver resolver = new PropertyResolver(domain, server.getName());
            ret[1] = ServerHelper.isToken(portString) ? resolver.getPropertyValue(portString) : portString;
            ret[0] = ServerHelper.isToken(addressString) ? resolver.getPropertyValue(addressString) : addressString;
        }
        catch (ClassCastException e) {
            ret[0] = ServerHelper.translatePortOld(addressString, server, config);
            ret[1] = ServerHelper.translatePortOld(portString, server, config);
        }
        return ret;
    }

    private static String translatePortOld(String portString, Server server, Config config) {
        if (!ServerHelper.isToken(portString)) {
            return portString;
        }
        String key = portString.substring(2, portString.length() - 1);
        SystemProperty prop = server.getSystemProperty(key);
        if (prop != null) {
            return prop.getValue();
        }
        prop = config.getSystemProperty(key);
        if (prop != null) {
            return prop.getValue();
        }
        return null;
    }

    private static boolean isToken(String s) {
        return s != null && s.startsWith("${") && s.endsWith("}") && s.length() > 3;
    }
}

