/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.CopyConfig;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.RefContainer;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.config.serverbeans.SystemPropertyBag;
import com.sun.enterprise.config.serverbeans.customvalidators.ConfigRefConstraint;
import com.sun.enterprise.config.serverbeans.customvalidators.ConfigRefValidator;
import com.sun.enterprise.config.serverbeans.customvalidators.NotDuplicateTargetName;
import com.sun.enterprise.config.serverbeans.customvalidators.NotTargetKeyword;
import com.sun.enterprise.config.serverbeans.customvalidators.ReferenceConstraint;
import com.sun.enterprise.config.util.ConfigApiLoggerInfo;
import com.sun.enterprise.config.util.InstanceRegisterInstanceCommandParameters;
import com.sun.enterprise.config.util.PortBaseHelper;
import com.sun.enterprise.config.util.PortManager;
import com.sun.enterprise.config.util.ServerHelper;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.net.NetUtils;
import jakarta.inject.Inject;
import jakarta.validation.Payload;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.beans.PropertyVetoException;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.admin.config.Named;
import org.glassfish.api.admin.config.PropertiesDesc;
import org.glassfish.api.admin.config.ReferenceContainer;
import org.glassfish.api.logging.LogHelper;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.config.support.CreationDecorator;
import org.glassfish.config.support.DeletionDecorator;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.quality.ToDo;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;
import org.jvnet.hk2.config.types.PropertyBag;

@Configured
@ConfigRefConstraint(message="{configref.invalid}", payload={ConfigRefValidator.class})
@NotDuplicateTargetName(message="{server.duplicate.name}", payload={Server.class})
@ReferenceConstraint(skipDuringCreation=true, payload={Server.class})
public interface Server
extends ConfigBeanProxy,
PropertyBag,
Named,
SystemPropertyBag,
ReferenceContainer,
RefContainer,
Payload {
    public static final String lbEnabledSystemProperty = "org.glassfish.lb-enabled-default";

    @Override
    @Param(name="name", primary=true)
    public void setName(String var1) throws PropertyVetoException;

    @Override
    @NotTargetKeyword(message="{server.reserved.name}", payload={Server.class})
    @Pattern(regexp="[A-Za-z0-9_][A-Za-z0-9\\-_\\.;]*", message="{server.invalid.name}", payload={Server.class})
    public @Pattern(regexp="[A-Za-z0-9_][A-Za-z0-9\\-_\\.;]*", message="{server.invalid.name}", payload={Server.class}) String getName();

    @Attribute
    @NotNull
    @NotTargetKeyword(message="{server.reserved.name}", payload={Server.class})
    @Pattern(regexp="[A-Za-z0-9_][A-Za-z0-9\\-_\\.;]*", message="Pattern: [A-Za-z0-9_][A-Za-z0-9\\-_\\.;]*")
    @ReferenceConstraint.RemoteKey(message="{resourceref.invalid.configref}", type=Config.class)
    public @NotNull @Pattern(regexp="[A-Za-z0-9_][A-Za-z0-9\\-_\\.;]*", message="Pattern: [A-Za-z0-9_][A-Za-z0-9\\-_\\.;]*") String getConfigRef();

    @Param(name="config", optional=true)
    public void setConfigRef(String var1) throws PropertyVetoException;

    @Attribute
    @Deprecated
    public String getNodeAgentRef();

    @Deprecated
    public void setNodeAgentRef(String var1) throws PropertyVetoException;

    @Param(name="node", optional=true)
    public void setNodeRef(String var1) throws PropertyVetoException;

    @Attribute
    public String getNodeRef();

    @Attribute(defaultValue="100")
    @Min(value=1L)
    public @Min(value=1L) String getLbWeight();

    public void setLbWeight(String var1) throws PropertyVetoException;

    @Override
    @ToDo(priority=ToDo.Priority.IMPORTANT, details="Provide PropertyDesc for legal system properties")
    @Element
    @Param(name="systemproperties", optional=true)
    public List<SystemProperty> getSystemProperty();

    @Override
    @ToDo(priority=ToDo.Priority.IMPORTANT, details="Provide PropertyDesc for legal props")
    @PropertiesDesc(props={})
    @Element
    @Param(name="properties", optional=true)
    public List<Property> getProperty();

    @Override
    default public String getReference() {
        return this.getConfigRef();
    }

    default public ResourceRef getResourceRef(SimpleJndiName refName) {
        for (ResourceRef resourceRef : this.getResourceRef()) {
            if (!resourceRef.getRef().equals(refName.toString())) continue;
            return resourceRef;
        }
        return null;
    }

    default public boolean isResourceRefExists(SimpleJndiName refName) {
        return this.getResourceRef(refName) != null;
    }

    default public void deleteResourceRef(SimpleJndiName refName) throws TransactionFailure {
        ResourceRef resourceRef = this.getResourceRef(refName);
        if (resourceRef != null) {
            ConfigSupport.apply(param -> param.getResourceRef().remove(resourceRef), this);
        }
    }

    default public void createResourceRef(String enabled, SimpleJndiName refName) throws TransactionFailure {
        ConfigSupport.apply(param -> {
            ResourceRef newResourceRef = param.createChild(ResourceRef.class);
            newResourceRef.setEnabled(enabled);
            newResourceRef.setRef(refName.toString());
            param.getResourceRef().add(newResourceRef);
            return newResourceRef;
        }, this);
    }

    default public ApplicationRef getApplicationRef(String appName) {
        for (ApplicationRef appRef : this.getApplicationRef()) {
            if (!appRef.getRef().equals(appName)) continue;
            return appRef;
        }
        return null;
    }

    default public Cluster getCluster() {
        ServiceLocator habitat = Objects.requireNonNull(Dom.unwrap(this)).getHabitat();
        Clusters clusters = habitat.getService(Clusters.class, new Annotation[0]);
        if (clusters != null) {
            for (Cluster cluster : clusters.getCluster()) {
                for (ServerRef serverRef : cluster.getServerRef()) {
                    if (!serverRef.getRef().equals(this.getName())) continue;
                    return cluster;
                }
            }
        }
        return null;
    }

    @Override
    default public boolean isCluster() {
        return false;
    }

    @Override
    default public boolean isServer() {
        return true;
    }

    @Override
    default public boolean isDas() {
        return "server".equals(this.getName());
    }

    @Override
    default public boolean isInstance() {
        String name = this.getName();
        return name != null && !name.equals("server");
    }

    default public String getAdminHost() {
        try {
            ServerHelper helper = new ServerHelper(this, this.getConfig());
            return helper.getAdminHost();
        }
        catch (Exception exception) {
            return null;
        }
    }

    default public int getAdminPort() {
        try {
            ServerHelper helper = new ServerHelper(this, this.getConfig());
            return helper.getAdminPort();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    default public Config getConfig() {
        try {
            ServiceLocator habitat = Objects.requireNonNull(Dom.unwrap(this)).getHabitat();
            Configs configs = habitat.getService(Configs.class, new Annotation[0]);
            String configName = this.getReference();
            for (Config config : configs.getConfig()) {
                if (!configName.equals(config.getName())) continue;
                return config;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    default public boolean isListeningOnAdminPort() {
        return new ServerHelper(this, this.getConfig()).isListeningOnAdminPort();
    }

    @Service
    @PerLookup
    public static class DeleteDecorator
    implements DeletionDecorator<Servers, Server> {
        @Inject
        Configs configs;
        @Inject
        private Domain domain;
        @Inject
        private ServerEnvironment env;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void decorate(AdminCommandContext context, Servers parent, Server child) throws PropertyVetoException, TransactionFailure {
            boolean isStandAlone;
            Logger logger2 = ConfigApiLoggerInfo.getLogger();
            LocalStringManagerImpl localStrings = new LocalStringManagerImpl(Server.class);
            ActionReport report = context.getActionReport();
            Transaction t = Transaction.getTransaction(parent);
            Cluster cluster = this.domain.getClusterForInstance(child.getName());
            boolean bl = isStandAlone = cluster == null;
            if (!isStandAlone && this.env.isDas()) {
                context.getActionReport().setResultType(String.class, cluster.getName());
            }
            if (isStandAlone) {
                String instanceConfig = child.getConfigRef();
                Config config = this.configs.getConfigByName(instanceConfig);
                if (config != null && this.domain.getReferenceContainersOf(config).size() > 1) {
                    return;
                }
                String autoGeneratedName = child.getName() + "-config";
                if (!autoGeneratedName.equals(instanceConfig)) {
                    return;
                }
                try {
                    if (config != null) {
                        File configConfigDir = new File(this.env.getConfigDirPath(), config.getName());
                        FileUtils.whack(configConfigDir);
                    }
                }
                catch (Exception configConfigDir) {
                    // empty catch block
                }
                try {
                    if (t == null) return;
                    Configs c = t.enroll(this.configs);
                    List<Config> configList = c.getConfig();
                    configList.remove(config);
                    return;
                }
                catch (TransactionFailure ex) {
                    LogHelper.log(logger2, Level.SEVERE, "NCLS-CFGAPI-00005", ex, instanceConfig);
                    String msg = ex.getMessage() != null ? ex.getMessage() : localStrings.getLocalString("deleteConfigFailed", "Unable to remove config {0}", instanceConfig);
                    report.setMessage(msg);
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    report.setFailureCause(ex);
                    throw ex;
                }
            }
            String instanceName = child.getName();
            if (t == null) return;
            try {
                Cluster c = t.enroll(cluster);
                List<ServerRef> serverRefList = c.getServerRef();
                ServerRef serverRef = null;
                for (ServerRef sr : serverRefList) {
                    if (!sr.getRef().equals(instanceName)) continue;
                    serverRef = sr;
                    break;
                }
                if (serverRef == null) return;
                serverRefList.remove(serverRef);
                return;
            }
            catch (TransactionFailure ex) {
                LogHelper.log(logger2, Level.SEVERE, "NCLS-CFGAPI-00013", ex, instanceName, cluster.getName());
                String msg = ex.getMessage() != null ? ex.getMessage() : localStrings.getLocalString("deleteServerRefFailed", "Unable to remove server-ref {0} from cluster {1}", instanceName, cluster.getName());
                report.setMessage(msg);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setFailureCause(ex);
                throw ex;
            }
        }
    }

    @Service
    @PerLookup
    public static class CreateDecorator
    implements CreationDecorator<Server> {
        @Param(name="cluster", optional=true)
        String clusterName;
        @Param(name="node", optional=true)
        String node = null;
        @Param(name="lbenabled", optional=true)
        String lbEnabled = null;
        @Param(name="checkports", optional=true, defaultValue="true")
        boolean checkPorts = true;
        @Param(name="portbase", optional=true)
        private String portBase;
        @Param(optional=true, defaultValue="false", shortName="t")
        public Boolean terse = false;
        @Inject
        Domain domain;
        @Inject
        private ServerEnvironment env;
        @Inject
        CommandRunner runner;

        @Override
        public void decorate(AdminCommandContext context, Server instance) throws TransactionFailure, PropertyVetoException {
            PortManager pm;
            String message;
            File lib;
            File docroot;
            File configConfigDir;
            Config ourConfig = null;
            PropertyBag ourCluster = null;
            Logger logger2 = ConfigApiLoggerInfo.getLogger();
            LocalStringManagerImpl localStrings = new LocalStringManagerImpl(Server.class);
            Transaction tx = Transaction.getTransaction(instance);
            String configRef = instance.getConfigRef();
            Clusters clusters = this.domain.getClusters();
            if (tx == null) {
                throw new TransactionFailure(localStrings.getLocalString("noTransaction", "Internal Error - Cannot obtain transaction object"));
            }
            if (this.node != null) {
                Node theNode = this.domain.getNodeNamed(this.node);
                if (theNode == null) {
                    throw new TransactionFailure(localStrings.getLocalString("noSuchNode", "Node {0} does not exist.", this.node));
                }
                if (!theNode.instanceCreationAllowed()) {
                    throw new TransactionFailure(localStrings.getLocalString("instanceCreationNotAllowed", "Instance creation is disabled on node {0}.", this.node));
                }
            }
            if (this.portBase != null) {
                PortBaseHelper pbh = new PortBaseHelper(instance, this.portBase, false, logger2);
                pbh.verifyPortBase();
                pbh.setPorts();
            }
            if (this.clusterName != null) {
                if (configRef != null) {
                    throw new TransactionFailure(localStrings.getLocalString("Server.cannotSpecifyBothConfigAndCluster", "A configuration name and cluster name cannot both be specified."));
                }
                if (clusters != null) {
                    for (Cluster cluster : clusters.getCluster()) {
                        if (cluster == null || !this.clusterName.equals(cluster.getName())) continue;
                        ourCluster = cluster;
                        String configName = cluster.getConfigRef();
                        instance.setConfigRef(configName);
                        ourConfig = this.domain.getConfigNamed(configName);
                        break;
                    }
                }
                if (ourCluster == null) {
                    throw new TransactionFailure(localStrings.getLocalString("noSuchCluster", "Cluster {0} does not exist.", this.clusterName));
                }
                if (ourCluster.getProperty("GMS_DISCOVERY_URI_LIST") != null && "generate".equals(ourCluster.getProperty("GMS_DISCOVERY_URI_LIST").getValue())) {
                    String propName = "GMS_LISTENER_PORT-" + ourCluster.getName();
                    Config serverConf = this.domain.getConfigNamed("server-config");
                    SystemProperty dasGmsPortProp = serverConf.getSystemProperty(propName);
                    if (dasGmsPortProp != null) {
                        SystemProperty gmsListenerPortProp = instance.createChild(SystemProperty.class);
                        gmsListenerPortProp.setName(propName);
                        gmsListenerPortProp.setValue(dasGmsPortProp.getValue());
                        instance.getSystemProperty().add(gmsListenerPortProp);
                    }
                }
                String instanceName = instance.getName();
                configConfigDir = new File(this.env.getConfigDirPath(), ourCluster.getConfigRef());
                docroot = new File(configConfigDir, "docroot");
                if (!docroot.exists() && !docroot.mkdirs()) {
                    throw new TransactionFailure(localStrings.getLocalString("noMkdir", "Cannot create configuration specific directory {0}", "docroot"));
                }
                lib = new File(configConfigDir, "lib/ext");
                if (!lib.exists() && !lib.mkdirs()) {
                    throw new TransactionFailure(localStrings.getLocalString("noMkdir", "Cannot create configuration specific directory {0}", "lib/ext"));
                }
                Cluster c = (Cluster)tx.enroll(ourCluster);
                ServerRef newServerRef = c.createChild(ServerRef.class);
                newServerRef.setRef(instanceName);
                if (this.lbEnabled != null) {
                    newServerRef.setLbEnabled(this.lbEnabled);
                } else {
                    List<ServerRef> serverRefs = c.getServerRef();
                    boolean allLBEnabled = false;
                    for (ServerRef serverRef : serverRefs) {
                        allLBEnabled = Boolean.parseBoolean(serverRef.getLbEnabled());
                    }
                    if (!allLBEnabled && serverRefs.size() > 0) {
                        newServerRef.setLbEnabled("false");
                    } else {
                        String lbEnabledDefault = System.getProperty(Server.lbEnabledSystemProperty);
                        if (lbEnabledDefault != null) {
                            newServerRef.setLbEnabled(lbEnabledDefault);
                        }
                    }
                }
                c.getServerRef().add(newServerRef);
            }
            if (configRef != null) {
                Config specifiedConfig = this.domain.getConfigs().getConfigByName(configRef);
                if (specifiedConfig == null) {
                    throw new TransactionFailure(localStrings.getLocalString("noSuchConfig", "Configuration {0} does not exist.", configRef));
                }
                ourConfig = specifiedConfig;
                configConfigDir = new File(this.env.getConfigDirPath(), specifiedConfig.getName());
                docroot = new File(configConfigDir, "docroot");
                if (!docroot.exists() && !docroot.mkdirs()) {
                    throw new TransactionFailure(localStrings.getLocalString("noMkdir", "Cannot create configuration specific directory {0}", "docroot"));
                }
                lib = new File(configConfigDir, "lib/ext");
                if (!lib.exists() && !lib.mkdirs()) {
                    throw new TransactionFailure(localStrings.getLocalString("noMkdir", "Cannot create configuration specific directory {0}", "lib/ext"));
                }
            }
            if (configRef == null && this.clusterName == null) {
                Config defaultConfig = this.domain.getConfigs().getConfigByName("default-config");
                if (defaultConfig == null) {
                    String msg = localStrings.getLocalString(Server.class, "Cluster.noDefaultConfig", "Can''t find the default config (an element named \"default-config\") in domain.xml.  You may specify the name of an existing config element next time.");
                    logger2.log(Level.SEVERE, "NCLS-CFGAPI-00012");
                    throw new TransactionFailure(msg);
                }
                String configName = instance.getName() + "-config";
                instance.setConfigRef(configName);
                CopyConfig command = (CopyConfig)this.runner.getCommand("copy-config", context.getActionReport());
                Configs configs = this.domain.getConfigs();
                Configs writableConfigs = tx.enroll(configs);
                ourConfig = command.copyConfig(writableConfigs, defaultConfig, configName, logger2);
            }
            for (Resource resource : this.domain.getResources().getResources()) {
                if (!Resource.copyToInstance(resource)) continue;
                String name = null;
                if (resource instanceof BindableResource) {
                    name = ((BindableResource)resource).getJndiName();
                }
                if (resource instanceof Named) {
                    name = ((Named)((Object)resource)).getName();
                }
                if (name == null) {
                    throw new TransactionFailure("Cannot add un-named resources to the new server instance");
                }
                ResourceRef newResourceRef = instance.createChild(ResourceRef.class);
                newResourceRef.setRef(name);
                instance.getResourceRef().add(newResourceRef);
            }
            for (Application application : this.domain.getApplications().getApplications()) {
                if (!application.getObjectType().equals("system-all") && !application.getObjectType().equals("system-instance")) continue;
                ApplicationRef newAppRef = instance.createChild(ApplicationRef.class);
                newAppRef.setRef(application.getName());
                instance.getApplicationRef().add(newAppRef);
            }
            this.addClusterRefs((Cluster)ourCluster, instance);
            if (this.checkPorts && (message = (pm = new PortManager((Cluster)ourCluster, ourConfig, this.domain, instance)).process()) != null && !this.terse.booleanValue()) {
                ActionReport report = context.getActionReport();
                report.setMessage(message);
            }
            this.checkAdminPort(instance, ourConfig, localStrings);
            this.setupSupplemental(context, instance);
        }

        private void checkAdminPort(Server instance, Config config, LocalStringManagerImpl localStrings) throws TransactionFailure {
            String nodeHost;
            Node n;
            if (this.node != null && (n = this.domain.getNodeNamed(this.node)) != null && NetUtils.isThisHostLocal(nodeHost = n.getNodeHost())) {
                int dasAdminPort = this.domain.getServerNamed("server").getAdminPort();
                int instanceAdminPort = new ServerHelper(instance, config).getAdminPort();
                if (instanceAdminPort != -1 && dasAdminPort != -1 && instanceAdminPort == dasAdminPort) {
                    throw new TransactionFailure(localStrings.getLocalString("Server.cannotHaveSameAdminPortAsDAS", "Cannot create an instance on the same host as DAS with the same admin port as DAS: {0}.", "" + instanceAdminPort));
                }
            }
        }

        private void setupSupplemental(AdminCommandContext context, Server instance) {
            if (this.clusterName != null) {
                InstanceRegisterInstanceCommandParameters cp = new InstanceRegisterInstanceCommandParameters();
                context.getActionReport().setResultType(InstanceRegisterInstanceCommandParameters.class, cp);
                Node instNode = this.domain.getNodeNamed(this.node);
                cp.config = instance.getConfigRef();
                cp.nodehost = instNode.getNodeHost();
                cp.nodedir = instNode.getNodeDir();
                cp.installdir = instNode.getInstallDir();
                List<SystemProperty> spList = instance.getSystemProperty();
                if (spList != null) {
                    Properties p = new Properties();
                    for (SystemProperty sp : spList) {
                        p.put(sp.getName(), sp.getValue());
                    }
                    cp.systemProperties = p;
                }
            }
        }

        private void addClusterRefs(Cluster cluster, Server instance) throws TransactionFailure, PropertyVetoException {
            if (cluster != null) {
                for (ApplicationRef appRef : cluster.getApplicationRef()) {
                    if (instance.getApplicationRef(appRef.getRef()) != null) continue;
                    ApplicationRef newAppRef = instance.createChild(ApplicationRef.class);
                    newAppRef.setRef(appRef.getRef());
                    newAppRef.setDisableTimeoutInMinutes(appRef.getDisableTimeoutInMinutes());
                    newAppRef.setEnabled(appRef.getEnabled());
                    newAppRef.setLbEnabled(appRef.getLbEnabled());
                    newAppRef.setVirtualServers(appRef.getVirtualServers());
                    instance.getApplicationRef().add(newAppRef);
                }
                for (ResourceRef rr : cluster.getResourceRef()) {
                    if (instance.getResourceRef(SimpleJndiName.of(rr.getRef())) != null) continue;
                    ResourceRef newRR = instance.createChild(ResourceRef.class);
                    newRR.setRef(rr.getRef());
                    newRR.setEnabled(rr.getEnabled());
                    instance.getResourceRef().add(newRR);
                }
            }
        }
    }
}

