/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.modularity.customization;

import com.sun.enterprise.config.modularity.ConfigModularityUtils;
import com.sun.enterprise.config.modularity.annotation.HasCustomizationTokens;
import com.sun.enterprise.config.modularity.customization.ConfigBeanDefaultValue;
import com.sun.enterprise.config.modularity.customization.ConfigCustomizationToken;
import com.sun.enterprise.config.util.ConfigApiLoggerInfo;
import com.sun.enterprise.module.single.StaticModulesRegistry;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.embeddable.GlassFishVariable;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.main.jdke.cl.GlassfishUrlClassLoader;

public class CustomizationTokensProvider {
    private static final Logger LOG = ConfigApiLoggerInfo.getLogger();
    private ServiceLocator locator;
    private ConfigModularityUtils mu;

    public List<ConfigCustomizationToken> getPresentConfigCustomizationTokens() throws NoSuchFieldException, IllegalAccessException {
        String runtimeType = "admin";
        this.initializeLocator();
        this.mu = this.locator.getService(ConfigModularityUtils.class, new Annotation[0]);
        List<Class> l = this.mu.getAnnotatedConfigBeans(HasCustomizationTokens.class);
        ArrayList<ConfigCustomizationToken> ctk = new ArrayList<ConfigCustomizationToken>();
        HashSet<Class> s = new HashSet<Class>();
        for (Class cls : l) {
            if (s.contains(cls)) continue;
            ctk.addAll(this.getTokens(cls, runtimeType));
            s.add(cls);
        }
        return ctk;
    }

    public List<ConfigCustomizationToken> getPresentDefaultConfigCustomizationTokens() throws NoSuchFieldException, IllegalAccessException {
        String runtimeType = "admin";
        this.initializeLocator();
        this.mu = this.locator.getService(ConfigModularityUtils.class, new Annotation[0]);
        List<Class> l = this.mu.getAnnotatedConfigBeans(HasCustomizationTokens.class);
        ArrayList<ConfigCustomizationToken> ctk = new ArrayList<ConfigCustomizationToken>();
        HashSet<Class> s = new HashSet<Class>();
        for (Class cls : l) {
            if (s.contains(cls)) continue;
            ctk.addAll(this.getTokens(cls, runtimeType));
            s.add(cls);
        }
        Iterator it = ctk.iterator();
        while (it.hasNext()) {
            ConfigCustomizationToken c = (ConfigCustomizationToken)it.next();
            if (c.getCustomizationType().equals((Object)ConfigCustomizationToken.CustomizationType.FILE) || c.getCustomizationType().equals((Object)ConfigCustomizationToken.CustomizationType.STRING)) {
                it.remove();
                continue;
            }
            int defaultPortNumberForDefaultConfig = Integer.parseInt(c.getValue()) + 20000;
            c.setValue(String.valueOf(defaultPortNumberForDefaultConfig));
        }
        return ctk;
    }

    private List<ConfigCustomizationToken> getTokens(Class configBean, String runtimeType) {
        ArrayList<ConfigCustomizationToken> ctk = new ArrayList<ConfigCustomizationToken>();
        List<ConfigBeanDefaultValue> defaultValues = this.mu.getDefaultConfigurations(configBean, runtimeType);
        for (ConfigBeanDefaultValue def : defaultValues) {
            ctk.addAll(def.getCustomizationTokens());
        }
        return ctk;
    }

    protected void initializeLocator() {
        File inst = new File(System.getProperty(GlassFishVariable.INSTALL_ROOT.getSystemPropertyName()));
        File ext = new File(inst, "modules");
        LOG.log(Level.FINE, "asadmin modules directory: {0}", ext);
        if (ext.isDirectory()) {
            PrivilegedAction<Void> action = () -> {
                try {
                    GlassfishUrlClassLoader classLoader = new GlassfishUrlClassLoader("HK2Modules", CustomizationTokensProvider.getJars(ext));
                    StaticModulesRegistry registry = new StaticModulesRegistry(classLoader);
                    this.locator = registry.createServiceLocator("default");
                }
                catch (IOException ex) {
                    LOG.log(Level.SEVERE, "NCLS-CFGAPI-00122", ex);
                }
                return null;
            };
            AccessController.doPrivileged(action);
        } else {
            LOG.log(Level.FINER, "Modules directory does not exist");
        }
    }

    private static URL[] getJars(File dir) throws IOException {
        File[] fjars = dir.listFiles((dir1, name) -> name.endsWith(".jar"));
        if (fjars == null) {
            throw new IOException("No Jar Files in the HK2Modules Directory!");
        }
        URL[] jars = new URL[fjars.length];
        for (int i = 0; i < fjars.length; ++i) {
            jars[i] = fjars[i].toURI().toURL();
        }
        return jars;
    }
}

