/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.modularity.command;

import com.sun.enterprise.config.modularity.ConfigModularityUtils;
import com.sun.enterprise.config.modularity.customization.ConfigBeanDefaultValue;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;

@Service
public class AbstractConfigModularityCommand {
    @Inject
    private ConfigModularityUtils configModularityUtils;
    @Inject
    ServiceLocator locator;
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");

    protected String replaceExpressionsWithValues(String location) {
        StringTokenizer tokenizer = new StringTokenizer(location, "/", false);
        while (tokenizer.hasMoreElements()) {
            String level = tokenizer.nextToken();
            if (!level.contains("[$")) continue;
            String expr = location.substring(location.indexOf("$"), location.indexOf("]"));
            String value = this.configModularityUtils.resolveExpression(expr);
            location = location.replace(expr, value);
        }
        return location;
    }

    protected Config getConfigForName(String targetName, ServiceLocator serviceLocator, Domain domain) {
        if (CommandTarget.CONFIG.isValid(serviceLocator, targetName)) {
            return domain.getConfigNamed(targetName);
        }
        if (CommandTarget.DAS.isValid(serviceLocator, targetName) || CommandTarget.STANDALONE_INSTANCE.isValid(serviceLocator, targetName)) {
            Server s = domain.getServerNamed(targetName);
            return s == null ? null : domain.getConfigNamed(s.getConfigRef());
        }
        if (CommandTarget.CLUSTER.isValid(serviceLocator, targetName)) {
            Cluster cl = domain.getClusterNamed(targetName);
            return cl == null ? null : domain.getConfigNamed(cl.getConfigRef());
        }
        return null;
    }

    protected Collection<AccessRequired.AccessCheck> getAccessChecksForDefaultValue(List<ConfigBeanDefaultValue> values, String target, List<String> actions2) {
        ArrayList<AccessRequired.AccessCheck> checks = new ArrayList<AccessRequired.AccessCheck>();
        for (ConfigBeanDefaultValue val : values) {
            String location = val.getLocation();
            for (String s : actions2) {
                AccessRequired.AccessCheck check = new AccessRequired.AccessCheck(this.configModularityUtils.getOwningObject(location), s, true);
                checks.add(check);
            }
        }
        return checks;
    }

    protected Collection<AccessRequired.AccessCheck> getAccessChecksForConfigBean(ConfigBeanProxy cbProxy, String target, List<String> actions2) {
        ArrayList<AccessRequired.AccessCheck> checks = new ArrayList<AccessRequired.AccessCheck>();
        for (String s : actions2) {
            AccessRequired.AccessCheck check = new AccessRequired.AccessCheck(cbProxy, s, true);
            checks.add(check);
        }
        return checks;
    }

    protected Collection<AccessRequired.AccessCheck> getAccessChecksForLocation(String location, List<String> actions2) {
        ArrayList<AccessRequired.AccessCheck> checks = new ArrayList<AccessRequired.AccessCheck>();
        for (String s : actions2) {
            AccessRequired.AccessCheck check = new AccessRequired.AccessCheck(this.replaceExpressionsWithValues(location), s);
            checks.add(check);
        }
        return checks;
    }
}

