/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.backup;

import com.sun.enterprise.backup.BackupException;
import com.sun.enterprise.backup.BackupRequest;
import com.sun.enterprise.backup.LoggerHelper;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;

abstract class BackupRestoreManager {
    BackupRequest request;
    private boolean wasInitialized = false;

    public BackupRestoreManager(BackupRequest req) throws BackupException {
        if (req == null) {
            throw new BackupException("backup-res.InternalError", this.getClass().getName() + ".ctor: null BackupRequest object");
        }
        this.request = req;
        this.init();
        LoggerHelper.finest("Request DUMP **********\n" + String.valueOf(req));
    }

    void init() throws BackupException {
        if (this.wasInitialized) {
            return;
        }
        if (this.request == null) {
            throw new BackupException("backup-res.InternalError", "null BackupRequest reference");
        }
        this.request.timestamp = System.currentTimeMillis();
        if (this.request.domainsDir == null || !FileUtils.safeIsDirectory(this.request.domainsDir)) {
            throw new BackupException("backup-res.NoDomainsDir", this.request.domainsDir);
        }
        if (this.request.domainName != null) {
            this.request.domainDir = new File(this.request.domainsDir, this.request.domainName);
        }
        LoggerHelper.setLevel(this.request);
    }

    protected File getBackupDirectory(BackupRequest request) {
        if (request.backupDir == null && request.backupConfig == null) {
            return new File(request.domainDir, "backups");
        }
        if (request.backupDir == null && request.backupConfig != null) {
            return new File(new File(request.domainDir, "backups"), request.backupConfig);
        }
        if (request.backupDir != null && request.backupConfig != null) {
            return new File(new File(request.backupDir, request.domainName), request.backupConfig);
        }
        return new File(request.backupDir, request.domainName);
    }
}

