/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.stringsubs.impl.algorithm;

import com.sun.enterprise.admin.servermgmt.SLogger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.main.jdke.i18n.LocalStringsImpl;

class RadixTreeNode {
    private static final Logger _logger = SLogger.getLogger();
    private static final LocalStringsImpl _strings = new LocalStringsImpl(RadixTreeNode.class);
    private String _key;
    private String _value;
    private Map<Character, RadixTreeNode> _childNodes;
    private RadixTreeNode _parentNode;

    RadixTreeNode(String key, String value) {
        this._key = key;
        this._value = value;
    }

    String getKey() {
        return this._key;
    }

    void setKey(String key) {
        this._key = key;
    }

    String getValue() {
        return this._value;
    }

    void setValue(String value) {
        this._value = value;
    }

    RadixTreeNode getParentNode() {
        return this._parentNode;
    }

    Collection<RadixTreeNode> getChildNodes() {
        if (this._childNodes != null) {
            return this._childNodes.values();
        }
        List<RadixTreeNode> list = Collections.emptyList();
        return list;
    }

    void addChildNode(RadixTreeNode node) {
        RadixTreeNode oldNode;
        if (node == null || node._key == null || node._key.isEmpty()) {
            throw new IllegalArgumentException(_strings.get("errorInEmptyNullKeyInstertion"));
        }
        char c = node._key.charAt(0);
        if (this._childNodes == null) {
            this._childNodes = new HashMap<Character, RadixTreeNode>();
        }
        if ((oldNode = this._childNodes.put(Character.valueOf(c), node)) != null) {
            _logger.log(Level.WARNING, "NCLS-SRVRMGMT-00035", new Object[]{this.toString(), oldNode.toString(), node.toString()});
            oldNode._parentNode = null;
        }
        node._parentNode = this;
    }

    void removeChildNode(RadixTreeNode node) {
        if (node == null || node._key == null || node._key.isEmpty()) {
            throw new IllegalArgumentException(_strings.get("invalidNodeKey"));
        }
        char c = node._key.charAt(0);
        if (this._childNodes != null) {
            RadixTreeNode matchedNode = this._childNodes.get(Character.valueOf(c));
            if (matchedNode == node) {
                node = this._childNodes.remove(Character.valueOf(c));
                node._parentNode = null;
            } else {
                throw new IllegalArgumentException(_strings.get("invalidChildNode", node, this));
            }
        }
    }

    RadixTreeNode getChildNode(char c) {
        return this._childNodes == null ? null : this._childNodes.get(Character.valueOf(c));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Node Key : " + this._key + ", Value : " + this._value);
        return buffer.toString();
    }
}

