/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.cli;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.remote.RemoteCLICommand;
import com.sun.enterprise.admin.servermgmt.cli.LocalDomainCommand;
import com.sun.enterprise.admin.servermgmt.cli.Strings;
import com.sun.enterprise.security.store.PasswordAdapter;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.universal.process.ProcessUtils;
import com.sun.enterprise.universal.xml.MiniXmlParser;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import com.sun.enterprise.util.HostAndPort;
import com.sun.enterprise.util.io.ServerDirs;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandException;
import org.glassfish.main.jdke.i18n.LocalStringsImpl;
import org.glassfish.main.jdke.security.KeyTool;

public abstract class LocalServerCommand
extends CLICommand {
    private static final LocalStringsImpl I18N = new LocalStringsImpl(LocalDomainCommand.class);
    private ServerDirs serverDirs;

    protected boolean checkForSpecialFiles() {
        return true;
    }

    protected final HostAndPort getAdminAddress() throws CommandException {
        String hostArg = this.programOpts.getPlainOption("host");
        String portArg = this.programOpts.getPlainOption("port");
        String secureArg = this.programOpts.getPlainOption("secure");
        HostAndPort xml = this.getAdminAddress("server");
        String host = hostArg == null ? (xml == null ? "localhost" : xml.getHost()) : hostArg;
        int port = portArg == null ? (xml == null ? 4848 : xml.getPort()) : Integer.parseInt(portArg);
        boolean secure = secureArg == null ? (xml == null ? false : xml.isSecure()) : Boolean.parseBoolean(secureArg);
        return new HostAndPort(host, port, secure);
    }

    protected final HostAndPort getAdminAddress(String serverName) throws CommandException {
        if (!this.isLocal()) {
            return new HostAndPort(this.programOpts.getHost(), this.programOpts.getPort(), this.programOpts.isSecure());
        }
        try {
            MiniXmlParser parser = new MiniXmlParser(this.getDomainXml(), serverName);
            List<HostAndPort> addrSet = parser.getAdminAddresses();
            if (addrSet.isEmpty()) {
                throw new CommandException(I18N.get("NoAdminPort"));
            }
            return addrSet.get(0);
        }
        catch (MiniXmlParserException ex) {
            throw new CommandException(I18N.get("NoAdminPortEx", ex), ex);
        }
    }

    protected final void setServerDirs(ServerDirs sd) {
        this.serverDirs = sd;
    }

    protected final boolean isLocal() {
        return this.serverDirs != null && this.serverDirs.getServerName() != null;
    }

    protected final void setLocalPassword() {
        String pw = this.serverDirs == null ? null : this.serverDirs.getLocalPassword();
        this.programOpts.setPassword(pw == null ? null : pw.toCharArray(), ProgramOptions.PasswordLocation.LOCAL_PASSWORD);
        logger.finer(LocalServerCommand.ok(pw) ? "Using local password" : "Not using local password");
    }

    protected final void unsetLocalPassword() {
        this.programOpts.setPassword(null, ProgramOptions.PasswordLocation.LOCAL_PASSWORD);
    }

    protected final void resetServerDirs() throws IOException {
        if (this.serverDirs == null) {
            throw new RuntimeException(Strings.get("NoServerDirs"));
        }
        this.serverDirs = this.serverDirs.refresh();
    }

    protected final ServerDirs getServerDirs() {
        return this.serverDirs;
    }

    protected final File getDomainXml() {
        if (this.serverDirs == null) {
            throw new RuntimeException(Strings.get("NoServerDirs"));
        }
        return this.serverDirs.getDomainXml();
    }

    protected final String readFromMasterPasswordFile() {
        File mpf = this.getMasterPasswordFile();
        if (mpf == null) {
            return null;
        }
        try {
            PasswordAdapter pw = new PasswordAdapter(mpf.getAbsolutePath(), "master-password".toCharArray());
            return pw.getPasswordForAlias("master-password");
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "A master password file reading error: " + e.toString(), e);
            return null;
        }
    }

    protected final boolean verifyMasterPassword(String mpv) {
        return this.loadAndVerifyKeystore(this.getJKS(), mpv);
    }

    protected boolean loadAndVerifyKeystore(File jks, String mpv) {
        logger.log(Level.FINEST, "loading keystore: " + String.valueOf(jks));
        if (jks == null || mpv == null) {
            return false;
        }
        try {
            new KeyTool(jks, mpv.toCharArray()).loadKeyStore();
            return true;
        }
        catch (Exception e) {
            logger.log(Level.FINER, e.getMessage(), e);
            return false;
        }
    }

    protected final String getMasterPassword() throws CommandException {
        int countOfRetries = 3;
        long start = System.currentTimeMillis();
        String mpv = (String)this.passwords.get("AS_ADMIN_MASTERPASSWORD");
        if (mpv == null) {
            mpv = "changeit";
            if (!this.verifyMasterPassword(mpv) && !this.verifyMasterPassword(mpv = this.readFromMasterPasswordFile())) {
                mpv = this.retry(3);
            }
        } else if (!this.verifyMasterPassword(mpv)) {
            mpv = this.retry(3);
        }
        logger.log(Level.FINER, "Time spent in master password extraction: {0} ms", System.currentTimeMillis() - start);
        return mpv;
    }

    protected final boolean isThisServer(File ourDir, String directoryKey) {
        if (!LocalServerCommand.ok(directoryKey)) {
            throw new NullPointerException(directoryKey);
        }
        ourDir = this.getUniquePath(ourDir);
        logger.log(Level.FINER, "Check if server is at location {0}", ourDir);
        try {
            RemoteCLICommand cmd = new RemoteCLICommand("__locations", this.programOpts, this.env);
            ActionReport report = cmd.executeAndReturnActionReport("__locations");
            String theirDirPath = report.findProperty(directoryKey);
            logger.log(Level.FINER, "Remote server has root directory {0}", theirDirPath);
            if (LocalServerCommand.ok(theirDirPath)) {
                File theirDir = this.getUniquePath(new File(theirDirPath));
                return theirDir.equals(ourDir);
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    protected final Long getServerPid() {
        Long pidFromFile = ProcessUtils.loadPid(this.getServerDirs().getPidFile());
        try {
            RemoteCLICommand command = new RemoteCLICommand("__locations", this.programOpts, this.env);
            ActionReport report = command.executeAndReturnActionReport("__locations");
            if (report.getActionExitCode() == ActionReport.ExitCode.SUCCESS) {
                long pidFromAdmin = Long.parseLong(report.findProperty("Pid"));
                if (pidFromFile == null || !pidFromFile.equals(pidFromAdmin)) {
                    logger.log(Level.SEVERE, "PID should be the same: PID from file = " + pidFromFile + ", pidFromAdmin = " + pidFromAdmin);
                }
                return pidFromAdmin;
            }
            return null;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "The server PID could not be resolved, sending PID from file: " + pidFromFile, e);
            return pidFromFile;
        }
    }

    protected final void waitForRestart(Long oldPid, HostAndPort oldAdminAddress, HostAndPort newAdminAddress, Duration timeout) throws CommandException {
        boolean stopped;
        logger.log(Level.FINEST, "waitForRestart(oldPid={0}, oldAdminAddress={1}, newAdminAddress={2}, timeout={3})", new Object[]{oldPid, oldAdminAddress, newAdminAddress, timeout});
        boolean printDots = !this.programOpts.isTerse();
        boolean bl = stopped = oldPid == null || ProcessUtils.waitWhileIsAlive(oldPid, timeout, printDots);
        if (!stopped) {
            throw new CommandException(I18N.get("restartDomain.noGFStart"));
        }
        logger.log(Level.CONFIG, "Server instance is stopped, now we wait for the start on {0}", newAdminAddress);
        this.programOpts.setHostAndPort(newAdminAddress);
        Supplier<Boolean> signStart = () -> {
            if (!ProcessUtils.isListening(newAdminAddress)) {
                return false;
            }
            try {
                this.resetServerDirs();
                this.setLocalPassword();
            }
            catch (Exception e) {
                logger.log(Level.FINEST, "The endpoint is alive, but we failed to reset the local password.", e);
                return false;
            }
            Long newPid = ProcessUtils.loadPid(this.getServerDirs().getPidFile());
            if (newPid == null) {
                return false;
            }
            logger.log(Level.FINEST, "The server pid is {0}", newPid);
            return ProcessUtils.isAlive(newPid);
        };
        if (!ProcessUtils.waitFor(signStart, timeout, printDots)) {
            throw new CommandException(I18N.get("restartDomain.noGFStart"));
        }
    }

    protected final long getUptime() throws CommandException {
        RemoteCLICommand cmd = new RemoteCLICommand("uptime", this.programOpts, this.env);
        String up = cmd.executeAndReturnOutput("uptime", "--milliseconds").trim();
        long up_ms = this.parseUptime(up);
        if (up_ms <= 0L) {
            throw new CommandException(I18N.get("restart.dasNotRunning"));
        }
        logger.log(Level.FINER, "server uptime: {0}", up_ms);
        return up_ms;
    }

    protected final boolean isRestartable() throws CommandException {
        String val;
        RemoteCLICommand cmd = new RemoteCLICommand("_get-runtime-info", this.programOpts, this.env);
        ActionReport report = cmd.executeAndReturnActionReport("_get-runtime-info");
        return report == null || !LocalServerCommand.ok(val = report.findProperty("restartable_value")) || !val.equals("false");
    }

    private long parseUptime(String up) {
        try {
            return Long.parseLong(up);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    private File getJKS() {
        if (this.serverDirs == null) {
            return null;
        }
        File mp = new File(new File(this.serverDirs.getServerDir(), "config"), "cacerts.p12");
        if (mp.canRead()) {
            return mp;
        }
        logger.log(Level.FINEST, "File does not exist or is not readable: {0}", mp);
        return null;
    }

    protected File getMasterPasswordFile() {
        if (this.serverDirs == null) {
            return null;
        }
        File mp = new File(this.serverDirs.getServerDir(), "master-password.p12");
        if (!mp.canRead()) {
            return null;
        }
        return mp;
    }

    private String retry(int times) throws CommandException {
        for (int i = 0; i < times; ++i) {
            String mpv;
            String prompt = I18N.get("mp.prompt", times - i);
            char[] mpvArr = super.readPassword(prompt);
            String string = mpv = mpvArr != null ? new String(mpvArr) : null;
            if (mpv == null) {
                throw new CommandException(I18N.get("no.console"));
            }
            if (this.verifyMasterPassword(mpv)) {
                return mpv;
            }
            if (i >= times - 1) continue;
            logger.info(I18N.get("retry.mp"));
        }
        throw new CommandException(I18N.get("mp.giveup", times));
    }

    private File getUniquePath(File f) {
        try {
            f = f.getCanonicalFile();
        }
        catch (IOException ioex) {
            f = SmartFile.sanitize(f);
        }
        return f;
    }
}

