/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt;

import com.sun.enterprise.admin.servermgmt.DomainException;
import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.admin.servermgmt.pe.PEFileLayout;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.net.NetUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.glassfish.main.jdke.security.KeyTool;

public class KeystoreManager {
    private static final String CERTIFICATE_DN_PREFIX = "CN=";
    private static final String CERTIFICATE_DN_SUFFIX = ",OU=GlassFish,O=Eclipse Foundation";
    public static final String CERTIFICATE_ALIAS = "s1as";
    public static final String INSTANCE_SECURE_ADMIN_ALIAS = "glassfish-instance";
    private static final String INSTANCE_CN_SUFFIX = "-instance";
    private static final StringManager _strMgr = StringManager.getManager(KeystoreManager.class);
    private PEFileLayout fileLayout;

    protected static String getCertificateDN(RepositoryConfig cfg, String CNSuffix) {
        String cn = KeystoreManager.getCNFromCfg(cfg);
        if (cn == null) {
            try {
                cn = NetUtils.getCanonicalHostName();
            }
            catch (Exception e) {
                cn = "localhost";
            }
        }
        return CERTIFICATE_DN_PREFIX + cn + (CNSuffix != null ? CNSuffix : "") + CERTIFICATE_DN_SUFFIX;
    }

    protected PEFileLayout getFileLayout(RepositoryConfig config) {
        if (this.fileLayout == null) {
            this.fileLayout = new PEFileLayout(config);
        }
        return this.fileLayout;
    }

    protected void createKeyStore(File keyStore, RepositoryConfig config, String masterPassword) throws DomainException {
        String dasCertDN = KeystoreManager.getDASCertDN(config);
        System.out.println(_strMgr.getString("CertificateDN", dasCertDN));
        try {
            KeyTool keyTool = new KeyTool(keyStore, masterPassword.toCharArray());
            keyTool.generateKeyPair(CERTIFICATE_ALIAS, dasCertDN, "RSA", 3650);
            String instanceCertDN = KeystoreManager.getInstanceCertDN(config);
            keyTool.generateKeyPair(INSTANCE_SECURE_ADMIN_ALIAS, instanceCertDN, "RSA", 3650);
        }
        catch (IOException e) {
            throw new DomainException(_strMgr.getString("SomeProblemWithKeytool"), e);
        }
    }

    protected final void copyCertificatesToTrustStore(File configRoot, String masterPassword) throws DomainException {
        File keyStore = new File(configRoot, "keystore.p12");
        File trustStore = new File(configRoot, "cacerts.p12");
        KeyTool keyTool = new KeyTool(keyStore, masterPassword.toCharArray());
        try {
            keyTool.copyCertificate(CERTIFICATE_ALIAS, trustStore);
            keyTool.copyCertificate(INSTANCE_SECURE_ADMIN_ALIAS, trustStore);
        }
        catch (IOException e) {
            throw new DomainException(_strMgr.getString("SomeProblemWithKeytool"), e);
        }
    }

    protected void changeKeystorePassword(String oldPassword, String newPassword, File keyStore) throws DomainException {
        if (oldPassword.equals(newPassword)) {
            return;
        }
        try {
            KeyTool keyTool = new KeyTool(keyStore, oldPassword.toCharArray());
            keyTool.changeKeyStorePassword(newPassword.toCharArray());
        }
        catch (IOException e) {
            throw new DomainException(_strMgr.getString("keyStorePasswordNotChanged", keyStore), e);
        }
    }

    protected void changeSSLCertificateDatabasePassword(RepositoryConfig config, String oldPassword, String newPassword) throws DomainException {
        File truststore;
        PEFileLayout layout = this.getFileLayout(config);
        File keystore = layout.getKeyStore();
        if (keystore.exists()) {
            this.changeKeystorePassword(oldPassword, newPassword, keystore);
        }
        if ((truststore = layout.getTrustStore()).exists()) {
            this.changeKeystorePassword(oldPassword, newPassword, truststore);
        }
    }

    protected void chmod(String args, File file) throws IOException {
        if (OS.isUNIX()) {
            if (args == null || file == null) {
                throw new IOException(_strMgr.getString("nullArg"));
            }
            if (!file.exists()) {
                throw new IOException(_strMgr.getString("fileNotFound"));
            }
            String[] argsString = args.split(" +");
            ArrayList<String> cmdList = new ArrayList<String>();
            cmdList.add("/bin/chmod");
            cmdList.addAll(Arrays.asList(argsString));
            cmdList.add(file.getAbsolutePath());
            new ProcessBuilder(cmdList).start();
        }
    }

    public static String getDASCertDN(RepositoryConfig cfg) {
        return KeystoreManager.getCertificateDN(cfg, null);
    }

    public static String getInstanceCertDN(RepositoryConfig cfg) {
        return KeystoreManager.getCertificateDN(cfg, INSTANCE_CN_SUFFIX);
    }

    private static String getCNFromCfg(RepositoryConfig cfg) {
        String option = (String)cfg.get("keytooloptions");
        if (option == null || option.length() == 0) {
            return null;
        }
        String value = KeystoreManager.getCNFromOption(option);
        if (value == null || value.length() == 0) {
            return null;
        }
        return value;
    }

    private static String getCNFromOption(String option) {
        return KeystoreManager.getValueFromOptionForName(option, "CN", true);
    }

    private static String getValueFromOptionForName(String option, String name, boolean ignoreNameCase) {
        String[] pairs;
        Pattern p = Pattern.compile(":");
        for (String pair : pairs = p.split(option)) {
            boolean found;
            p = Pattern.compile("=");
            String[] nv = p.split(pair);
            String n = nv[0].trim();
            String v = nv[1].trim();
            boolean bl = found = ignoreNameCase ? n.equalsIgnoreCase(name) : n.equals(name);
            if (!found) continue;
            return v;
        }
        return null;
    }
}

