/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.remote;

import com.sun.enterprise.admin.remote.RemoteRestAdminCommand;
import com.sun.enterprise.admin.remote.sse.GfSseInboundEvent;
import com.sun.enterprise.util.StringUtils;
import java.io.IOException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommandEventBroker;
import org.glassfish.api.admin.AdminCommandState;
import org.glassfish.main.jdke.i18n.LocalStringsImpl;

public class DetachListener
implements AdminCommandEventBroker.AdminCommandListener<GfSseInboundEvent> {
    private static final System.Logger LOG = System.getLogger(DetachListener.class.getName());
    private static final LocalStringsImpl I18N = new LocalStringsImpl(DetachListener.class);
    private final RemoteRestAdminCommand rac;
    private final boolean terse;

    public DetachListener(RemoteRestAdminCommand rac, boolean terse) {
        this.rac = rac;
        this.terse = terse;
    }

    @Override
    public void onAdminCommandEvent(String name, GfSseInboundEvent event) {
        LOG.log(System.Logger.Level.TRACE, "onAdminCommandEvent(name={0}, event={1})", name, event);
        try {
            AdminCommandState acs = event.getData(AdminCommandState.class, "application/json");
            String id = acs.getId();
            if (StringUtils.ok(id)) {
                if (this.terse) {
                    this.rac.closeSse(id, ActionReport.ExitCode.SUCCESS);
                } else {
                    this.rac.closeSse(I18N.get("detach.jobid", id), ActionReport.ExitCode.SUCCESS);
                }
            } else {
                LOG.log(System.Logger.Level.ERROR, I18N.getString("detach.noid", "Command was started but id was not retrieved. Cannot detach."));
            }
        }
        catch (IOException ex) {
            LOG.log(System.Logger.Level.ERROR, "Failed to retrieve event data.", (Throwable)ex);
        }
    }
}

